/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.engine.WhsyjsfAccountHelper;
import kd.taxc.totf.business.engine.task.RuleSettingTask;

public class WhsyjsfAccrualDataService {
    private static Log logger = LogFactory.getLog(WhsyjsfAccrualDataService.class);
    private static final String TOTF_WHSYJSF_JT_DETAIL = "totf_whsyjsf_jt_detail";
    private static final String TOTF_WHSYJT_ADJUST = "totf_whsyjt_adjust";
    private static final String TOTF_SHARINGPLAN = "totf_sharingplan";
    private static final String TOTF_EDIT_SHARINGPLAN = "totf_edit_sharingplan";
    private static final String TOTF_RULE_WHSYJSF = "totf_rule_whsyjsf";

    public static BigDecimal doCalcDetails(Long orgId, Date skssqq, Date skssqz, long id) {
        EngineModel engineModel = new EngineModel(String.valueOf(orgId), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            BigDecimal totalAmount;
            BigDecimal bigDecimal = totalAmount = WhsyjsfAccrualDataService.calAmount(orgId, engineModel, id);
            return bigDecimal;
        }
        catch (Throwable t) {
            try {
                h.markRollback();
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static BigDecimal calAmount(Long rootOrgId, EngineModel engineModel, long id) throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u8ba1\u63d0\u53d6\u6570");
        long start = System.currentTimeMillis();
        DynamicObject[] rules = WhsyjsfAccrualDataService.fetchRuleids(rootOrgId);
        if (rules.length == 0) {
            return BigDecimal.ZERO;
        }
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        futures.addAll(WhsyjsfAccrualDataService.calSummaryAccountByOrg(engineModel, id, rootOrgId));
        List detailList = EngineTask.getFutureList(futures);
        BigDecimal totalAmount = WhsyjsfAccountHelper.calcSumAmountByGroup(detailList);
        logger.info("\u7ed3\u675f\u6267\u884c\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u8ba1\u63d0\u53d6\u6570\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return totalAmount;
    }

    private static List<Future<Object>> calSummaryAccountByOrg(EngineModel engineModel, long id, Long orgid) {
        DynamicObject[] rules = WhsyjsfAccrualDataService.fetchRuleids(orgid);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DynamicObject rule : rules) {
            RuleSettingTask ruleSettingTask = new RuleSettingTask(orgid, engineModel, rule, rule.getDynamicObjectCollection("entryentity"), String.valueOf(id), TOTF_WHSYJSF_JT_DETAIL, DeclareTaxType.WHSYJSF.getBaseTaxId());
            futures.addAll(ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask));
        }
        return futures;
    }

    private static DynamicObject[] fetchRuleids(Long orgid) {
        QFilter q1 = new QFilter("orgentity.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("ruleentity.type", "=", (Object)"whsyjsfyzsr");
        DynamicObjectCollection shringPlanCollection = QueryServiceHelper.query((String)TOTF_SHARINGPLAN, (String)"id, ruleentity.ruleid as ruleid", (QFilter[])new QFilter[]{q1.and(q2)});
        List shringPlanIdList = shringPlanCollection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter q3 = new QFilter("planentity.id", "in", shringPlanIdList);
        QFilter q4 = new QFilter("sharetype", "=", (Object)"whsyjsf");
        DynamicObjectCollection sharingPlanCollection = QueryServiceHelper.query((String)TOTF_EDIT_SHARINGPLAN, (String)"id, planentity.id as planid", (QFilter[])new QFilter[]{q3.and(q4)});
        List sharingPlanIdList = sharingPlanCollection.stream().map(e -> e.getLong("planid")).collect(Collectors.toList());
        List sharingPlanRuleIdList = shringPlanCollection.stream().filter(s -> sharingPlanIdList.contains(s.getLong("id"))).map(s -> s.getLong("ruleid")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ruleIdFilter = new QFilter("id", "in", sharingPlanRuleIdList);
        QFilter rulePurposeFilter = new QFilter("rulepurpose", "like", (Object)"%sjjt%");
        QFilter qFilter = enableFilter.and(rulePurposeFilter).and(ruleIdFilter.or(orgFilter.and(ruletypeFilter)));
        DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)TOTF_RULE_WHSYJSF, (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return BusinessDataServiceHelper.load((Object[])ruleCollection.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_RULE_WHSYJSF));
    }
}

