/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.totf.business.engine.WhsyjsfAccountHelper;
import kd.taxc.totf.business.engine.task.RuleSettingTask;

public class WhsyjsfAutoCollectEngine {
    private static final String TOTF_RULE_WHSYJSF = "totf_rule_whsyjsf";
    private static final String TOTF_WHSYJSF_ACCOUNT = "totf_whsyjsf_account";
    private static final String TOTF_WHSYJSF_DETAIL = "totf_whsyjsf_detail";
    private static final String TOTF_DETAIL_ADJUST = "totf_whsydetail_adjust";
    private static final String TOTF_SHARINGPLAN = "totf_sharingplan";
    private static final String TOTF_EDIT_SHARINGPLAN = "totf_edit_sharingplan";
    private static Log logger = LogFactory.getLog(WhsyjsfAutoCollectEngine.class);

    public static boolean execute(EngineModel engineModel) {
        Long rootOrgId = Long.valueOf(engineModel.getOrgId());
        Date startDate = DateUtils.stringToDate((String)engineModel.getStartDate());
        Date endDate = DateUtils.stringToDate((String)engineModel.getEndDate());
        List<Long> orgList = Collections.singletonList(rootOrgId);
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            WhsyjsfAutoCollectEngine.deleteExistData(rootOrgId, startDate, endDate);
            boolean bl = WhsyjsfAutoCollectEngine.runEngine(rootOrgId, orgList, startDate, endDate, engineModel);
            return bl;
        }
        catch (Throwable t) {
            try {
                h.markRollback();
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static boolean runEngine(Long rootOrgId, List<Long> orgList, Date startDate, Date endDate, EngineModel engineModel) throws Exception {
        return WhsyjsfAutoCollectEngine.ruleCalculate(rootOrgId, orgList, startDate, endDate, engineModel);
    }

    private static boolean ruleCalculate(Long rootOrgId, List<Long> orgList, Date startDate, Date endDate, EngineModel engineModel) throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        long id = DBUtils.getLongId((String)TOTF_WHSYJSF_ACCOUNT);
        DynamicObject[] rules = WhsyjsfAutoCollectEngine.fetchRuleids(orgList.get(0));
        if (rules.length == 0) {
            return false;
        }
        DynamicObject summary = WhsyjsfAutoCollectEngine.getSummaryObject(id, rootOrgId, startDate, endDate, engineModel);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)rootOrgId);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            summary.set("taxoffice", (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
        }
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (Long orgid : orgList) {
            futures.addAll(WhsyjsfAutoCollectEngine.calSummaryAccountByOrg(engineModel, id, orgid));
        }
        List summaryAccountingList = EngineTask.getFutureList(futures);
        BigDecimal totalTaxableitem = WhsyjsfAccountHelper.calcSumAmountByGroup(summaryAccountingList);
        WhsyjsfAccountHelper.calculateAmounts(summary, totalTaxableitem);
        summaryList.add(summary);
        SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
        logger.info("\u7ed3\u675f\u6267\u884c\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return true;
    }

    private static List<Future<Object>> calSummaryAccountByOrg(EngineModel engineModel, long id, Long orgid) {
        DynamicObject[] rules = WhsyjsfAutoCollectEngine.fetchRuleids(orgid);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DynamicObject rule : rules) {
            RuleSettingTask ruleSettingTask = new RuleSettingTask(orgid, engineModel, rule, rule.getDynamicObjectCollection("entryentity"), String.valueOf(id), TOTF_WHSYJSF_DETAIL, DeclareTaxType.WHSYJSF.getBaseTaxId());
            futures.addAll(ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask));
        }
        return futures;
    }

    public static void deleteExistData(Long orgId, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
        DeleteServiceHelper.delete((String)TOTF_WHSYJSF_ACCOUNT, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        DeleteServiceHelper.delete((String)TOTF_WHSYJSF_DETAIL, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)TOTF_DETAIL_ADJUST, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
    }

    private static DynamicObject[] fetchRuleids(Long orgid) {
        QFilter q1 = new QFilter("orgentity.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("ruleentity.type", "=", (Object)"whsyjsfyzsr");
        DynamicObjectCollection shringPlanCollection = QueryServiceHelper.query((String)TOTF_SHARINGPLAN, (String)"id, ruleentity.ruleid as ruleid", (QFilter[])new QFilter[]{q1.and(q2)});
        List shringPlanIdList = shringPlanCollection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter q3 = new QFilter("planentity.id", "in", shringPlanIdList);
        QFilter q4 = new QFilter("sharetype", "=", (Object)"whsyjsf");
        DynamicObjectCollection sharingPlanCollection = QueryServiceHelper.query((String)TOTF_EDIT_SHARINGPLAN, (String)"id, planentity.id as planid", (QFilter[])new QFilter[]{q3.and(q4)});
        List sharingPlanIdList = sharingPlanCollection.stream().map(e -> e.getLong("planid")).collect(Collectors.toList());
        List sharingPlanRuleIdList = shringPlanCollection.stream().filter(s -> sharingPlanIdList.contains(s.getLong("id"))).map(s -> s.getLong("ruleid")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ruleIdFilter = new QFilter("id", "in", sharingPlanRuleIdList);
        QFilter rulePurposeFilter = new QFilter("rulepurpose", "like", (Object)"%nssb%");
        QFilter qFilter = enableFilter.and(rulePurposeFilter).and(ruleIdFilter.or(orgFilter.and(ruletypeFilter)));
        DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)TOTF_RULE_WHSYJSF, (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return BusinessDataServiceHelper.load((Object[])ruleCollection.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_RULE_WHSYJSF));
    }

    private static DynamicObject getSummaryObject(long id, Long rootOrgId, Date startDate, Date endDate, EngineModel engineModel) {
        DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)TOTF_WHSYJSF_ACCOUNT);
        if (engineModel.getCustom().get("entity") != null) {
            DynamicObject entity = (DynamicObject)engineModel.getCustom().get("entity");
            summary.set("rate", entity.get("rate"));
            summary.set("payperiod", entity.get("payperiod"));
        } else {
            summary.set("rate", engineModel.getCustom().get("rate"));
            summary.set("payperiod", engineModel.getCustom().get("payperiod"));
        }
        summary.set("id", (Object)id);
        summary.set("org", (Object)rootOrgId);
        summary.set("zspm", (Object)ZspmConstant.ID_WHSYJSF_ZPSM);
        summary.set("startdate", (Object)startDate);
        summary.set("enddate", (Object)endDate);
        summary.set("billstatus", (Object)"A");
        return summary;
    }
}

