/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.engine.task;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.RuleEngineDto;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class RuleSettingTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(RuleSettingTask.class);
    private int batchSize = 5;
    private Long orgId;
    private EngineModel model;
    private DynamicObject rule;
    private DynamicObjectCollection collection;
    private String serialno;
    private String detailTable;
    private Long taxcategory;

    public RuleSettingTask(Long orgId, EngineModel model, DynamicObject rule, DynamicObjectCollection collection, String serialno, String detailTable, Long taxcategory) {
        this.orgId = orgId;
        this.model = model;
        this.rule = rule;
        this.collection = collection;
        this.serialno = serialno;
        this.detailTable = detailTable;
        this.taxcategory = taxcategory;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long startTime = System.currentTimeMillis();
        String startDate = this.model.getStartDate();
        String endDate = this.model.getEndDate();
        Date start = DateUtils.stringToDate((String)startDate);
        Date end = DateUtils.stringToDate((String)endDate);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll(settings);
        RuleEngineDto ruleEngineDto = new RuleEngineDto(this.orgId, Long.valueOf(Long.parseLong(this.model.getOrgId())), start, end, this.detailTable, Collections.EMPTY_MAP, collection);
        ruleEngineDto.setTaxCategoryId(this.taxcategory);
        ruleEngineDto.setTaxaccountserialno(this.serialno);
        ruleEngineDto.setEnableGroupByMappingField(Boolean.TRUE);
        List objects = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getRuleEnginData", (Object[])new Object[]{ruleEngineDto});
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + ":" + objects.size());
        return objects;
    }
}

