/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.totf.business.engine.WaterFundHelper;

public class WaterFundAutoCollectEngineService {
    private static final String TOTF_WATER_FUND = "totf_water_fund";

    public static void PrepayAccountCalculate(Long rootOrgId, Date startDate, Date endDate, EngineModel engineModel, String declaration, Map<String, List<DynamicObject>> accountGroupByMap) {
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>(accountGroupByMap.size());
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(accountGroupByMap.size());
        for (List<DynamicObject> accountList : accountGroupByMap.values()) {
            ArrayList<DynamicObject> prepayDetailList = new ArrayList<DynamicObject>(1);
            List<String> declareserialnoList = accountList.stream().map(a -> a.getString("declareserialno")).collect(Collectors.toList());
            long id = DBUtils.getLongId((String)TOTF_WATER_FUND);
            DynamicObject summary = WaterFundAutoCollectEngineService.getSummaryObject(id, rootOrgId, startDate, endDate, engineModel, declaration);
            WaterFundAutoCollectEngineService.setPrepayDetailList(rootOrgId, startDate, endDate, prepayDetailList, accountList, declareserialnoList, id, summary);
            summary.set("taxoffice", (Object)accountList.get(0).getLong("taxoffice"));
            summary.set("prepaytype", (Object)accountList.get(0).getString("prepaytype"));
            summary.set("sourcedata", (Object)(StringUtil.isNotEmpty((CharSequence)accountList.get(0).getString("prepaytype")) ? "zzsprepay" : "autocollect"));
            BigDecimal totalTaxableitem = BigDecimalUtil.sumDynamicObjectAmount(prepayDetailList, (String)"amount");
            WaterFundHelper.calculateAmounts(summary, totalTaxableitem);
            summaryAccountingList.addAll(prepayDetailList);
            summaryList.add(summary);
        }
        SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
    }

    public static void setPrepayDetailList(Long rootOrgId, Date startDate, Date endDate, List<DynamicObject> summaryAccountingList, List<DynamicObject> accountList, List<String> declareserialnoList, long id, DynamicObject summary) {
        Optional<BigDecimal> reduce;
        DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,modifytime,declareserialno", (QFilter[])new QFilter[]{new QFilter("declareserialno", "in", declareserialnoList)});
        List modifytimeList = prepayDeclareQuery.stream().sorted(Comparator.comparing(s -> s.getDate("modifytime"))).collect(Collectors.toList());
        Optional<DynamicObject> first = accountList.stream().filter(s -> s.get("declareserialno").equals(((DynamicObject)modifytimeList.get(0)).get("declareserialno")) && s.get("entryentity.taxtype").equals(ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"WaterFundAutoCollectEngineService_0", (String)"taxc-totf", (Object[])new Object[0]))).findFirst();
        if (first.isPresent()) {
            summary.set("rate", (Object)BigDecimalUtil.toBigDecimal((Object)first.get().get("entryentity.prepayrate")));
        }
        if ((reduce = accountList.stream().filter(s -> startDate.compareTo(s.getDate("startdate")) <= 0 && endDate.compareTo(s.getDate("enddate")) >= 0).map(e -> e.getBigDecimal("entryentity.prepaybase")).reduce(BigDecimal::add)).isPresent()) {
            DynamicObject detailObject = BusinessDataServiceHelper.newDynamicObject((String)"totf_wafund_accunt_detail");
            detailObject.set("id", (Object)id);
            detailObject.set("taxaccountserialno", (Object)String.valueOf(id));
            detailObject.set("prepaytype", (Object)accountList.get(0).getString("prepaytype"));
            detailObject.set("org", (Object)rootOrgId);
            detailObject.set("skssqq", (Object)startDate);
            detailObject.set("skssqz", (Object)endDate);
            detailObject.set("taxorg", (Object)rootOrgId);
            detailObject.set("amount", (Object)reduce.get());
            summaryAccountingList.add(detailObject);
        }
    }

    public static DynamicObject getSummaryObject(long id, Long rootOrgId, Date startDate, Date endDate, EngineModel engineModel, String declaration) {
        DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)TOTF_WATER_FUND);
        if (engineModel.getCustom().get("entity") != null) {
            DynamicObject entity = (DynamicObject)engineModel.getCustom().get("entity");
            summary.set("rate", entity.get("rate"));
            summary.set("payperiod", entity.get("payperiod"));
        } else {
            summary.set("rate", engineModel.getCustom().get("rate"));
            summary.set("payperiod", engineModel.getCustom().get("payperiod"));
        }
        summary.set("id", (Object)id);
        summary.set("org", (Object)rootOrgId);
        summary.set("zspm", (Object)ZspmConstant.ID_DFSLJSJJ_ZPSM);
        summary.set("collectionitem", (Object)ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"WaterFundAutoCollectEngineService_0", (String)"taxc-totf", (Object[])new Object[0]));
        summary.set("startdate", (Object)startDate);
        summary.set("enddate", (Object)endDate);
        summary.set("billstatus", (Object)"A");
        summary.set("declaration", (Object)declaration);
        summary.set("sourcedata", (Object)"autocollect");
        String billno = DeclareServiceHelper.generateSBBNo((String)TOTF_WATER_FUND, (DynamicObject)summary, (String)rootOrgId.toString());
        summary.set("billno", (Object)billno);
        return summary;
    }
}

