/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.sjjt;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.totf.common.enums.TaxTypeEnum;

public class DraftService {
    public static List<String> getListColumns(String taxtype) {
        if (TaxTypeEnum.TAXTYPE_024.getNumber().equals(taxtype) || TaxTypeEnum.TAXTYPE_025.getNumber().equals(taxtype)) {
            return Lists.newArrayList((Object[])new String[]{"zsxm", "zspm", "yjfjs", "jcx", "jfyj", "zsbz", "kcs", "zsbl", "ynfe", "jmfe", "yjfe", "jtynfe"});
        }
        if (TaxTypeEnum.TAXTYPE_026.getNumber().equals(taxtype)) {
            return Lists.newArrayList((Object[])new String[]{"zsxm", "zspm", "yzsr", "jcx", "jfxse", "feerate", "ynfe", "jmfe", "yjfe", "jtynfe"});
        }
        if (TaxTypeEnum.TAXTYPE_023.getNumber().equals(taxtype) || TaxTypeEnum.TAXTYPE_034.getNumber().equals(taxtype) || TaxTypeEnum.TAXTYPE_036.getNumber().equals(taxtype)) {
            return Lists.newArrayList((Object[])new String[]{"zsxm", "zspm", "ysx", "jcx", "yssdl", "jfyj", "flhdwse", "sskcs", "ynfe", "jmfe", "yjfe", "jtynfe"});
        }
        if (TaxTypeEnum.TAXTYPE_027.getNumber().equals(taxtype)) {
            return Lists.newArrayList((Object[])new String[]{"zsxm", "zspm", "snzzzgzze", "snzzzgrsnew", "zapcjrjybl", "snsjapcjrjyrsnew", "snzzzgnpjgz", "ynfe", "jmfe", "yjfe", "jtynfe"});
        }
        return new ArrayList<String>();
    }

    public static Map<String, String> getTips(String taxtype) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (TaxTypeEnum.TAXTYPE_024.getNumber().equals(taxtype) || TaxTypeEnum.TAXTYPE_025.getNumber().equals(taxtype)) {
            map.put("jfyj", ResManager.loadKDString((String)"\u8ba1\u8d39\u4f9d\u636e=\u5e94\u7f34\u8d39\u57fa\u6570-\u51cf\u9664\u9879", (String)"DraftService_0", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("ynfe", ResManager.loadKDString((String)"\u5e94\u7eb3\u8d39\u989d=\uff08\u8ba1\u8d39\u4f9d\u636e*\u5f81\u6536\u6807\u51c6-\u6263\u9664\u6570\uff09*\u5f81\u6536\u6bd4\u4f8b", (String)"DraftService_1", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("jtynfe", ResManager.loadKDString((String)"\u8ba1\u63d0\u5e94\u7eb3\u8d39\u989d=\u5e94\u7eb3\u8d39\u989d-\u51cf\u514d\u8d39\u989d-\u5df2\u7f34\u8d39\u989d", (String)"DraftService_2", (String)"taxc-totf", (Object[])new Object[0]));
        }
        if (TaxTypeEnum.TAXTYPE_026.getNumber().equals(taxtype)) {
            map.put("jfxse", ResManager.loadKDString((String)"\u8ba1\u8d39\u9500\u552e\u989d=\u5e94\u5f81\u6536\u5165-\u51cf\u9664\u989d", (String)"DraftService_3", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("ynfe", ResManager.loadKDString((String)"\u5e94\u7eb3\u8d39\u989d=\u8ba1\u8d39\u9500\u552e\u989d*\u8d39\u7387", (String)"DraftService_4", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("jtynfe", ResManager.loadKDString((String)"\u8ba1\u63d0\u5e94\u7eb3\u8d39\u989d=\u5e94\u7eb3\u8d39\u989d-\u51cf\u514d\u8d39\u989d-\u5df2\u7f34\u8d39\u989d", (String)"DraftService_5", (String)"taxc-totf", (Object[])new Object[0]));
        }
        if (TaxTypeEnum.TAXTYPE_023.getNumber().equals(taxtype) || TaxTypeEnum.TAXTYPE_034.getNumber().equals(taxtype) || TaxTypeEnum.TAXTYPE_036.getNumber().equals(taxtype)) {
            map.put("jfyj", ResManager.loadKDString((String)"\u8ba1\u7a0e\uff08\u8d39\uff09\u4f9d\u636e=\uff08\u5e94\u7a0e\u9879-\u51cf\u9664\u9879\uff09*\u5e94\u7a0e\u6240\u5f97\u7387", (String)"DraftService_6", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("ynfe", ResManager.loadKDString((String)"\u5e94\u7eb3\u7a0e\uff08\u8d39\uff09\u989d=\u8ba1\u7a0e\uff08\u8d39\uff09\u4f9d\u636e*\uff08\u8d39\uff09\u7387\u6216\u5355\u4f4d\u7a0e\u989d-\u901f\u7b97\u6263\u9664\u6570", (String)"DraftService_7", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("jtynfe", ResManager.loadKDString((String)"\u8ba1\u63d0\u5e94\u7eb3\u7a0e\uff08\u8d39\uff09\u989d=\u5e94\u7eb3\u7a0e\uff08\u8d39\uff09\u989d-\u51cf\u514d\u7a0e\uff08\u8d39\uff09\u989d-\u5df2\u7f34\u7a0e\uff08\u8d39\uff09\u989d", (String)"DraftService_8", (String)"taxc-totf", (Object[])new Object[0]));
        }
        if (TaxTypeEnum.TAXTYPE_027.getNumber().equals(taxtype)) {
            map.put("snzzzgnpjgz", ResManager.loadKDString((String)"\u4e0a\u5e74\u5728\u804c\u804c\u5de5\u5e74\u5e73\u5747\u5de5\u8d44\uff08\u6216\u5f53\u5730\u793e\u4f1a\u5e73\u5747\u5de5\u8d44\u76842\u500d\uff09=\u4e0a\u5e74\u5728\u804c\u804c\u5de5\u5de5\u8d44\u603b\u989d\u00f7\u4e0a\u5e74\u5728\u804c\u804c\u5de5\u4eba\u6570", (String)"DraftService_9", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("ynfe", ResManager.loadKDString((String)"\u5e94\u7eb3\u8d39\u989d=\uff08\u4e0a\u5e74\u5728\u804c\u804c\u5de5\u4eba\u6570*\u5e94\u5b89\u6392\u6b8b\u75be\u4eba\u5c31\u4e1a\u6bd4\u4f8b-\u4e0a\u5e74\u5b9e\u9645\u5b89\u6392\u6b8b\u75be\u4eba\u5c31\u4e1a\u4eba\u6570\uff09*\u4e0a\u5e74\u5728\u804c\u804c\u5de5\u5e74\u5e73\u5747\u5de5\u8d44\uff08\u6216\u5f53\u5730\u793e\u4f1a\u5e73\u5747\u5de5\u8d44\u76842\u500d\uff09", (String)"DraftService_10", (String)"taxc-totf", (Object[])new Object[0]));
            map.put("jtynfe", ResManager.loadKDString((String)"\u8ba1\u63d0\u5e94\u7eb3\u8d39\u989d=\u5e94\u7eb3\u8d39\u989d-\u51cf\u514d\u8d39\u989d-\u5df2\u7f34\u8d39\u989d", (String)"DraftService_11", (String)"taxc-totf", (Object[])new Object[0]));
        }
        return map;
    }

    public static List<String> getAllColumns() {
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"totf_sjjt_bill").getDynamicObjectCollection("entryentity").getDynamicObjectType();
        List<String> collect = dynamicObjectType.getProperties().stream().map(s -> s.getName()).collect(Collectors.toList());
        return collect;
    }

    public static DynamicObjectCollection queryByAccount(TaxTypeEnum taxTypeEnum, Long orgId, Long taxtypeId, Date start, Date end) {
        String selectFields = "id,taxableitem,deductitem,taxrate,quickdeduction,deductionamount,bqyjse";
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("zspm.name", "=", (Object)taxTypeEnum.getName());
        QFilter q3 = new QFilter("startdate", ">=", (Object)start);
        QFilter q4 = new QFilter("enddate", "<=", (Object)end);
        if (TaxTypeEnum.TAXTYPE_036 == taxTypeEnum) {
            return QueryServiceHelper.query((String)"totf_embankment_account", (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)"startdate desc");
        }
        if (TaxTypeEnum.TAXTYPE_023 == taxTypeEnum || TaxTypeEnum.TAXTYPE_034 == taxTypeEnum) {
            return QueryServiceHelper.query((String)"totf_otherincome_account", (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)"startdate desc");
        }
        if (TaxTypeEnum.TAXTYPE_025 == taxTypeEnum) {
            return QueryServiceHelper.query((String)"totf_jsxzsyxsf_account", (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)"startdate desc");
        }
        return new DynamicObjectCollection();
    }

    public static BigDecimal getFeeRate(Long orgId, TaxTypeEnum taxTypeEnum, Date startdate, Date enddate) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgId));
        if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return BigDecimal.ZERO;
        }
        if (startdate == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject orgObject = (DynamicObject)((List)result.getData()).get(0);
        DynamicObjectCollection qtsfentity = orgObject.getDynamicObjectCollection("qtsfentity");
        List collect = qtsfentity.stream().filter(s -> taxTypeEnum.getName().equals(s.getDynamicObject("collectrate").getString("name"))).filter(s -> startdate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddate != null && enddate.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return BigDecimal.ZERO;
        }
        BigDecimal amountrate = ((DynamicObject)collect.get(0)).getBigDecimal("amountrate");
        return amountrate;
    }

    public static DynamicObjectCollection hasIntersection(String entityName, String orgNumber, Date startdate, Date enddate, String taxofficeNumber, String zspmNumber, List<Long> zszmIds) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org.number", "=", (Object)orgNumber));
        list.add(new QFilter("taxoffice.number", "=", (Object)taxofficeNumber));
        list.add(new QFilter("zspm.number", "=", (Object)zspmNumber));
        list.add(new QFilter("startdate", "<=", (Object)enddate));
        list.add(new QFilter("enddate", ">=", (Object)startdate));
        if ("totf_jsxzsyxsf_account".equals(entityName) && zszmIds.size() > 0) {
            list.add(new QFilter("zszm", "in", zszmIds));
        }
        return QueryServiceHelper.query((String)entityName, (String)"id,billno,billstatus,startdate,enddate", (QFilter[])list.toArray(new QFilter[0]));
    }

    public static DynamicObject getOne(Long orgId, Long taxtypeId, Date start, Date end) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("taxtype.id", "=", (Object)taxtypeId);
        QFilter q3 = new QFilter("skssqq", "=", (Object)start);
        QFilter q4 = new QFilter("skssqz", "=", (Object)end);
        return QueryServiceHelper.queryOne((String)"totf_sjjt_bill", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public static DynamicObjectCollection queryTaxableDeductItemAccount(Long orgId, Date start, Date end) {
        String selectFields = "id,amount";
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("startdate", ">=", (Object)start);
        QFilter q3 = new QFilter("enddate", "<=", (Object)end);
        return QueryServiceHelper.query((String)"totf_taxable_deduct_item", (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3}, (String)"enddate desc");
    }

    public static DynamicObjectCollection queryEmploymentFund(Long orgId, Date start, Date end) {
        String selectFields = "salary,staffnumbernew,ratio,disablednumbernew,deductionamount,bqyjse";
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("startdate", ">=", (Object)start);
        QFilter q3 = new QFilter("enddate", "<=", (Object)end);
        return QueryServiceHelper.query((String)"totf_employment_fund", (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3}, (String)"enddate desc");
    }

    public static Long getPlanId(Long orgId, Long taxTypeId, Long taxationsysId, Date startDate, Date endDate) {
        TaxResult result = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)taxTypeId, (Long)taxationsysId, (Date)startDate, (Date)endDate);
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            DynamicObject object = (DynamicObject)((DynamicObjectCollection)result.getData()).get(0);
            Long id = object.getLong("ruleentity.rule");
            return id;
        }
        return null;
    }

    public static Long setDefaultAccountOrg(Long taxOrg) {
        Map orgRelationAccountToTax = OrgRelationDataServiceHelper.getOrgRelationAccountToTax((Long)taxOrg, (boolean)false);
        List orglist = (List)orgRelationAccountToTax.get("data");
        if (!CollectionUtils.isEmpty((Collection)orglist)) {
            return orglist.stream().filter(o -> (Boolean)o.get("isDefault")).map(s -> (Long)s.get("orgId")).findFirst().orElseGet(() -> (Long)((HashMap)orglist.get(0)).get("orgId"));
        }
        return null;
    }
}

