/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.taxablelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class TaxableListQueryServiceHelper {
    public static final String KEY_FORMAT = "%d_%d_%d_%s_%s";
    private static Map<MultiLangEnumBridge, Long> taxcatetoryMap = new HashMap<MultiLangEnumBridge, Long>();
    private static Map<Long, String> accountMap = new HashMap<Long, String>();

    public static List<Map<String, Object>> queryDeclareTaxableList(List<Long> orgList, List<String> declareCategories, Date declareDate) {
        if (declareDate == null) {
            return new ArrayList<Map<String, Object>>();
        }
        Date date = DateUtils.addMonth((Date)declareDate, (int)-1);
        Set<Long> zspmIds = TaxableListQueryServiceHelper.getZspmIds(declareCategories);
        Map<String, Map<String, Date>> skssqzMap = TaxableListQueryServiceHelper.getSkssqzMap(declareDate);
        Map<String, Map<Long, String>> declarationMap = TaxableListQueryServiceHelper.getDeclarationMap(skssqzMap, orgList);
        Map<Long, Long> taxauthorityMap = TaxableListQueryServiceHelper.getTaxauthority(orgList);
        ArrayList<Map<String, Object>> taxableListDtos = new ArrayList<Map<String, Object>>();
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(orgList);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            ArrayList qtsfentity = new ArrayList();
            ((List)result.getData()).forEach(d -> qtsfentity.addAll(d.getDynamicObjectCollection("qtsfentity")));
            List collect = qtsfentity.stream().filter(s -> date.compareTo(s.getDate("effectivestart")) >= 0 && (s.getDate("effectiveend") == null || date.compareTo(s.getDate("effectiveend")) <= 0) && zspmIds.contains(s.getLong("collectrate.id")) && skssqzMap.get(s.getString("taxperiod")) != null).collect(Collectors.toList());
            Map licenseMap = (Map)TaxcLicenseCheckDataServiceHelper.checkBatch(orgList, (String)"totf").getData();
            for (DynamicObject entity : collect) {
                String taxlimit = entity.getString("taxperiod");
                Map<String, Date> dateMap = skssqzMap.get(taxlimit);
                DynamicObject taxmain = (DynamicObject)entity.getParent();
                Long orgid = taxmain.getLong("taxorg.id");
                Long zspmId = entity.getLong("collectrate.id");
                Long taxauthorityid = taxauthorityMap.get(orgid);
                Map<Long, String> orgDeclarationMap = declarationMap.get(taxlimit);
                if (!TaxableListQueryServiceHelper.orgNeedDeclare(orgid, zspmId, orgDeclarationMap, licenseMap)) continue;
                if (accountMap.containsKey(zspmId)) {
                    Set<Object> taxOffice = TaxableListQueryServiceHelper.queryAccountTaxoffice(orgid, dateMap, taxauthorityid, declareDate, zspmId, taxlimit);
                    for (Object taxoffice : taxOffice) {
                        TaxableListDto taxableListDto = TaxableListQueryServiceHelper.generateDto(orgid, dateMap, declareDate, zspmId);
                        taxableListDto.setTaxauthority((Long)taxoffice);
                        taxableListDtos.add(taxableListDto.transformToMap());
                    }
                    continue;
                }
                if ("count".equals(taxlimit)) continue;
                TaxableListDto taxableListDto = TaxableListQueryServiceHelper.generateDto(orgid, dateMap, declareDate, zspmId);
                taxableListDto.setTaxauthority(taxauthorityid);
                taxableListDtos.add(taxableListDto.transformToMap());
            }
        }
        Map<String, List<DynamicObject>> declareEntryMap = TaxableListQueryServiceHelper.queryDeclareEntry(orgList, declareCategories, skssqzMap);
        return TaxableListQueryServiceHelper.combineCollection(taxableListDtos, declareEntryMap);
    }

    private static Map<String, List<DynamicObject>> queryDeclareEntry(List<Long> orgList, List<String> declareCategories, Map<String, Map<String, Date>> skssqzMap) {
        QFilter q1 = new QFilter("org", "in", orgList);
        Map<String, List<String>> declareCategoryMap = declareCategories.stream().collect(Collectors.groupingBy(TaxableListQueryServiceHelper.declareCategoryGroupFunction()));
        HashMap<String, List<DynamicObject>> declareEntryMap = new HashMap<String, List<DynamicObject>>();
        for (Map.Entry<String, List<String>> entry : declareCategoryMap.entrySet()) {
            DynamicObjectCollection tcvat_nsrxx;
            QFilter q3;
            QFilter qFilter;
            if (TaxableListEnum.WHSYJSF.getSbbCategory().equals(entry.getKey())) {
                qFilter = null;
                for (Map<String, Date> skssqqz : skssqzMap.values()) {
                    if (qFilter == null) {
                        qFilter = new QFilter("skssqq", "=", (Object)skssqqz.get("skssqq")).and("skssqz", "=", (Object)skssqqz.get("skssqz"));
                        continue;
                    }
                    qFilter = qFilter.or(new QFilter("skssqq", "=", (Object)skssqqz.get("skssqq")).and("skssqz", "=", (Object)skssqqz.get("skssqz")));
                }
                q3 = new QFilter("type", "=", (Object)"whsyjsf");
                tcvat_nsrxx = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,org,billno,type,declaredate,taxauthority,skssqq,skssqz,declarestatus,paystatus", (QFilter[])new QFilter[]{q1, qFilter, q3});
                declareEntryMap.put(entry.getKey(), (List<DynamicObject>)tcvat_nsrxx);
                continue;
            }
            qFilter = null;
            for (Map<String, Date> skssqqz : skssqzMap.values()) {
                if (qFilter == null) {
                    qFilter = new QFilter("entryentity.startdate", "=", (Object)skssqqz.get("skssqq")).and("entryentity.enddate", "=", (Object)skssqqz.get("skssqz"));
                    continue;
                }
                qFilter = qFilter.or(new QFilter("entryentity.startdate", "=", (Object)skssqqz.get("skssqq")).and("entryentity.enddate", "=", (Object)skssqqz.get("skssqz")));
            }
            q3 = new QFilter("type", "in", Arrays.asList("qtsf_tysbb", "qtsf_fsstysbb"));
            tcvat_nsrxx = QueryServiceHelper.query((String)"totf_tysb_declare_main", (String)"id,org,billno,type,declaredate,taxauthority,declarestatus,paystatus,entryentity.startdate as skssqq,entryentity.enddate as skssqz,entryentity.zspm as taxtype", (QFilter[])new QFilter[]{q1, qFilter, q3});
            declareEntryMap.put(entry.getKey(), (List<DynamicObject>)tcvat_nsrxx);
        }
        return declareEntryMap;
    }

    private static List<Map<String, Object>> combineCollection(List<Map<String, Object>> taxableListDtos, Map<String, List<DynamicObject>> declareEntryMap) {
        Map<String, Map<String, Object>> map = taxableListDtos.stream().collect(Collectors.toMap(dto -> String.format(KEY_FORMAT, dto.get("org"), dto.get("taxcatetory"), dto.get("taxauthority"), DateUtils.format((Date)((Date)dto.get("skssqq"))), DateUtils.format((Date)((Date)dto.get("skssqz")))), Function.identity(), (oldvaule, newvalue) -> newvalue));
        for (Map.Entry<String, List<DynamicObject>> entry : declareEntryMap.entrySet()) {
            String type = entry.getKey();
            List<DynamicObject> dynamicObjects = entry.getValue();
            if (TaxableListEnum.WHSYJSF.getSbbCategory().equals(type)) {
                TaxableListQueryServiceHelper.populateWhsyjsfDto(map, dynamicObjects);
                continue;
            }
            TaxableListQueryServiceHelper.populateTyDto(map, dynamicObjects);
        }
        return new ArrayList<Map<String, Object>>(map.values());
    }

    private static void populateTyDto(Map<String, Map<String, Object>> map, List<DynamicObject> dynamicObjects) {
        Map dynamicObjectMap = dynamicObjects.stream().collect(Collectors.toMap(object -> String.format(KEY_FORMAT, object.getLong("org"), TaxableListQueryServiceHelper.getTaxcatetory(object.getString("taxtype")), object.getLong("taxauthority"), DateUtils.format((Date)object.getDate("skssqq")), DateUtils.format((Date)object.getDate("skssqz"))), Function.identity(), (oldvaule, newvalue) -> newvalue));
        for (Map.Entry objectEntry : dynamicObjectMap.entrySet()) {
            String key = objectEntry.getKey();
            DynamicObject nsrxx = (DynamicObject)objectEntry.getValue();
            Map<String, Object> taxableListDto = map.get(key);
            if (taxableListDto == null) {
                taxableListDto = new HashMap<String, Object>();
            }
            taxableListDto.put("org", nsrxx.getLong("org"));
            taxableListDto.put("sbbno", nsrxx.getString("billno"));
            Long taxcatetory = TaxableListQueryServiceHelper.getTaxcatetory(nsrxx.getString("taxtype"));
            taxableListDto.put("taxcatetory", taxcatetory);
            taxableListDto.put("skssqq", nsrxx.getDate("skssqq"));
            taxableListDto.put("skssqz", nsrxx.getDate("skssqz"));
            taxableListDto.put("month", nsrxx.getDate("declaredate"));
            taxableListDto.put("declarestatus", nsrxx.getString("declarestatus"));
            taxableListDto.put("paystatus", nsrxx.getString("paystatus"));
            taxableListDto.put("taxauthority", nsrxx.getLong("taxauthority"));
            TaxableListEnum taxableListEnum = TaxableListEnum.valueOfTaxid((Long)taxcatetory);
            if (taxableListEnum != null) {
                taxableListDto.put("sbbcategory", taxableListEnum.getSbbCategory());
            }
            taxableListDto.put("templatetype", nsrxx.getString("type"));
            map.put(key, taxableListDto);
        }
    }

    private static void populateWhsyjsfDto(Map<String, Map<String, Object>> map, List<DynamicObject> dynamicObjects) {
        Map dynamicObjectMap = dynamicObjects.stream().collect(Collectors.toMap(object -> String.format(KEY_FORMAT, object.getLong("org"), BaseTaxCategory.WHSYJSF, object.getLong("taxauthority"), DateUtils.format((Date)object.getDate("skssqq")), DateUtils.format((Date)object.getDate("skssqz"))), Function.identity(), (oldvaule, newvalue) -> newvalue));
        for (Map.Entry objectEntry : dynamicObjectMap.entrySet()) {
            String key = objectEntry.getKey();
            DynamicObject nsrxx = (DynamicObject)objectEntry.getValue();
            Map<String, Object> taxableListDto = map.get(key);
            if (taxableListDto == null) {
                taxableListDto = new HashMap<String, Object>();
            }
            taxableListDto.put("org", nsrxx.getLong("org"));
            taxableListDto.put("sbbno", nsrxx.getString("billno"));
            taxableListDto.put("taxcatetory", BaseTaxCategory.WHSYJSF);
            taxableListDto.put("skssqq", nsrxx.getDate("skssqq"));
            taxableListDto.put("skssqz", nsrxx.getDate("skssqz"));
            taxableListDto.put("month", nsrxx.getDate("declaredate"));
            taxableListDto.put("declarestatus", nsrxx.getString("declarestatus"));
            taxableListDto.put("paystatus", nsrxx.getString("paystatus"));
            taxableListDto.put("sbbcategory", TaxableListEnum.WHSYJSF.getSbbCategory());
            taxableListDto.put("templatetype", nsrxx.getString("type"));
            taxableListDto.put("taxauthority", nsrxx.getLong("taxauthority"));
            map.put(key, taxableListDto);
        }
    }

    private static Long getTaxcatetory(String taxtype) {
        for (Map.Entry<MultiLangEnumBridge, Long> entry : taxcatetoryMap.entrySet()) {
            if (!entry.getKey().loadKDString().equals(taxtype)) continue;
            return entry.getValue();
        }
        return 0L;
    }

    private static Function<String, String> declareCategoryGroupFunction() {
        return declareCategory -> {
            if (TaxableListEnum.WHSYJSF.getSbbCategory().equals(declareCategory)) {
                return TaxableListEnum.WHSYJSF.getSbbCategory();
            }
            return "qtsf_tysbb";
        };
    }

    private static Map<String, Map<Long, String>> getDeclarationMap(Map<String, Map<String, Date>> skssqzMap, List<Long> orgList) {
        HashMap<String, Map<Long, String>> declarationMap = new HashMap<String, Map<Long, String>>(skssqzMap.size());
        for (Map.Entry<String, Map<String, Date>> entry : skssqzMap.entrySet()) {
            Map<String, Date> dateMap = entry.getValue();
            Map map = OrgUtils.getOrgGroupDeclaration(orgList, (String)"sljsjj", (Date)dateMap.get("skssqq"), (Date)dateMap.get("skssqz"));
            declarationMap.put(entry.getKey(), map);
        }
        return declarationMap;
    }

    private static boolean orgNeedDeclare(Long orgid, Long zspmId, Map<Long, String> orgDeclarationMap, Map<Long, Boolean> licenseMap) {
        ZspmEnum zspmEnum = ZspmEnum.valueOfZspmId((Long)zspmId);
        if (zspmEnum != null && EmptyCheckUtils.isNotEmpty((Object)zspmEnum.getParamKey())) {
            Object zerodecalre = SystemParamUtil.getAppParameter((String)"totf", (String)zspmEnum.getParamKey(), (long)orgid);
            if (Boolean.FALSE.equals(zerodecalre) && Boolean.TRUE.equals(licenseMap.get(orgid))) {
                return false;
            }
            return !ZspmConstant.ID_DFSLJSJJ_ZPSM.equals(zspmId) || !"3".equals(orgDeclarationMap.get(orgid)) || !Boolean.FALSE.equals(zerodecalre);
        }
        return Boolean.FALSE.equals(licenseMap.get(orgid));
    }

    private static Map<String, Map<String, Date>> getSkssqzMap(Date declareDate) {
        Map map = DateUtils.getTaxLimitSkssqzMap((Date)declareDate);
        HashMap<String, Date> countMap = new HashMap<String, Date>();
        countMap.put("skssqq", declareDate);
        countMap.put("skssqz", declareDate);
        map.put("count", countMap);
        return map;
    }

    private static Set<Long> getZspmIds(List<String> templateTypes) {
        HashSet<Long> zspmIdList = new HashSet<Long>();
        for (String declareCategory : templateTypes) {
            List zspmIds = ZspmEnum.getZspmIdsByTemplateType((String)declareCategory);
            zspmIdList.addAll(zspmIds);
        }
        return zspmIdList;
    }

    private static TaxableListDto generateDto(Long orgid, Map<String, Date> dateMap, Date declareDate, Long zspmId) {
        TaxableListDto taxableListDto = new TaxableListDto();
        taxableListDto.setOrg(orgid);
        taxableListDto.setSkssqq(dateMap.get("skssqq"));
        taxableListDto.setSkssqz(dateMap.get("skssqz"));
        taxableListDto.setMonth(declareDate);
        taxableListDto.setDeclarestatus(TaxableListDto.DECLARESTATUS_WBZ);
        taxableListDto.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
        taxableListDto.setDraftstatus(TaxableListDto.DRAFTSTATUS_WXBZ);
        taxableListDto.setTaxationsys(RuleFetchConstant.DEFALUT_TAXSYSTEM);
        taxableListDto.setTaxareagroup(RuleFetchConstant.DEFALUT_TAXAREAGROUP);
        ZspmEnum zspmEnum = ZspmEnum.valueOfZspmId((Long)zspmId);
        if (zspmEnum != null) {
            taxableListDto.setTaxcatetory(zspmEnum.getTaxcatetory());
            taxableListDto.setTemplatetype(zspmEnum.getTemplateType());
            taxableListDto.setSbbcategory(zspmEnum.getTemplateType());
        }
        return taxableListDto;
    }

    private static Map<Long, Long> getTaxauthority(List<Long> orgList) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgList);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            return ((List)result.getData()).stream().collect(Collectors.toMap(d -> d.getLong("taxorg.id"), d -> d.getLong("taxoffice.id"), (k, v) -> k));
        }
        return new HashMap<Long, Long>();
    }

    private static Set<Object> queryAccountTaxoffice(Long orgId, Map<String, Date> dateMap, Long taxauthorityid, Date declareDate, Long basetaxid, String taxlimit) {
        DynamicObjectCollection dynamicObjectCollection = TaxableListQueryServiceHelper.queryAccount(basetaxid, orgId, dateMap.get("skssqq"), dateMap.get("skssqz"), taxlimit);
        Set<Object> taxoffice = dynamicObjectCollection.stream().map(s -> s.get("taxoffice")).collect(Collectors.toSet());
        if (basetaxid.equals(ZspmConstant.ID_DFSLJSJJ_ZPSM)) {
            List declareserialnoList;
            QFilter accountFilter;
            DynamicObjectCollection prepayAccount;
            List monthBetween = DateUtils.getMonthBetween((Date)dateMap.get("skssqq"), (Date)dateMap.get("skssqz"), (String)"yyyy-MM-dd");
            List<Date> monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
            QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("billstatus", "=", (Object)"C"));
            QFilter timefilter = new QFilter("skssqq", "=", (Object)dateMap.get("skssqq")).and(new QFilter("skssqz", "=", (Object)dateMap.get("skssqz")));
            monthList.forEach(s -> timefilter.or(new QFilter("skssqq", "=", s).and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)s)))));
            DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,declareserialno", (QFilter[])new QFilter[]{filter, timefilter});
            if (prepayDeclareQuery != null && prepayDeclareQuery.size() > 0 && (prepayAccount = QueryServiceHelper.query((String)"tcvat_project_account", (String)"orgid,taxoffice,prepaytype,declareserialno", (QFilter[])new QFilter[]{accountFilter = new QFilter("orgid", "=", (Object)orgId).and(new QFilter("declareserialno", "in", declareserialnoList = prepayDeclareQuery.stream().map(p -> p.getString("declareserialno")).collect(Collectors.toList()))).and(new QFilter("entryentity.taxtype", "=", (Object)ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"TaxableListQueryServiceHelper_5", (String)"taxc-totf", (Object[])new Object[0])))})) != null && prepayAccount.size() > 0) {
                Set waterfundtaxoffice = prepayAccount.stream().map(s -> s.get("taxoffice")).collect(Collectors.toSet());
                taxoffice.addAll(waterfundtaxoffice);
            }
        }
        if (!"count".equals(taxlimit)) {
            taxoffice.add(taxauthorityid);
        }
        return taxoffice;
    }

    private static DynamicObjectCollection queryAccount(Long basetaxid, Long orgId, Date skssqq, Date skssqz, String taxlimit) {
        QFilter q3;
        QFilter q2;
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        if (skssqq.compareTo(skssqz) == 0) {
            q2 = new QFilter("startdate", "<=", (Object)skssqq);
            q3 = new QFilter("payperiod", "=", (Object)"count");
        } else {
            q2 = new QFilter("startdate", "=", (Object)skssqq);
            q3 = new QFilter("enddate", "=", (Object)skssqz);
            if (ZspmConstant.ID_GHJH_ZPSM.equals(basetaxid) || ZspmConstant.ID_GHCBJ_ZPSM.equals(basetaxid) || ZspmConstant.ID_DWFHF_ZPSM.equals(basetaxid) || ZspmConstant.ID_CZLJCLF_ZPSM.equals(basetaxid)) {
                q2 = new QFilter("startdate", ">=", (Object)skssqq);
                q3 = new QFilter("enddate", "<=", (Object)skssqz);
                q3.and(new QFilter("payperiod", "=", (Object)taxlimit));
            }
        }
        return QueryServiceHelper.query((String)accountMap.get(basetaxid), (String)"taxoffice", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    static {
        taxcatetoryMap.put(new MultiLangEnumBridge("\u5de5\u4f1a\u7ecf\u8d39", "TaxableListQueryServiceHelper_0", "taxc-totf"), BaseTaxCategory.QTSR);
        taxcatetoryMap.put(new MultiLangEnumBridge("\u5de5\u4f1a\u7b79\u5907\u91d1", "TaxableListQueryServiceHelper_3", "taxc-totf"), BaseTaxCategory.QTSR);
        taxcatetoryMap.put(new MultiLangEnumBridge("\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", "TaxableListQueryServiceHelper_1", "taxc-totf"), BaseTaxCategory.SLHSZXSR);
        taxcatetoryMap.put(new MultiLangEnumBridge("\u5824\u56f4\u9632\u62a4\u8d39", "TaxableListQueryServiceHelper_4", "taxc-totf"), BaseTaxCategory.SLHSZXSR);
        taxcatetoryMap.put(new MultiLangEnumBridge("\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39", "TaxableListQueryServiceHelper_2", "taxc-totf"), BaseTaxCategory.JSXZSYXSFSR);
        accountMap.put(ZspmConstant.ID_DFSLJSJJ_ZPSM, "totf_water_fund");
        accountMap.put(ZspmConstant.ID_WHSYJSF_ZPSM, "totf_whsyjsf_account");
        accountMap.put(ZspmConstant.ID_GHJH_ZPSM, "totf_otherincome_account");
        accountMap.put(ZspmConstant.ID_GHCBJ_ZPSM, "totf_otherincome_account");
        accountMap.put(ZspmConstant.ID_DWFHF_ZPSM, "totf_embankment_account");
        accountMap.put(ZspmConstant.ID_CZLJCLF_ZPSM, "totf_jsxzsyxsf_account");
    }
}

