/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.business.zerodeclare;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class ZeroDeclareHelper {
    public static boolean checkOrg(IFormView view, DynamicObject org, Date collectDate) {
        long orgId = org.getLong("id");
        String orgName = org.getString("name");
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare", (long)orgId);
        if (zerodeclare) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u7ec4\u7ec7\u7684\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u751f\u6210\u4e0b\u65b9\u6570\u636e\u884c", (String)"ZeroDeclareHelper_0", (String)"taxc-totf", (Object[])new Object[0]), orgName));
            return false;
        }
        String declaration = OrgUtils.getOrgGroupDeclaration((Long)orgId, (String)"sljsjj", (Date)collectDate, (Date)collectDate);
        if ("3".equals(declaration)) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u7ec4\u7ec7\u4e3a\u88ab\u6c47\u603b\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26", (String)"ZeroDeclareHelper_1", (String)"taxc-totf", (Object[])new Object[0]), orgName));
            return false;
        }
        return true;
    }

    public static boolean checkOrgLicenseAndZeroDeclare(IFormView view, String templateType, Long orgId, Date declareDate) {
        Map skssqzMap = DateUtils.getTaxLimitSkssqzMap((Date)declareDate);
        List tempZspmIds = ZspmEnum.getZspmIdsByTemplateType((String)templateType);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            Date date = DateUtils.addMonth((Date)declareDate, (int)-1);
            List zspmIds = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("qtsfentity").stream().filter(s -> s.getDate("effectivestart").before(date) && (s.getDate("effectiveend") == null || s.getDate("effectiveend").after(date)) && skssqzMap.get(s.getString("taxperiod")) != null && tempZspmIds.contains(s.getLong("collectrate.id"))).map(d -> d.getLong("collectrate.id")).collect(Collectors.toList());
            TaxResult licenseResult = TaxcLicenseCheckDataServiceHelper.check((Long)orgId, (String)"totf");
            boolean hasLicense = Boolean.FALSE.equals(licenseResult.getData());
            if (!hasLicense) {
                boolean hasZeroDeclareZspm = false;
                for (Long zspmId : zspmIds) {
                    boolean zerodeclare;
                    ZspmEnum zspmEnum = ZspmEnum.valueOfZspmId((Long)zspmId);
                    if (zspmEnum == null || !(zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)zspmEnum.getParamKey(), (long)orgId))) continue;
                    hasZeroDeclareZspm = true;
                }
                if (!hasZeroDeclareZspm) {
                    view.showConfirm(licenseResult.getMessage(), null);
                    return false;
                }
            }
        }
        return true;
    }
}

