/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.common.enums;

import java.util.Arrays;

public enum RuleTypeEnum {
    SLJSJJ("sljsjj", "totf_rule_waterfund", null, 2015938710276921344L),
    STBCBCF("stbcbcf", "totf_rule_stbcbcf", null, 2015939841581248512L),
    WHSYJSF("whsyjsf", "totf_rule_whsyjsf", null, 0L),
    DEFAULT("default", "", null, 0L);

    private String name;
    private String entry;
    private String val;
    private Long groupId;

    private RuleTypeEnum(String name, String entry, String val, Long groupId) {
        this.name = name;
        this.entry = entry;
        this.val = val;
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getVal() {
        return this.val;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public static RuleTypeEnum getStrategyByGroupId(Long groupId) {
        for (RuleTypeEnum value : RuleTypeEnum.values()) {
            if (!value.getGroupId().equals(groupId)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static Long getGroupId(String formId) {
        return Arrays.stream(RuleTypeEnum.values()).filter(s -> s.getEntry().equals(formId)).map(s -> s.getGroupId()).findFirst().orElseGet(() -> 0L);
    }
}

