/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum TaxTypeEnum {
    TAXTYPE_023("023", "028", "ghjf", new MultiLangEnumBridge("\u5176\u4ed6\u6536\u5165", "TaxTypeEnum_7", "taxc-totf"), new MultiLangEnumBridge("\u5de5\u4f1a\u7ecf\u8d39", "TaxTypeEnum_0", "taxc-totf")),
    TAXTYPE_024("024", "030", "sljsjj", new MultiLangEnumBridge("\u6c34\u5229\u5efa\u8bbe\u4e13\u9879\u6536\u5165", "TaxTypeEnum_8", "taxc-totf"), new MultiLangEnumBridge("\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", "TaxTypeEnum_1", "taxc-totf")),
    TAXTYPE_025("025", "031", "czljclf", new MultiLangEnumBridge("\u5efa\u8bbe\u884c\u653f\u4e8b\u4e1a\u6027\u6536\u8d39\u6536\u5165", "TaxTypeEnum_9", "taxc-totf"), new MultiLangEnumBridge("\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39", "TaxTypeEnum_2", "taxc-totf")),
    TAXTYPE_026("026", "026", "whsyjsf", new MultiLangEnumBridge("\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39", "TaxTypeEnum_10", "taxc-totf"), new MultiLangEnumBridge("\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39", "TaxTypeEnum_3", "taxc-totf")),
    TAXTYPE_027("027", "027", "cjrjybzj", new MultiLangEnumBridge("\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1", "TaxTypeEnum_11", "taxc-totf"), new MultiLangEnumBridge("\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1", "TaxTypeEnum_4", "taxc-totf")),
    TAXTYPE_034("034", "028", "ghcbj", new MultiLangEnumBridge("\u5176\u4ed6\u6536\u5165", "TaxTypeEnum_12", "taxc-totf"), new MultiLangEnumBridge("\u5de5\u4f1a\u7b79\u5907\u91d1", "TaxTypeEnum_5", "taxc-totf")),
    TAXTYPE_036("036", "030", "dwfhf", new MultiLangEnumBridge("\u6c34\u5229\u5efa\u8bbe\u4e13\u9879\u6536\u5165", "TaxTypeEnum_13", "taxc-totf"), new MultiLangEnumBridge("\u5824\u56f4\u9632\u62a4\u8d39", "TaxTypeEnum_6", "taxc-totf"));

    private String number;
    private String targetNumber;
    private String draftType;
    private MultiLangEnumBridge zsxm;
    private MultiLangEnumBridge name;

    private TaxTypeEnum(String number, String targetNumber, String draftType, MultiLangEnumBridge zsxm, MultiLangEnumBridge name) {
        this.number = number;
        this.targetNumber = targetNumber;
        this.draftType = draftType;
        this.zsxm = zsxm;
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name.getDescription();
    }

    public String getDraftType() {
        return this.draftType;
    }

    public String getZsxm() {
        return this.zsxm.getDescription();
    }

    public String getTargetNumber() {
        return this.targetNumber;
    }

    public static TaxTypeEnum get(String number) {
        return Arrays.stream(TaxTypeEnum.values()).filter(s -> number.equals(s.getNumber())).findFirst().orElseGet(() -> TAXTYPE_023);
    }

    public static List<String> getDraftTypes() {
        return Arrays.stream(TaxTypeEnum.values()).map(s -> s.getDraftType()).collect(Collectors.toList());
    }
}

