/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class WhsyjsfUtils {
    private static List<DynamicObject> getTaxCard(Long orgid) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgid));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            return taxMain.getDynamicObjectCollection("qtsfentity").stream().filter(d -> "0096".equals(d.getString("collectrate.number"))).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    public static String getTaxlimit(Long orgid, Date date) {
        Date preMonth = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)date), (int)-1);
        List<DynamicObject> cards = WhsyjsfUtils.getTaxCard(orgid);
        Optional<DynamicObject> card = cards.stream().filter(e -> WhsyjsfUtils.isEffectiveDate(preMonth, null, e.getDate("effectivestart"), e.getDate("effectiveend"))).findFirst();
        return card.map(dynamicObject -> dynamicObject.getString("taxperiod")).orElse(null);
    }

    public static String getRangeTaxlimit(Long orgid, Date startdate, Date enddate) {
        List<DynamicObject> cards = WhsyjsfUtils.getTaxCard(orgid);
        Optional<DynamicObject> card = cards.stream().filter(e -> DateUtils.isEffectiveDate((Date)startdate, (Date)e.getDate("effectivestart"), (Date)e.getDate("effectiveend")) && DateUtils.isEffectiveDate((Date)enddate, (Date)e.getDate("effectivestart"), (Date)e.getDate("effectiveend"))).findFirst();
        return card.map(dynamicObject -> dynamicObject.getString("taxperiod")).orElse(null);
    }

    public static Map<String, Date> getStartAndEndDate(Date date, String taxlimit) {
        Date startdate = null;
        Date enddate = null;
        Date preMonth = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)date), (int)-1);
        switch (taxlimit) {
            case "month": {
                startdate = DateUtils.getFirstDateOfMonth((Date)preMonth);
                enddate = DateUtils.getLastDateOfMonth((Date)preMonth);
                break;
            }
            case "season": {
                if (!Arrays.asList(1, 4, 7, 10).contains(DateUtils.getMonthOfDate((Date)date))) break;
                startdate = DateUtils.getFirstDateOfSeason((Date)preMonth);
                enddate = DateUtils.getLastDateOfSeason((Date)preMonth);
                break;
            }
            case "halfyear": {
                if (!Arrays.asList(1, 7).contains(DateUtils.getMonthOfDate((Date)date))) break;
                startdate = DateUtils.getFirstDateOfHalfYear((Date)preMonth);
                enddate = DateUtils.getLastDateOfHalfYear((Date)preMonth);
                break;
            }
            case "year": {
                if (1 != DateUtils.getMonthOfDate((Date)date)) break;
                startdate = DateUtils.getFirstDateOfYear((Date)preMonth);
                enddate = DateUtils.getLastDateOfYear((Date)preMonth);
                break;
            }
            case "count": {
                startdate = date;
                enddate = date;
            }
        }
        if (null == startdate || null == enddate) {
            return Collections.emptyMap();
        }
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("startdate", startdate);
        map.put("enddate", DateUtils.getDayFirst((Date)enddate));
        return map;
    }

    private static boolean isEffectiveDate(Date date1, Date date2, Date start, Date end) {
        Date enddate;
        Date startdate = new Date(start.getTime());
        Date date = enddate = end != null ? new Date(end.getTime()) : null;
        if (null == date2) {
            return startdate.equals(date1) ? true : DateUtils.isEffectiveDate((Date)date1, (Date)startdate, (Date)enddate);
        }
        return !(!startdate.equals(date1) && !DateUtils.isEffectiveDate((Date)date1, (Date)startdate, (Date)enddate) || !date2.equals(enddate) && !DateUtils.isEffectiveDate((Date)date2, (Date)startdate, (Date)enddate));
    }
}

