/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FieldTip;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.totf.business.account.AccountDetailAdjustServiceHelper;
import kd.taxc.totf.business.account.WaterFundServiceHelper;
import kd.taxc.totf.business.account.WaterSoilCompensationServiceHelper;
import kd.taxc.totf.business.account.WhsjjsfDetailAdjustServiceHelper;
import kd.taxc.totf.business.account.WhsyjsfAccountServiceHelper;
import kd.taxc.totf.business.engine.WaterFundHelper;
import kd.taxc.totf.business.engine.WhsyjsfAccountHelper;

public class AccountDetailFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String RULEID = "ruleid";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    private static final String TOTF_WATER_FUND = "totf_water_fund";
    private static final String TOTF_WATERFUND_DETAIL = "totf_waterfund_detail";
    private static String TABLE_ACCOUNT;
    private static String TABLE_DETAIL;
    private static String TABLIE_DETAIL_ADJUST;

    public void initialize() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        TABLE_ACCOUNT = customParams.getOrDefault("table_account", TOTF_WATER_FUND);
        TABLE_DETAIL = customParams.getOrDefault("table_detail", TOTF_WATERFUND_DETAIL);
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String ruleEntity;
        DynamicObjectCollection genericObjects;
        DynamicObjectCollection adjustDetails;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serialno = (String)customParams.get("serialno");
        String orgId = (String)customParams.get("orgId");
        String mappingid = (String)customParams.get("mappingid");
        String startdate = (String)customParams.get("startdate");
        String enddate = (String)customParams.get("enddate");
        String tableaccount = (String)customParams.get("table_account");
        Long zszm = (Long)customParams.get("zszm");
        Long zspm = (Long)customParams.get("zspm");
        if (TOTF_WATER_FUND.equals(tableaccount)) {
            adjustDetails = AccountDetailAdjustServiceHelper.queryAdjustCollection(serialno, orgId, mappingid, startdate, enddate);
            genericObjects = WaterFundServiceHelper.queryWaterFundDetails(serialno, orgId, mappingid, startdate, enddate);
            ruleEntity = "totf_rule_waterfund";
        } else if ("totf_stbcbcf_account".equals(tableaccount)) {
            adjustDetails = WaterSoilCompensationServiceHelper.queryAdjustCollection(orgId, startdate, enddate, zspm, zszm);
            genericObjects = WaterSoilCompensationServiceHelper.queryWaterSoilCompensationDetails(orgId, startdate, enddate, zspm, zszm);
            ruleEntity = "totf_rule_stbcbcf";
        } else {
            adjustDetails = WhsjjsfDetailAdjustServiceHelper.queryAdjustCollection(serialno, orgId, mappingid, startdate, enddate);
            genericObjects = WhsyjsfAccountServiceHelper.queryAccountDetails(serialno, orgId, mappingid, startdate, enddate);
            ruleEntity = "totf_rule_whsyjsf";
        }
        if (EmptyCheckUtils.isEmpty((Object)genericObjects)) {
            this.appendCard(serialno, adjustDetails, null);
            return;
        }
        Map<Long, List<DynamicObject>> map = genericObjects.stream().sorted(Comparator.comparing(d -> d.getLong("id"))).collect(Collectors.groupingBy(s -> s.getLong(RULEID)));
        this.getModel().beginInit();
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
            DynamicObject detail = entry.getValue().get(0);
            Long ruleid = detail.getLong(RULEID);
            DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleid, (String)ruleEntity);
            this.getModel().setValue(RULEID, (Object)ruleid, rowIndex);
            this.getModel().setValue("titlename", (Object)rule.getString("name"), rowIndex);
            this.getModel().setValue("taxitem", (Object)rule.getDynamicObject("collectionitem").getString("name"), rowIndex);
            this.getModel().setValue("serialno", (Object)serialno, rowIndex);
            this.getModel().setValue("amount", (Object)this.getAmount(ruleid, entry.getValue()), rowIndex);
            this.getModel().setValue("adjustamount", (Object)this.getAdjustamount(ruleid, serialno, adjustDetails), rowIndex);
            this.getModel().setValue("totalamount", (Object)this.getTotalamount(detail, serialno, adjustDetails, entry.getValue()), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_CARD);
        this.appendCard(serialno, adjustDetails, genericObjects);
        Map.Entry first = (Map.Entry)map.entrySet().stream().findFirst().get();
        this.clearEntry(ENTRYENTITY_LIST);
        this.setEntryentitylist((Long)first.getKey(), serialno, TABLE_DETAIL);
    }

    private Object calcAdjustsumamount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal totalamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalamount;
    }

    private void appendCard(String serialno, DynamicObjectCollection adjustDetails, DynamicObjectCollection genericObjects) {
        Optional<DynamicObject> optional = adjustDetails.stream().filter(s -> Objects.equals(s.getLong(RULEID), 0L) && s.getString("serialno").equals(serialno)).findFirst();
        DynamicObject dynamicObject = optional.isPresent() ? optional.get() : null;
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"AccountDetailFormPlugin_0", (String)"taxc-totf", (Object[])new Object[0]), rowIndex);
        this.getModel().setValue("serialno", (Object)serialno, rowIndex);
        this.getModel().setValue("amount", (Object)BigDecimal.ZERO, rowIndex);
        this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("totalamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("adjustamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("adjustamount") : BigDecimal.ZERO), rowIndex);
        BigDecimal sumamount = WaterFundHelper.calcSumAmountByGroup((List<DynamicObject>)genericObjects);
        this.getModel().setValue("sumamount", (Object)sumamount);
        this.getModel().setValue("adjustsumamount", this.calcAdjustsumamount());
    }

    private BigDecimal getTotalamount(DynamicObject detail, String serialno, DynamicObjectCollection adjustDetails, List<DynamicObject> genericObjects) {
        Long ruleid = detail.getLong(RULEID);
        Optional<DynamicObject> optional = adjustDetails.stream().filter(s -> Objects.equals(s.getLong(RULEID), ruleid) && s.getString("serialno").equals(serialno)).findFirst();
        BigDecimal result = optional.isPresent() ? optional.get().getBigDecimal("totalamount") : this.getAmount(ruleid, genericObjects);
        return result;
    }

    private BigDecimal getAdjustamount(Long ruleid, String serialno, DynamicObjectCollection adjustDetails) {
        Optional<DynamicObject> optional = adjustDetails.stream().filter(s -> Objects.equals(s.getLong(RULEID), ruleid) && s.getString("serialno").equals(serialno)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Long ruleid, List<DynamicObject> genericObjects) {
        BigDecimal sum = genericObjects.stream().filter(s -> Objects.equals(s.getLong(RULEID), ruleid)).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean mustPositiveInteger;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            }
            if ("totalamount".equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("adjustamount", (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        } else if ("adjustsumamount".equals(name) && (mustPositiveInteger = (Boolean)this.getView().getFormShowParameter().getCustomParam("mustPositiveInt")) != null && mustPositiveInteger.booleanValue()) {
            String notPositiveIntMsg = (String)this.getView().getFormShowParameter().getCustomParam("notPositiveIntMsg");
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", "");
                tip.setSuccess(true);
                this.getView().showFieldTip(tip);
            }
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("adjustsumamount", (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgid = (String)customParams.get("orgId");
            String mappingid = (String)customParams.get("mappingid");
            String tableaccount = (String)customParams.get("table_account");
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("startdate")));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("enddate")));
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            String entityname = tableaccount.equals(TOTF_WATER_FUND) ? TABLIE_DETAIL_ADJUST : "totf_whsydetail_adjust";
            if (!CollectionUtils.isEmpty((Collection)entryentitycard)) {
                String serialno = ((DynamicObject)entryentitycard.get(0)).getString("serialno");
                BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue("adjustsumamount");
                if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u7a0e\u91d1\u989d\u6216\u4ef6\u6570\u4e0d\u53ef\u4e3a\u8d1f\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AccountDetailFormPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                    return;
                }
                this.deleteDetailAdjust(serialno, orgid, mappingid, skssqq, skssqz, entityname);
                for (DynamicObject dynamicObject : entryentitycard) {
                    DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityname));
                    object.set(RULEID, (Object)dynamicObject.getLong(RULEID));
                    object.set("serialno", (Object)dynamicObject.getString("serialno"));
                    object.set("titlename", (Object)dynamicObject.getString("titlename"));
                    object.set("taxitem", (Object)dynamicObject.getString("taxitem"));
                    object.set("amount", (Object)dynamicObject.getBigDecimal("amount"));
                    object.set("adjustamount", (Object)dynamicObject.getBigDecimal("adjustamount"));
                    object.set("totalamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                    object.set(ORG, (Object)orgid);
                    object.set("mappingid", (Object)mappingid);
                    object.set(SKSSQQ, (Object)skssqq);
                    object.set(SKSSQZ, (Object)skssqz);
                    datas.add(object);
                }
                this.updateSummary(serialno, orgid, mappingid, adjustsumamount, customParams.get("pkid"), tableaccount);
            }
            SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            this.getView().close();
        }
    }

    private void updateSummary(String serialno, String orgid, String mappingid, BigDecimal adjustsumamount, Object billid, String tableaccount) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)billid, (String)TABLE_ACCOUNT);
        if (object != null) {
            if (tableaccount.equals(TOTF_WATER_FUND)) {
                BigDecimal amountWithoutOrg = WaterFundServiceHelper.calcWaterFundDetailAmountsWithoutOrg(serialno, orgid, mappingid);
                BigDecimal adjustAmountWithoutOrg = AccountDetailAdjustServiceHelper.calcAdjustAmountWithoutOrg(serialno, orgid, mappingid);
                BigDecimal taxableitem = BigDecimalUtil.addObjects((Object[])new Object[]{adjustsumamount, amountWithoutOrg, adjustAmountWithoutOrg}).setScale(2, 4);
                WaterFundHelper.calculateAmounts(object, taxableitem);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            } else {
                BigDecimal amountWithoutOrg = WhsyjsfAccountServiceHelper.calcAccountDetailAmountsWithoutOrg(serialno, orgid, mappingid);
                BigDecimal adjustAmountWithoutOrg = WhsjjsfDetailAdjustServiceHelper.calcAdjustAmountWithoutOrg(serialno, orgid, mappingid);
                BigDecimal taxableitem = BigDecimalUtil.addObjects((Object[])new Object[]{adjustsumamount, amountWithoutOrg, adjustAmountWithoutOrg}).setScale(2, 4);
                WhsyjsfAccountHelper.calculateAmounts(object, taxableitem);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    private void deleteDetailAdjust(String serialno, String orgId, String mappingid, Object skssqq, Object skssqz, String entityname) {
        DeleteServiceHelper.delete((String)entityname, (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter(ORG, "=", (Object)Long.valueOf(orgId))).and(new QFilter("mappingid", "=", (Object)Long.valueOf(mappingid))).and(new QFilter("serialno", "=", (Object)serialno))});
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        List rows = evt.getNewRows();
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        if (rows.isEmpty()) {
            return;
        }
        if (entryentitycard.size() - 1 == (Integer)rows.get(0)) {
            return;
        }
        this.clearEntry(ENTRYENTITY_LIST);
        Long ruleid = (Long)cardEntry.getModel().getValue(RULEID);
        String serialno = (String)cardEntry.getModel().getValue("serialno");
        if (ruleid != 0L && StringUtil.isNotEmpty((CharSequence)serialno)) {
            this.setEntryentitylist(ruleid, serialno, TABLE_DETAIL);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private void setEntryentitylist(Long ruleid, String serialno, String entryname) {
        QFilter[] filters;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter ruleFilter = new QFilter(RULEID, "=", (Object)ruleid);
        Object orgid = customParams.get("orgId");
        QFilter orgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("startdate")));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("enddate")));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        if (!"totf_stbcbcf_detail".equals(entryname)) {
            String mappingid = (String)customParams.get("mappingid");
            QFilter qFilter = new QFilter("mappingid", "=", (Object)Long.parseLong(mappingid));
            QFilter entrytypeFilter = new QFilter("taxaccountserialno", "=", (Object)serialno);
            filters = new QFilter[]{orgFilter, startFilter, endFilter, qFilter, ruleFilter, entrytypeFilter};
        } else {
            filters = new QFilter[]{orgFilter, startFilter, endFilter, ruleFilter};
        }
        String selectProperties = "skssqq,skssqz,absolute,bizname,table,datatype,amountfield,datadirection,fetchamount,amount,filtercondition,ruleid,taxaccountserialno";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entryname, (String)selectProperties, (QFilter[])filters);
        this.getModel().beginInit();
        for (DynamicObject object : collection) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue("taxperiod", (Object)this.formatPeriod(object.getDate(SKSSQQ), object.getDate(SKSSQZ)), rowIndex);
            this.getModel().setValue("bizname", object.get("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("datatype", (Object)object.getString("datatype"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("amount"), rowIndex);
            this.getModel().setValue("filtercondition", object.get("filtercondition"), rowIndex);
            this.getModel().setValue("filtercondition_tag", object.get("filtercondition"), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_LIST);
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.selectCard(Integer.valueOf(0));
        entryentitycard.selectRowsChanged(Collections.singletonList(0), null);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String sbbBillStatus = (String)customParams.get("sbbBillStatus");
        boolean hasModifyPerm = customParams.getOrDefault("hasModifyPerm", true);
        if ("B".equals(sbbBillStatus) || "C".equals(sbbBillStatus) || !hasModifyPerm) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btncancel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
        if (!hasModifyPerm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u53f0\u8d26\u7684\u4fee\u6539\u6743\u9650\uff0c\u4e0d\u80fd\u4fee\u6539\u6570\u636e\u3002", (String)"AccountDetailFormPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
        }
    }

    private String formatPeriod(Date start, Date end) {
        int endMonth;
        int year = DateUtils.getYearOfDate((Date)start);
        int startMonth = DateUtils.getMonthOfDate((Date)start);
        if (startMonth == (endMonth = DateUtils.getMonthOfDate((Date)end))) {
            return DateUtils.format((Date)start, (String)DateUtils.YYYYMM_CHINESE);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s-%3$s\u6708", (String)"AccountDetailFormPlugin_2", (String)"taxc-totf", (Object[])new Object[0]), year, startMonth, endMonth);
    }

    static {
        TABLIE_DETAIL_ADJUST = "totf_accountdetail_adjust";
    }
}

