/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBatchImportPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.totf.business.sjjt.DraftService;

public class AccountImportPlugin
extends BatchImportPlugin {
    private static final String NUMBER = "number";
    private static final String ORG = "org";
    private static final String ZSPM_ENTRY = "tpo_zspm";
    private static final String ZSPM = "zspm";
    private static final String ZSZM = "zszm";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    public static final int TAXLIMIT_MONTH = 1;
    public static final int TAXLIMIT_SEASON = 3;
    public static final int TAXLIMIT_HALF_YEAR = 6;
    public static final int TAXLIMIT_YEAR = 12;

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        List orgNumberList = billdatas.stream().filter(d -> d.getData().getJSONObject(ORG) != null).map(d -> d.getData().getJSONObject(ORG).getString(NUMBER)).collect(Collectors.toList());
        QFilter qFilter = new QFilter(NUMBER, "in", orgNumberList);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        List orgIdList = orgs.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        Map zerodeclareGhjfMap = SystemParamUtil.getAppParameterBatch((String)"totf", (String)"zerodeclare_ghjf", orgIdList);
        Map zerodeclareGhcbjMap = SystemParamUtil.getAppParameterBatch((String)"totf", (String)"zerodeclare_ghcbj", orgIdList);
        Map zerodeclareCzljclMap = SystemParamUtil.getAppParameterBatch((String)"totf", (String)"zerodeclare_czljcl", orgIdList);
        Map<String, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(d -> d.getString(NUMBER), d -> d, (oldVal, newVal) -> oldVal));
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            JSONObject taxdeduction;
            Boolean zereDeclare;
            String entity;
            String number;
            DynamicObject org;
            ImportBillData importBillData = iterator.next();
            int index = importBillData.getStartIndex();
            JSONObject data = importBillData.getData();
            JSONObject orgJsonObject = data.getJSONObject(ORG);
            JSONObject zspmJsonObject = data.getJSONObject(ZSPM);
            if (orgJsonObject == null || zspmJsonObject == null || (org = orgMap.get(number = orgJsonObject.getString(NUMBER))) == null) continue;
            if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"AccountImportPlugin_0", (String)"taxc-totf", (Object[])new Object[0]), org.get(NUMBER)));
                iterator.remove();
            }
            if ("totf_otherincome_account".equals(entity = importBillData.getEntityMapping().getEntityType().getName())) {
                if ("0086".equals(zspmJsonObject.getString(NUMBER))) {
                    zereDeclare = (Boolean)zerodeclareGhjfMap.get(org.getLong("id"));
                    if (zereDeclare != null && zereDeclare.booleanValue()) {
                        logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u7684\u3010\u5de5\u4f1a\u7ecf\u8d39\u3011\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u5f15\u5165\u53f0\u8d26", (String)"AccountImportPlugin_4", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
                        iterator.remove();
                    }
                } else if ("0087".equals(zspmJsonObject.getString(NUMBER)) && (zereDeclare = (Boolean)zerodeclareGhcbjMap.get(org.getLong("id"))) != null && zereDeclare.booleanValue()) {
                    logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u7684\u3010\u5de5\u4f1a\u7b79\u5907\u91d1\u3011\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u5f15\u5165\u53f0\u8d26", (String)"AccountImportPlugin_5", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
                    iterator.remove();
                }
            } else if ("totf_jsxzsyxsf_account".equals(entity) && (zereDeclare = (Boolean)zerodeclareCzljclMap.get(org.getLong("id"))) != null && zereDeclare.booleanValue()) {
                logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u7684\u3010\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39\u3011\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u5f15\u5165\u53f0\u8d26", (String)"AccountImportPlugin_6", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
                iterator.remove();
            }
            if ((taxdeduction = data.getJSONObject("taxdeduction")) == null) continue;
            String zspmNumber = zspmJsonObject.getString(NUMBER);
            DynamicObject zspm = QueryServiceHelper.queryOne((String)ZSPM_ENTRY, (String)"taxtype.number", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)zspmNumber)});
            String taxdeductionNumber = taxdeduction.getString(NUMBER);
            DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_taxdeduction", (String)"taxcategory.number", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)taxdeductionNumber)});
            if (object != null && zspm != null && object.getString("taxcategory.number").equals(zspm.getString("taxtype.number"))) continue;
            logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u4e0d\u7b26\u5408\u8981\u6c42", (String)"AccountImportPlugin_7", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
            iterator.remove();
        }
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            StringBuilder taxlimit = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message, taxlimit);
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
                it.remove();
            }
            data.getData().put("payperiod", (Object)taxlimit.toString());
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData data, StringBuilder message, StringBuilder taxlimit) {
        JSONObject importData = data.getData();
        String entityName = data.getEntityMapping().getEntityType().getName();
        JSONObject zspmJsonObject = importData.getJSONObject(ZSPM);
        if (Objects.isNull(zspmJsonObject)) {
            return;
        }
        JSONObject orgJsonObject = importData.getJSONObject(ORG);
        if (Objects.isNull(orgJsonObject)) {
            return;
        }
        if (!this.checkDate(importData.getString(STARTDATE), ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77", (String)"AccountImportPlugin_2", (String)"taxc-totf", (Object[])new Object[0]), message) || !this.checkDate(importData.getString(ENDDATE), ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62", (String)"AccountImportPlugin_3", (String)"taxc-totf", (Object[])new Object[0]), message)) {
            return;
        }
        String zspmNumber = zspmJsonObject.getString(NUMBER);
        String orgNumber = orgJsonObject.getString(NUMBER);
        Long orgId = (Long)TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgNum((String)orgNumber).getData();
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgId));
        if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return;
        }
        DynamicObject zspmObject = QueryServiceHelper.queryOne((String)ZSPM_ENTRY, (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)zspmNumber)});
        if (Objects.isNull(zspmObject)) {
            return;
        }
        AbstractLicenseCheckBatchImportPlugin.checkOrg((String)orgNumber, (StringBuilder)message, (String)"totf");
        Date startdate = importData.getDate(STARTDATE);
        Date enddate = importData.getDate(ENDDATE);
        if (Objects.isNull(startdate) || Objects.isNull(enddate)) {
            return;
        }
        JSONObject zszmJsonObject = importData.getJSONObject(ZSZM);
        ArrayList<Long> zszmIds = new ArrayList<Long>();
        if (!Objects.isNull(zszmJsonObject)) {
            String zszmProjectname = zszmJsonObject.getString("projectname");
            DynamicObjectCollection zspmObjs = QueryServiceHelper.query((String)"tpo_tysbsf_bizdef_entry", (String)"id", (QFilter[])new QFilter[]{new QFilter("projectname", "=", (Object)zszmProjectname)});
            zspmObjs.forEach(s -> zszmIds.add(s.getLong("id")));
        }
        DynamicObject orgObject = (DynamicObject)((List)result.getData()).get(0);
        this.checkData(message, orgObject, zspmObject, startdate, enddate, taxlimit, entityName, zszmIds);
        String taxofficeNumber = importData.getJSONObject("taxoffice").getString(NUMBER);
        DynamicObjectCollection dynamicObjects = DraftService.hasIntersection(entityName, orgNumber, startdate, enddate, taxofficeNumber, zspmNumber, zszmIds);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            String msg = ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d \u201c\u5f81\u6536\u54c1\u76ee\u201d %s \u201c\u7a0e\u52a1\u673a\u5173\u201d \u7684\u7ec4\u5408\u503c\u76f8\u540c\u65f6\uff0c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u7684\u65e5\u671f\u4e0d\u80fd\u6709\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AccountImportPlugin_21", (String)"taxc-totf", (Object[])new Object[0]);
            if ("totf_jsxzsyxsf_account".equals(entityName)) {
                message.append(String.format(msg, ResManager.loadKDString((String)"\u201c\u5f81\u6536\u5b50\u76ee\u201d", (String)"AccountImportPlugin_22", (String)"taxc-totf", (Object[])new Object[0])));
            } else {
                message.append(String.format(msg, ""));
            }
            return;
        }
    }

    private void checkData(StringBuilder message, DynamicObject orgObject, DynamicObject zspmObject, Date startdate, Date enddate, StringBuilder taxlimit, String entityName, List<Long> zszmIds) {
        Optional<DynamicObject> zszmCollect;
        boolean check;
        String zspmId = zspmObject.getString("id");
        if (this.isMatchZspm(entityName, zspmId, message)) {
            return;
        }
        DynamicObjectCollection qtsfentity = orgObject.getDynamicObjectCollection("qtsfentity");
        List zspmCollect = qtsfentity.stream().filter(s -> zspmId.equals(s.getString("collectrate.id"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(zspmCollect)) {
            message.append(ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u5f81\u6536\u54c1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AccountImportPlugin_8", (String)"taxc-totf", (Object[])new Object[0]));
            return;
        }
        List dateCollect = qtsfentity.stream().filter(s -> zspmId.equals(s.getString("collectrate.id"))).filter(s -> startdate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddate.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dateCollect)) {
            message.append(ResManager.loadKDString((String)"\u6b64\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"AccountImportPlugin_9", (String)"taxc-totf", (Object[])new Object[0]));
            return;
        }
        if (this.taxLimitCheck(entityName, message, startdate, enddate, taxlimit)) {
            return;
        }
        String taxperiod = ((DynamicObject)dateCollect.get(0)).getString("taxperiod");
        taxlimit.append(taxperiod);
        boolean bl = "count".equals(taxperiod) ? DateUtils.validDateRange((String)taxperiod, (Date)startdate, (Date)enddate) : (check = DateUtils.validDateRange((String)taxperiod, (Date)startdate, (Date)enddate) || DateUtils.validDateRange((String)"month", (Date)startdate, (Date)enddate));
        if (!check) {
            message.append(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u7684\u8d39\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u7f34\u7eb3\u671f\u9650\u7684\u8981\u6c42\u3002", (String)"AccountImportPlugin_10", (String)"taxc-totf", (Object[])new Object[0]));
            switch (((DynamicObject)dateCollect.get(0)).getString("taxperiod")) {
                case "year": {
                    message.append(ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u5e74\u3011", (String)"AccountImportPlugin_16", (String)"taxc-totf", (Object[])new Object[0]));
                    break;
                }
                case "halfyear": {
                    message.append(ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u534a\u5e74\u3011", (String)"AccountImportPlugin_17", (String)"taxc-totf", (Object[])new Object[0]));
                    break;
                }
                case "season": {
                    message.append(ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u5b63\u3011", (String)"AccountImportPlugin_18", (String)"taxc-totf", (Object[])new Object[0]));
                    break;
                }
                case "month": {
                    message.append(ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u6708\u3011", (String)"AccountImportPlugin_19", (String)"taxc-totf", (Object[])new Object[0]));
                    break;
                }
                case "count": {
                    message.append(ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u6b21\u3011", (String)"AccountImportPlugin_20", (String)"taxc-totf", (Object[])new Object[0]));
                }
            }
        }
        if ("totf_jsxzsyxsf_account".equals(entityName) && zszmIds.size() > 0 && !(zszmCollect = dateCollect.stream().filter(s -> zszmIds.contains(s.getLong("collectitem.id"))).findFirst()).isPresent()) {
            message.append(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee\u4e0d\u5b58\u5728\u4e8e\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u3002", (String)"AccountImportPlugin_11", (String)"taxc-totf", (Object[])new Object[0]));
            return;
        }
    }

    private boolean taxLimitCheck(String entityName, StringBuilder message, Date startdate, Date enddate, StringBuilder taxlimit) {
        String taxperiod = "";
        if (!"totf_embankment_account".equals(entityName) && startdate.compareTo(enddate) == 0) {
            taxperiod = "count";
        } else {
            int dayOfDate2;
            int dayOfDate = DateUtils.getDayOfDate((Date)startdate);
            if (dayOfDate != 1) {
                message.append(ResManager.loadKDString((String)"\u5982\u6309\u671f\u7533\u62a5\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u5fc5\u987b\u4e3a\u6708\u521d\u7b2c\u4e00\u5929\uff0c\u5982\u6309\u6b21\u7533\u62a5\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77\u7b49\u4e8e\u8d39\u6b3e\u6240\u5c5e\u671f\u6b62\u3002", (String)"AccountImportPlugin_12", (String)"taxc-totf", (Object[])new Object[0]));
                return true;
            }
            int dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)enddate));
            if (dayOfDate1 != (dayOfDate2 = DateUtils.getDayOfDate((Date)enddate))) {
                message.append(ResManager.loadKDString((String)"\u5982\u6309\u671f\u7533\u62a5\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u4e3a\u6708\u672b\u6700\u540e\u4e00\u5929\uff0c\u5982\u6309\u6b21\u7533\u62a5\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77\u7b49\u4e8e\u8d39\u6b3e\u6240\u5c5e\u671f\u6b62\u3002", (String)"AccountImportPlugin_13", (String)"taxc-totf", (Object[])new Object[0]));
                return true;
            }
            int monthDiff = DateUtils.getMonthDiff((Date)startdate, (Date)enddate);
            switch (monthDiff) {
                case 12: {
                    taxperiod = "year";
                    break;
                }
                case 6: {
                    taxperiod = "halfyear";
                    break;
                }
                case 3: {
                    taxperiod = "season";
                    break;
                }
                case 1: {
                    taxperiod = "month";
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)taxperiod)) {
            message.append(ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u8303\u56f4\u5fc5\u987b\u662f\u6574\u6708\u3001\u6574\u5b63\u3001\u534a\u5e74\u3001\u6574\u5e74\u3001\u6309\u6b21(\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77\u7b49\u4e8e\u8d39\u6b3e\u6240\u5c5e\u671f\u6b62)\u3002", (String)"AccountImportPlugin_14", (String)"taxc-totf", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isMatchZspm(String entityName, String id, StringBuilder message) {
        if ("totf_otherincome_account".equals(entityName) && !String.valueOf(ZspmConstant.ID_GHJH_ZPSM).equals(id) && !String.valueOf(ZspmConstant.ID_GHCBJ_ZPSM).equals(id)) {
            message.append(ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u5f81\u6536\u54c1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AccountImportPlugin_8", (String)"taxc-totf", (Object[])new Object[0]));
            return true;
        }
        if ("totf_jsxzsyxsf_account".equals(entityName) && !String.valueOf(ZspmConstant.ID_CZLJCLF_ZPSM).equals(id)) {
            message.append(ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u5f81\u6536\u54c1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"AccountImportPlugin_8", (String)"taxc-totf", (Object[])new Object[0]));
            return true;
        }
        if ("totf_embankment_account".equals(entityName) && !String.valueOf(ZspmConstant.ID_DWFHF_ZPSM).equals(id)) {
            message.append(ResManager.loadKDString((String)"\u6b64\u5f81\u6536\u54c1\u76ee\u4e0d\u662f\u5824\u56f4\u9632\u62a4\u8d39\u3002", (String)"AccountImportPlugin_15", (String)"taxc-totf", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkDate(String dateStr, String fieldName, StringBuilder message) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return false;
        }
        String format = "yyyy-MM-dd";
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            Date date = DateUtils.stringToDate((String)dateStr);
        }
        catch (Exception e) {
            message.append(String.format(ResManager.loadKDString((String)"%s:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"AccountImportPlugin_1", (String)"taxc-totf", (Object[])new Object[0]), fieldName));
            return false;
        }
        AccountImportPlugin.checkLeapYear(dateStr, format, fieldName, message);
        return true;
    }

    private static void checkLeapYear(String dateStr, String format, String fieldName, StringBuilder message) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            LocalDate localDate = LocalDate.parse(dateStr, dateTimeFormatter);
            if (!localDate.isLeapYear() && dateStr.endsWith("-02-29")) {
                message.append(String.format(ResManager.loadKDString((String)"%s:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"AccountImportPlugin_1", (String)"taxc-totf", (Object[])new Object[0]), fieldName));
            }
        }
        catch (Exception e) {
            message.append(String.format(ResManager.loadKDString((String)"%s:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"AccountImportPlugin_1", (String)"taxc-totf", (Object[])new Object[0]), fieldName));
        }
    }
}

