/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.totf.business.account.OtherIncomeService;

public abstract class CommonAccountEditPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    public static final String ORG = "org";
    public static final String TAXOFFICE = "taxoffice";
    public static final String ZSPM = "zspm";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";
    public static final String ZSXM = "zsxm";
    public static final String TAXDEDUCTION = "taxdeduction";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxdeduction = (BasedataEdit)this.getControl(TAXDEDUCTION);
        taxdeduction.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String isChangingMainOrg = (String)this.getModel().getContextVariable("isChangingMainOrg");
        Long orgId = 0L;
        if (!Boolean.TRUE.toString().equals(isChangingMainOrg)) {
            Object selectOrgId = this.getView().getFormShowParameter().getCustomParams().get("SELECT_ORG_ID");
            this.doSetTaxOrg(selectOrgId, RequestContext.get().getOrgId());
            orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        } else {
            String newOrgValue = (String)this.getModel().getContextVariable("newOrgValue");
            if (StringUtil.isNotEmpty((CharSequence)newOrgValue)) {
                orgId = Long.parseLong(newOrgValue);
            }
        }
        TaxResult existByOrgId = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgId);
        if (!((Boolean)existByOrgId.getData()).booleanValue()) {
            this.getModel().setValue(ORG, null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CommonAccountEditPlugin_14", (String)"taxc-totf", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(ORG, (Object)orgId);
        Optional<DynamicObject> optional = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG));
        if (optional.isPresent()) {
            boolean allMatch;
            List ids;
            Optional<Long> longOptional = Optional.ofNullable(TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)optional.get().getLong("id")).getData()).map(s -> s.getDynamicObject(TAXOFFICE)).map(s -> s.getLong("id"));
            this.getModel().setValue(TAXOFFICE, (Object)longOptional.orElseGet(() -> null));
            boolean enableCard = OtherIncomeService.isEnableCard(optional.get().getLong("id"));
            if (!enableCard) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u76f8\u5173\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201c\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"CommonAccountEditPlugin_13", (String)"taxc-totf", (Object[])new Object[0]), optional.get().getString("name")));
                return;
            }
            DynamicObjectCollection rows = OtherIncomeService.getCardRows(optional.get().getLong("id"), this.getZspmIds());
            if (CollectionUtils.isEmpty((Collection)rows)) {
                this.getModel().setValue(ZSPM, null);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u76f8\u5173\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201c\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"CommonAccountEditPlugin_13", (String)"taxc-totf", (Object[])new Object[0]), optional.get().getString("name")));
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)rows) && (ids = rows.stream().map(s -> s.getLong("collectrate.id")).distinct().collect(Collectors.toList())).size() == 1) {
                this.getModel().setValue(ZSPM, ids.get(0));
            }
            if (allMatch = this.getZspmIds().stream().allMatch(zspmId -> SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)ZspmEnum.valueOfZspmId((Long)zspmId).getParamKey(), (long)((DynamicObject)optional.get()).getLong("id")))) {
                String msg = this.getZspmIds().stream().map(s -> ZspmEnum.valueOfZspmId((Long)s)).map(s -> s.getName()).collect(Collectors.joining("\uff0c"));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%2$s.\u6838\u5b9a\u96f6\u7533\u62a5\u201d\u53c2\u6570\u5df2\u5f00\u542f\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26\u3002", (String)"CommonAccountEditPlugin_11", (String)"taxc-totf", (Object[])new Object[0]), optional.get().getString("name"), msg));
                return;
            }
        } else {
            this.getModel().setValue(TAXOFFICE, null);
        }
        this.getModel().setValue("sourcedata", (Object)"hand");
    }

    protected abstract void setDefaultProperty();

    protected abstract List<Long> getZspmIds();

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if (Lists.newArrayList((Object[])new String[]{ORG, TAXOFFICE, ZSPM}).contains(name)) {
            this.setDefaultProperty();
        } else if (STARTDATE.equals(name) || ENDDATE.equals(name)) {
            String entityName = e.getChangeSet()[0].getDataEntity().getDataEntityType().getName();
            Object newValue = changeData.getNewValue();
            if (newValue != null) {
                Date end;
                Date start;
                Optional<DynamicObject> cardRowOpt2;
                Long zspmId;
                Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
                Optional<DynamicObject> cardRowOpt1 = OtherIncomeService.getCardRow(orgId, zspmId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ZSPM)).map(s -> s.getLong("id")).orElseGet(() -> 0L), (Date)this.getModel().getValue(STARTDATE), (Date)this.getModel().getValue(ENDDATE));
                if (cardRowOpt1.isPresent()) {
                    String payperiod = cardRowOpt1.get().getString("taxperiod");
                    if ("count".equals(payperiod)) {
                        this.getModel().setValue(STARTDATE, newValue);
                        this.getModel().setValue(ENDDATE, newValue);
                    } else if ("month".equals(payperiod)) {
                        this.getModel().setValue(STARTDATE, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)newValue)));
                        this.getModel().setValue(ENDDATE, (Object)DateUtils.getLastDateOfMonth1((Date)((Date)newValue)));
                    } else if ("totf_water_fund".equals(entityName)) {
                        if ("season".equals(payperiod)) {
                            this.getModel().setValue(STARTDATE, (Object)DateUtils.getFirstDateOfSeason((Date)((Date)newValue)));
                            this.getModel().setValue(ENDDATE, (Object)DateUtils.getLastDateOfSeason((Date)((Date)newValue)));
                        } else if ("halfyear".equals(payperiod)) {
                            this.getModel().setValue(STARTDATE, (Object)DateUtils.getFirstDateOfHalfYear((Date)((Date)newValue)));
                            this.getModel().setValue(ENDDATE, (Object)DateUtils.getLastDateOfHalfYear((Date)((Date)newValue)));
                        } else if ("year".equals(payperiod)) {
                            this.getModel().setValue(STARTDATE, (Object)DateUtils.getFirstDateOfYear((Date)((Date)newValue)));
                            this.getModel().setValue(ENDDATE, (Object)DateUtils.getLastDateOfYear((Date)((Date)newValue)));
                        }
                    } else if (STARTDATE.equals(name)) {
                        this.getModel().setValue(STARTDATE, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)newValue)));
                    } else {
                        this.getModel().setValue(ENDDATE, (Object)DateUtils.getLastDateOfMonth1((Date)((Date)newValue)));
                    }
                }
                if (!(cardRowOpt2 = OtherIncomeService.getCardRow(orgId, zspmId, start = (Date)this.getModel().getValue(STARTDATE), end = (Date)this.getModel().getValue(ENDDATE))).isPresent()) {
                    this.getModel().setValue("payperiod", null);
                    if ("totf_jsxzsyxsf_account".equals(entityName)) {
                        this.getModel().setValue("zszm", null);
                    }
                    String zspmName = Optional.ofNullable((DynamicObject)this.getModel().getValue(ZSPM)).map(s -> s.getString("name")).orElseGet(() -> "");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u671f\u4e0d\u5b58\u5728\u6709\u6548\u7684\u201c%s\u201d\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"CommonAccountEditPlugin_0", (String)"taxc-totf", (Object[])new Object[0]), zspmName));
                    return;
                }
                this.getModel().setValue("payperiod", (Object)cardRowOpt2.get().getString("taxperiod"));
                if ("totf_jsxzsyxsf_account".equals(entityName)) {
                    this.getModel().setValue("zszm", (Object)cardRowOpt2.get().getLong("collectitem_id"));
                }
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("sourcedata", (Object)"hand");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            Optional<DynamicObject> optional;
            OperationStatus status;
            String entityName = this.getModel().getDataEntityType().getName();
            this.check(args, ORG, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAccountEditPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, TAXOFFICE, ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAccountEditPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, ZSXM, ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAccountEditPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, ZSPM, ResManager.loadKDString((String)"\u5f81\u6536\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAccountEditPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, STARTDATE, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAccountEditPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, ENDDATE, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonAccountEditPlugin_6", (String)"taxc-totf", (Object[])new Object[0]));
            this.checkDate(args, ResManager.loadKDString((String)"\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u201d\u5e94\u65e9\u4e8e\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u201d\u3002", (String)"CommonAccountEditPlugin_12", (String)"taxc-totf", (Object[])new Object[0]));
            Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            String orgName = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getString("name")).orElseGet(() -> "");
            Long taxofficed = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAXOFFICE)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            Long zspmId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ZSPM)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            String zspmName = Optional.ofNullable((DynamicObject)this.getModel().getValue(ZSPM)).map(s -> s.getString("name")).orElseGet(() -> "");
            Date start = (Date)this.getModel().getValue(STARTDATE);
            Date end = (Date)this.getModel().getValue(ENDDATE);
            String payperiod = (String)this.getModel().getValue("payperiod");
            ComboEdit comboEdit = (ComboEdit)this.getControl("payperiod");
            ComboProp property = (ComboProp)comboEdit.getProperty();
            Map<String, LocaleString> collect = property.getComboItems().stream().collect(Collectors.toMap(s -> s.getValue(), s -> s.getName()));
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CommonAccountEditPlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Optional<DynamicObject> cardRowOpt2 = OtherIncomeService.getCardRow(orgId, zspmId, start, end);
            if (!cardRowOpt2.isPresent()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u76f8\u5173\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201c\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"CommonAccountEditPlugin_13", (String)"taxc-totf", (Object[])new Object[0]), orgName));
                args.setCancel(true);
                return;
            }
            if (this.checkTaxLimit()) {
                String taxLimit = DateUtils.getTaxLimit((Date)start, (Date)end);
                if ("month".equals(payperiod)) {
                    if (!payperiod.equals(taxLimit)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u201c%1$s\u201d\u7684\u7eb3\u7a0e\u671f\u9650\u4e3a\u201c%2$s\u201d\uff0c\u53f0\u8d26\u5468\u671f\u5e94\u4e3a\u6708\u5ea6\u6216\u8005%3$s\u5ea6\u3002", (String)"CommonAccountEditPlugin_9", (String)"taxc-totf", (Object[])new Object[0]), zspmName, collect.get(payperiod), collect.get(payperiod)));
                        args.setCancel(true);
                        return;
                    }
                } else if (Lists.newArrayList((Object[])new String[]{"season", "halfyear", "year"}).contains(payperiod) && !payperiod.equals(taxLimit) && !taxLimit.equals("month")) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u201c%1$s\u201d\u7684\u7eb3\u7a0e\u671f\u9650\u4e3a\u201c%2$s\u201d\uff0c\u53f0\u8d26\u5468\u671f\u5e94\u4e3a\u6708\u5ea6\u6216\u8005%3$s\u5ea6\u3002", (String)"CommonAccountEditPlugin_9", (String)"taxc-totf", (Object[])new Object[0]), zspmName, collect.get(payperiod), collect.get(payperiod)));
                    args.setCancel(true);
                    return;
                }
            }
            if (this.checkExistsAccount() && OperationStatus.ADDNEW.equals((Object)(status = this.getView().getFormShowParameter().getStatus())) && (optional = OtherIncomeService.queryExistsAccount(entityName, orgId, taxofficed, zspmId, start, end)).isPresent()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u5f53\u524d\u7a0e\u6b3e\u6240\u5c5e\u671f\u5df2\u5b58\u5728\u671f\u95f4\u76f8\u4ea4\u7684\u6570\u636e \u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CommonAccountEditPlugin_10", (String)"taxc-totf", (Object[])new Object[0]), optional.get().getString("billno")));
                args.setCancel(true);
                return;
            }
            ZspmEnum zspmEnum = ZspmEnum.valueOfZspmId((Long)zspmId);
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)zspmEnum.getParamKey(), (long)orgId);
            if (zerodeclare) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%2$s.\u6838\u5b9a\u96f6\u7533\u62a5\u201d\u53c2\u6570\u5df2\u5f00\u542f\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26\u3002", (String)"CommonAccountEditPlugin_11", (String)"taxc-totf", (Object[])new Object[0]), orgName, zspmEnum.getName()));
                args.setCancel(true);
                return;
            }
        }
    }

    protected abstract boolean checkTaxLimit();

    protected abstract boolean checkExistsAccount();

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (TAXDEDUCTION.equals(evt.getProperty().getName())) {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            Date startdate = (Date)this.getModel().getValue(STARTDATE);
            Date enddate = (Date)this.getModel().getValue(ENDDATE);
            QFilter taxDeductionFilter = this.getTaxDeductionFilter();
            if (taxDeductionFilter != null) {
                listFilterParameter.getQFilters().add(taxDeductionFilter);
            }
            listFilterParameter.getQFilters().add(new QFilter(STARTDATE, "<=", (Object)startdate).and(new QFilter(ENDDATE, ">=", (Object)enddate).or(new QFilter(ENDDATE, "is null", null))));
        }
    }

    protected QFilter getTaxDeductionFilter() {
        return null;
    }

    public void check(BeforeDoOperationEventArgs args, String field, String msg) {
        Object org;
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        if (properties.containsKey((Object)field) && (org = this.getModel().getValue(field)) == null) {
            args.setCancel(true);
            throw new KDBizException(msg);
        }
    }

    public void doSetTaxOrg(Object selectOrgId, Long orgId) {
        if (selectOrgId != null) {
            this.getModel().setValue(ORG, selectOrgId);
        } else {
            long currUserId = RequestContext.get().getCurrUserId();
            Long orgid = OrgCheckUtil.setDefaultOrg((Long)orgId, (Long)currUserId, (IFormView)this.getView());
            if (orgid != null) {
                this.getModel().setValue(ORG, (Object)orgid);
            }
        }
    }

    private void checkDate(BeforeDoOperationEventArgs args, String msg) {
        Date start = (Date)this.getModel().getValue(STARTDATE);
        Date end = (Date)this.getModel().getValue(ENDDATE);
        if (start == null || end == null) {
            return;
        }
        if (start.after(end)) {
            args.setCancel(true);
            throw new KDBizException(msg);
        }
    }
}

