/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.common.utils.WhsyjsfUtils;

public class EmploymentFundFormPlugin
extends AbstractLicenseCheckFormPlugin
implements BeforeF7SelectListener {
    private static final Long JM_ID1 = 1660876890359052288L;
    private static final Long JM_ID2 = 1660876893370563584L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bill = (BasedataEdit)this.getControl("taxdeduction");
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TaxResult result;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
            this.getModel().setValue("org", null);
            return;
        }
        if (org != null && (result = TaxcMainDataServiceHelper.queryTaxOfficeIdByOrgId(Collections.singletonList(org.getLong("id")))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            this.getModel().setValue("taxoffice", ((List)result.getData()).get(0));
        }
        Date declaredate = new Date();
        Date date = DateUtils.getFirstDateOfMonth((Date)declaredate);
        Map<String, Date> map = WhsyjsfUtils.getStartAndEndDate(date, "month");
        this.getModel().setValue("startdate", (Object)map.get("startdate"));
        this.getModel().setValue("enddate", (Object)map.get("enddate"));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("taxdeduction".equals(evt.getProperty().getName())) {
            BigDecimal staffnumber = (BigDecimal)this.getModel().getValue("staffnumbernew");
            BigDecimal disablednumber = (BigDecimal)this.getModel().getValue("disablednumbernew");
            BigDecimal staffnumbers = staffnumber;
            BigDecimal disablednumbers = disablednumber;
            BigDecimal ratio = (BigDecimal)this.getModel().getValue("ratio");
            if (staffnumber.compareTo(new BigDecimal(30)) <= 0 && staffnumber.compareTo(BigDecimal.ZERO) > 0) {
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.getListFilterParameter().setFilter(new QFilter("number", "=", (Object)"35049901"));
            } else if (disablednumber.compareTo(BigDecimal.ZERO) > 0) {
                if (staffnumbers.compareTo(new BigDecimal("30")) > 0 && disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) >= 0 && disablednumbers.divide(staffnumbers, 2, 4).compareTo(ratio) < 0 || disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) < 0) {
                    ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                    formShowParameter.getListFilterParameter().setFilter(new QFilter("number", "=", (Object)"35013601"));
                } else {
                    ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                    formShowParameter.getListFilterParameter().setFilter(new QFilter("number", "=", (Object)""));
                }
            } else {
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.getListFilterParameter().setFilter(new QFilter("number", "=", (Object)""));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        BigDecimal staffnumber = (BigDecimal)this.getModel().getValue("staffnumbernew");
        BigDecimal disablednumber = (BigDecimal)this.getModel().getValue("disablednumbernew");
        BigDecimal staffnumbers = staffnumber;
        BigDecimal disablednumbers = disablednumber;
        BigDecimal ratio = (BigDecimal)this.getModel().getValue("ratio");
        BigDecimal bqynse = (BigDecimal)this.getModel().getValue("bqynse");
        if ("staffnumbernew".equals(name) || "disablednumbernew".equals(name) || "ratio".equals(name)) {
            if (staffnumber.compareTo(new BigDecimal(30)) <= 0) {
                this.getModel().setValue("taxdeduction", (Object)JM_ID2);
            } else if (disablednumber.compareTo(BigDecimal.ZERO) > 0) {
                if (staffnumbers.compareTo(new BigDecimal("30")) > 0 && disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) >= 0 && disablednumbers.divide(staffnumbers, 4, 4).compareTo(ratio) < 0 || disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) < 0) {
                    this.getModel().setValue("taxdeduction", (Object)JM_ID1);
                } else {
                    this.getModel().setValue("taxdeduction", null);
                }
            } else {
                this.getModel().setValue("taxdeduction", null);
            }
        } else if ("taxdeduction".equals(name) || "bqynse".equals(name)) {
            DynamicObject taxdeduction = (DynamicObject)this.getModel().getValue("taxdeduction");
            if (taxdeduction != null) {
                if (taxdeduction.getString("number").equals("35013601")) {
                    if (disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) >= 0 && disablednumbers.divide(staffnumbers, 2, 4).compareTo(ratio) < 0) {
                        this.getModel().setValue("deductionamount", (Object)bqynse.multiply(new BigDecimal("0.5")));
                    } else if (disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) < 0) {
                        this.getModel().setValue("deductionamount", (Object)bqynse.multiply(new BigDecimal("0.9")));
                    }
                } else if (staffnumber.compareTo(new BigDecimal(30)) <= 0 && taxdeduction.getString("number").equals("35049901")) {
                    this.getModel().setValue("deductionamount", (Object)bqynse);
                }
            } else {
                this.getModel().setValue("deductionamount", (Object)BigDecimal.ZERO);
            }
        }
    }
}

