/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBatchImportPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;

public class EmploymentFundImportPlugin
extends BatchImportPlugin {
    private static final Character tabLine = Character.valueOf('\n');

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
                it.remove();
                continue;
            }
            EmploymentFundImportPlugin.setDefaultValue(data.getData());
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData data, StringBuilder message) {
        JSONObject zspm;
        JSONObject org = data.getData().getJSONObject("org");
        DynamicObject orgObject = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,taxorg.id", (QFilter[])new QFilter[]{new QFilter("number", "=", org.get((Object)"number"))});
        AbstractLicenseCheckBatchImportPlugin.checkOrg((String)org.getString("number"), (StringBuilder)message, (String)"totf");
        if (orgObject != null) {
            Boolean permission = PermissionUtils.getPermByUserIdOrg((Long)orgObject.getLong("taxorg.id"), (Long)RequestContext.get().getCurrUserId(), (String)"totf", (String)"totf_employment_fund", (String)"47150e89000000ac");
            if (!TaxcMainDataServiceHelper.isTaxcMainByOrgNum((String)org.getString("number")).isSuccess() || !permission.booleanValue()) {
                EmploymentFundImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5b58\u5728\u3001\u6216\u662f\u5426\u6709\u6743\u9650\u3001\u6216\u662f\u5426\u5df2\u5ba1\u6838\u3001\u6216\u662f\u5426\u5df2\u542f\u7528", (String)"EmploymentFundImportPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
            }
        } else {
            EmploymentFundImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5b58\u5728\u3001\u6216\u662f\u5426\u6709\u6743\u9650\u3001\u6216\u662f\u5426\u5df2\u5ba1\u6838\u3001\u6216\u662f\u5426\u5df2\u542f\u7528", (String)"EmploymentFundImportPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
        }
        JSONObject taxoffice = data.getData().getJSONObject("taxoffice");
        if (taxoffice != null) {
            DynamicObject taxofficeExist = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", taxoffice.get((Object)"number"))});
            if (taxofficeExist == null) {
                EmploymentFundImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u4e0d\u5b58\u5728\u4e8e\u7a0e\u52a1\u57fa\u7840\u670d\u52a1-\u7a0e\u52a1\u673a\u5173\u8d44\u6599\u91cc\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u7a0e\u52a1\u673a\u5173\u7f16\u7801\u3002", (String)"EmploymentFundImportPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
            } else if (taxofficeExist.getString("enable").equals("0")) {
                EmploymentFundImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u4e3a\u7981\u7528\u72b6\u6001", (String)"EmploymentFundImportPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
            }
        }
        if ((zspm = data.getData().getJSONObject("zspm")) != null && !"0085".equals(zspm.getString("number"))) {
            EmploymentFundImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u4e0d\u662f\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1\u7684\u5f81\u6536\u54c1\u76ee", (String)"EmploymentFundImportPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
        }
        String salary = data.getData().getString("salary");
        String staffnumber = data.getData().getString("staffnumbernew");
        String ratio = data.getData().getString("ratio");
        String disablednumber = data.getData().getString("disablednumbernew");
        String bqyjse = data.getData().getString("bqyjse");
        boolean checkSalary = this.checkNumeric(salary, ResManager.loadKDString((String)"\u4e0a\u5e74\u5728\u804c\u804c\u5de5\u5de5\u8d44\u603b\u989d", (String)"EmploymentFundImportPlugin_4", (String)"taxc-totf", (Object[])new Object[0]), message);
        boolean checkStaffnumber = this.checkNumeric(staffnumber, ResManager.loadKDString((String)"\u4e0a\u5e74\u5728\u804c\u804c\u5de5\u4eba\u6570", (String)"EmploymentFundImportPlugin_5", (String)"taxc-totf", (Object[])new Object[0]), message);
        boolean checkRatio = this.checkNumeric(ratio, ResManager.loadKDString((String)"\u5e94\u5b89\u6392\u6b8b\u75be\u4eba\u5c31\u4e1a\u6bd4\u4f8b", (String)"EmploymentFundImportPlugin_6", (String)"taxc-totf", (Object[])new Object[0]), message);
        boolean checkDisablednumber = this.checkNumeric(disablednumber, ResManager.loadKDString((String)"\u4e0a\u5e74\u5b9e\u9645\u5b89\u6392\u6b8b\u75be\u4eba\u5c31\u4e1a\u4eba\u6570", (String)"EmploymentFundImportPlugin_7", (String)"taxc-totf", (Object[])new Object[0]), message);
        boolean checkBqyjse = this.checkNumeric(bqyjse, ResManager.loadKDString((String)"\u672c\u671f\u5df2\u7f34\u8d39\u989d", (String)"EmploymentFundImportPlugin_8", (String)"taxc-totf", (Object[])new Object[0]), message);
    }

    private static void errorMsg(StringBuilder errors, String msg) {
        errors.append(msg).append(tabLine);
    }

    private static void setDefaultValue(JSONObject dynamicObject) {
        BigDecimal staffnumbers = new BigDecimal(dynamicObject.getString("staffnumbernew"));
        BigDecimal salary = dynamicObject.getBigDecimal("salary");
        BigDecimal averagesalary = dynamicObject.getBigDecimal("averagesalary");
        if (staffnumbers.compareTo(BigDecimal.ZERO) > 0) {
            averagesalary = salary.divide(staffnumbers, 2, 4);
            dynamicObject.put("averagesalary", (Object)averagesalary);
        }
    }

    private boolean checkNumeric(String value, String fieldName, StringBuilder message) {
        if (value == null) {
            return true;
        }
        if (!(value = value.replaceAll(",", "")).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            EmploymentFundImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\uff1a\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"EmploymentFundImportPlugin_9", (String)"taxc-totf", (Object[])new Object[0]), fieldName));
            return false;
        }
        return true;
    }
}

