/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.account.OtherIncomeService;
import kd.taxc.totf.formplugin.account.CommonAccountEditPlugin;

public class OtherIncomeEditPlugin
extends CommonAccountEditPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit zspm = (BasedataEdit)this.getControl("zspm");
        zspm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultProperty();
    }

    @Override
    protected void setDefaultProperty() {
        Optional<DynamicObject> cardRowOpt;
        String entityName = this.getModel().getDataEntityType().getName();
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Long taxofficed = Optional.ofNullable((DynamicObject)this.getModel().getValue("taxoffice")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Long zspmId = Optional.ofNullable((DynamicObject)this.getModel().getValue("zspm")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        if (orgId == 0L || taxofficed == 0L || zspmId == 0L) {
            return;
        }
        Optional<DynamicObject> optional = OtherIncomeService.queryExistsAccount(entityName, orgId, taxofficed, zspmId);
        Map<Object, Object> last = new HashMap(16);
        if (optional.isPresent()) {
            DynamicObject object = optional.get();
            String taxLimit = DateUtils.getTaxLimit((Date)object.getDate("startdate"), (Date)object.getDate("enddate"));
            last = OtherIncomeService.getStartOrEndByType(taxLimit, "next", object.getDate("startdate"));
            cardRowOpt = OtherIncomeService.getCardRow(orgId, zspmId, (Date)last.get("startdate"), (Date)last.get("enddate"));
        } else {
            cardRowOpt = OtherIncomeService.getCardRow(orgId, zspmId);
            if (cardRowOpt.isPresent()) {
                last = OtherIncomeService.getStartOrEndByType(cardRowOpt.get().getString("taxperiod"), "last", new Date());
                cardRowOpt = OtherIncomeService.getCardRow(orgId, zspmId, (Date)last.get("startdate"), (Date)last.get("enddate"));
            }
        }
        if (cardRowOpt.isPresent()) {
            this.getModel().setValue("payperiod", (Object)cardRowOpt.get().getString("taxperiod"));
            Date start = (Date)last.get("startdate");
            Date end = (Date)last.get("enddate");
            Date effectivestart = cardRowOpt.get().getDate("effectivestart");
            Date effectiveend = cardRowOpt.get().getDate("effectiveend");
            if (OtherIncomeService.isContainAll(effectivestart, effectiveend, start, end)) {
                this.getModel().setValue("startdate", (Object)start);
                this.getModel().setValue("enddate", (Object)end);
            } else {
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        if ("zspm".equals(evt.getProperty().getName())) {
            Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            Date start = (Date)this.getModel().getValue("startdate");
            Date end = (Date)this.getModel().getValue("startdate");
            if (orgId == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OtherIncomeEditPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection cardRows = OtherIncomeService.getCardRows(orgId, this.getZspmIds());
            List itemIds = cardRows.stream().map(s -> s.getLong("collectrate.id")).collect(Collectors.toList());
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.getQFilters().add(new QFilter("id", "in", itemIds));
        }
    }

    @Override
    protected List<Long> getZspmIds() {
        return Lists.newArrayList((Object[])new Long[]{ZspmConstant.ID_GHJH_ZPSM, ZspmConstant.ID_GHCBJ_ZPSM});
    }

    @Override
    protected boolean checkTaxLimit() {
        return true;
    }

    @Override
    protected boolean checkExistsAccount() {
        return true;
    }

    @Override
    protected QFilter getTaxDeductionFilter() {
        return new QFilter("taxcategory.number", "=", (Object)"028");
    }
}

