/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FieldTip;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.TzDialogValidHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TotfDetailAccountPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(TotfDetailAccountPlugin.class);
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String RULEID = "ruleid";
    private static final String ITEMNUMBER = "itemnumber";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    private static boolean ENABLE = true;
    private static final String TOTF_DETAIL_EDIT = "totf_detail_edit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LIST);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemnumber = (String)customParams.get(ITEMNUMBER);
        String entryname = (String)customParams.get("entryname");
        String adjustentryname = (String)customParams.get("adjustentryname");
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,titlename,adjustexplain";
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, adjustentryname, selectPrope);
        this.doSetAdjustList(customParams);
        DynamicObject[] genericObjects = this.loadDetailData(customParams, entryname);
        if (genericObjects.length == 0) {
            this.appendCard(itemnumber, adjustDetails, null);
            return;
        }
        Map<String, List<DynamicObject>> map = Arrays.stream(genericObjects).sorted(Comparator.comparing(d -> d.getLong("taxorg_id"))).collect(Collectors.groupingBy(s -> s.getString("taxorg_id") + "_" + s.getString("ruleid_id")));
        this.getModel().beginInit();
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
            DynamicObject rule = entry.getValue().get(0).getDynamicObject(RULEID);
            if (null != rule) {
                rule = BusinessDataServiceHelper.loadSingleFromCache((Object)rule.getLong("id"), (String)rule.getDataEntityType().getName());
                this.getModel().setValue(RULEID, (Object)rule.getLong("id"), rowIndex);
                DynamicObject taxorg = entry.getValue().get(0).getDynamicObject("org");
                this.getModel().setValue("taxorg", (Object)taxorg, rowIndex);
                this.getModel().setValue("titlename", (Object)rule.getString("name"), rowIndex);
                this.getModel().setValue("zspm", (Object)rule.getDynamicObject("collectionitem").getString("name"), rowIndex);
                this.getModel().setValue(ITEMNUMBER, (Object)itemnumber, rowIndex);
                this.getModel().setValue("amount", (Object)this.getAmount(taxorg, rule, entry.getValue()), rowIndex);
                this.getModel().setValue("adjustamount", (Object)this.getAdjustamount(taxorg, rule.getLong("id"), adjustDetails), rowIndex);
                this.getModel().setValue("totalamount", (Object)this.getTotalamount(taxorg, rule, adjustDetails, entry.getValue()), rowIndex);
                this.getModel().setValue("cardadjustexplain", (Object)this.getAdjustExplain(taxorg, rule.getLong("id"), adjustDetails), rowIndex);
            }
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"adjustamount"});
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"totalamount"});
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_CARD);
        this.appendCard(itemnumber, adjustDetails, genericObjects);
        this.clearEntry(ENTRYENTITY_LIST);
        Map.Entry first = (Map.Entry)map.entrySet().stream().findFirst().get();
        String taxorgid = ((String)first.getKey()).split("_")[0];
        String ruleid = ((String)first.getKey()).split("_")[1];
        this.setEntryentitylist(Long.valueOf(ruleid), entryname);
    }

    public void afterBindData(EventObject e) {
        Map customParams;
        String sbbBillStatus;
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY_CARD);
        if (rowCount > 0) {
            entryentitycard.selectCard(Integer.valueOf(0));
            entryentitycard.entryRowClick(Integer.valueOf(0));
        }
        if ("B".equals(sbbBillStatus = (String)(customParams = this.getView().getFormShowParameter().getCustomParams()).get("sbbBillStatus")) || "C".equals(sbbBillStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btncancel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        int row = evt.getRow();
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        if (entryentitycard.size() - 1 == row) {
            return;
        }
        this.clearEntry(ENTRYENTITY_LIST);
        Long ruleid = (Long)cardEntry.getModel().getValue(RULEID);
        if (ruleid != null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String entryname = (String)customParams.get("entryname");
            this.setEntryentitylist(ruleid, entryname);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean mustPositiveInteger;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            }
            if ("totalamount".equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("adjustamount", (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        } else if ("adjustsumamount".equals(name) && (mustPositiveInteger = (Boolean)this.getView().getFormShowParameter().getCustomParam("mustPositiveInt")) != null && mustPositiveInteger.booleanValue()) {
            String notPositiveIntMsg = (String)this.getView().getFormShowParameter().getCustomParam("notPositiveIntMsg");
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", "");
                tip.setSuccess(true);
                this.getView().showFieldTip(tip);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object orgid = customParams.get(ORGID);
            Object taxorg = customParams.get("taxorg");
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
            String adjustentryname = (String)customParams.get("adjustentryname");
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue("adjustsumamount");
            if (!CollectionUtils.isEmpty((Collection)entryentitycard)) {
                if (String.valueOf(adjustsumamount).replace("-", "").split("\\.")[0].length() > 13) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u679c\u503c\u4e3a\uff1a%s ,\u6574\u6570\u4f4d\u4e0d\u5141\u8bb8\u8d85\u8fc713\u4f4d\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"TotfDetailAccountPlugin_3", (String)"taxc-totf", (Object[])new Object[0]), adjustsumamount));
                    return;
                }
                if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5408\u8ba1\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570\u3002", (String)"TotfDetailAccountPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
                    return;
                }
                if (!TzDialogValidHelper.validTzsmMustInput((AbstractFormPlugin)this, (String)ENTRYENTITY_CARD, (String)"cardadjustexplain", (String)"totalamount", (String)"amount")) {
                    return;
                }
                this.addAdjustRecordAndWriteInfoDraft(entryentitycard);
                this.deleteDetail(customParams, adjustentryname);
                for (DynamicObject dynamicObject : entryentitycard) {
                    DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)adjustentryname));
                    object.set(RULEID, (Object)dynamicObject.getLong(RULEID));
                    object.set("entrytype", (Object)dynamicObject.getString("entrytype"));
                    object.set("titlename", (Object)dynamicObject.getString("titlename"));
                    object.set("itemname", (Object)dynamicObject.getString("zspm"));
                    object.set(ITEMNUMBER, (Object)dynamicObject.getString(ITEMNUMBER));
                    object.set("amount", (Object)dynamicObject.getBigDecimal("amount"));
                    object.set("adjustamount", (Object)dynamicObject.getBigDecimal("adjustamount"));
                    object.set("totalamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                    object.set("adjustexplain", (Object)dynamicObject.getString("cardadjustexplain"));
                    object.set("org", orgid);
                    object.set("taxorg", (Object)dynamicObject.getLong("taxorg_id"));
                    object.set(SKSSQQ, (Object)skssqq);
                    object.set(SKSSQZ, (Object)skssqz);
                    datas.add(object);
                }
            }
            SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            this.getView().returnDataToParent((Object)adjustsumamount);
            this.getView().close();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    private BigDecimal getTotalamount(DynamicObject taxorg, DynamicObject rule, DynamicObject[] adjustDetails, List<DynamicObject> genericObjects) {
        BigDecimal adjustamount = this.getAdjustamount(taxorg, rule.getLong("id"), adjustDetails);
        BigDecimal amount = this.getAmount(taxorg, rule, genericObjects);
        return amount.add(adjustamount);
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("adjustsumamount", (Object)adjustsumamount);
    }

    private String getAdjustExplain(DynamicObject taxorg, Long ruleid, DynamicObject[] adjustDetails) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getLong("taxorg") == (taxorg != null ? taxorg.getLong("id") : 0L) && s.getLong(RULEID) == ruleid.longValue()).findFirst();
        return optional.map(dynamicObject -> dynamicObject.getString("adjustexplain")).orElse(null);
    }

    private BigDecimal getAmount(DynamicObject taxorg, DynamicObject rule, List<DynamicObject> genericObjects) {
        BigDecimal sum = genericObjects.stream().filter(s -> s.getDynamicObject(RULEID).getLong("id") == rule.getLong("id") && s.getLong("taxorg_id") == (taxorg != null ? taxorg.getLong("id") : 0L)).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getAdjustamount(DynamicObject taxorg, Long ruleid, DynamicObject[] adjustDetails) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getLong("taxorg") == (taxorg != null ? taxorg.getLong("id") : 0L) && s.getLong(RULEID) == ruleid.longValue()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private void setEntryentitylist(Long ruleid, String entryname) {
        QFilter ruleFilter = new QFilter(RULEID, "=", (Object)ruleid);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String selectProperties = "taxaccountserialno,skssqq,skssqz,absolute,bizname,table,amountfield,datatype,datadirection,fetchamount,amount,filtercondition,ruleid";
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, ruleFilter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entryname, (String)selectProperties, (QFilter[])filters);
        this.getModel().beginInit();
        for (DynamicObject object : collection) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue("taxperiod", (Object)this.formatPeriod(object.getDate(SKSSQQ), object.getDate(SKSSQZ)), rowIndex);
            this.getModel().setValue("bizname", (Object)object.getString("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("amount"), rowIndex);
            this.getModel().setValue("datatype", object.get("datatype"), rowIndex);
            this.getModel().setValue("filtercondition", object.get("filtercondition"), rowIndex);
            this.getModel().setValue("filtercondition_tag", object.get("filtercondition"), rowIndex);
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("filtercondition");
            String tagPropName = largeTextEdit.getTagFieldKey();
            String largeText = (String)object.get("filtercondition");
            if (StringUtil.isEmpty((CharSequence)largeText)) {
                largeText = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"TotfDetailAccountPlugin_2", (String)"taxc-totf", (Object[])new Object[0]);
            }
            this.getModel().setValue(tagPropName, (Object)largeText, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_LIST);
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private void deleteDetail(Map<String, Object> customParams, String entityName) {
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        String itemnumber = (String)customParams.get(ITEMNUMBER);
        QFilter itemnumberFilter = new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, itemnumberFilter};
        DeleteServiceHelper.delete((String)entityName, (QFilter[])filters);
    }

    private void addAdjustRecordAndWriteInfoDraft(DynamicObjectCollection entryentitycard) {
        String manualAdjust = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"TotfDetailAccountPlugin_5", (String)"taxc-totf", (Object[])new Object[0]);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get(ORGID);
        Object taxorg = customParams.get("taxorg");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String adjustentryname = (String)customParams.get("adjustentryname");
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,titlename";
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, adjustentryname, selectPrope);
        Map<String, BigDecimal> adjustDetailMap = Arrays.asList(adjustDetails).stream().collect(Collectors.toMap(a -> this.getRuleCardKey((DynamicObject)a).concat(a.getString("taxorg")), a -> a.getBigDecimal("adjustamount"), (k, v) -> k));
        for (DynamicObject d : entryentitycard) {
            BigDecimal currentAdjustAmount;
            String key = this.getRuleCardKey(d);
            key = d.getDynamicObject("taxorg") != null ? key.concat(d.getDynamicObject("taxorg").getString("id")) : key.concat("0");
            BigDecimal preAdjustAmount = adjustDetailMap.get(key);
            if ((preAdjustAmount = preAdjustAmount == null ? BigDecimal.ZERO : preAdjustAmount).compareTo(currentAdjustAmount = d.getBigDecimal("adjustamount")) == 0) continue;
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)TOTF_DETAIL_EDIT);
            adjustObj.set("adjusttype", (Object)(manualAdjust.equals(d.getString("titlename")) ? 2 : 1));
            adjustObj.set(RULEID, (Object)d.getLong(RULEID));
            adjustObj.set("titlename", (Object)d.getString("titlename"));
            adjustObj.set("itemname", (Object)d.getString("titlename"));
            adjustObj.set(ITEMNUMBER, (Object)d.getString(ITEMNUMBER));
            adjustObj.set("preadjust", (Object)preAdjustAmount);
            adjustObj.set("postadjust", (Object)currentAdjustAmount);
            adjustObj.set("adjustexplain", d.get("cardadjustexplain"));
            adjustObj.set("org", orgid);
            adjustObj.set("taxorg", orgid);
            adjustObj.set(SKSSQQ, (Object)skssqq);
            adjustObj.set(SKSSQZ, (Object)skssqz);
            adjustObj.set("creator", (Object)RequestContext.get().getUserId());
            adjustObj.set("createtime", (Object)new Date());
            saveList.add(adjustObj);
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
    }

    private String getRuleCardKey(DynamicObject d) {
        return String.join((CharSequence)"", d.getString(RULEID), d.getString("titlename"));
    }

    private DynamicObject[] loadDetailData(Map<String, Object> customParams, String entryname) {
        String selectProperties = "org,taxorg,taxaccountserialno,skssqq,table,amountfield,datadirection,amount,fetchamount,filtercondition,ruleid,entrytype";
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        Long zspm = (Long)customParams.get("zspm");
        Long zszm = (Long)customParams.get("zszm");
        String taxaccountserialno = (String)orgid + zspm;
        if (zszm != null) {
            taxaccountserialno = taxaccountserialno + zszm;
        }
        QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "=", (Object)taxaccountserialno);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, taxaccountserialnoFilter};
        return BusinessDataServiceHelper.load((String)entryname, (String)selectProperties, (QFilter[])filters);
    }

    private void appendCard(String itemnumber, DynamicObject[] adjustDetails, DynamicObject[] genericObjects) {
        String titleName = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"TotfDetailAccountPlugin_1", (String)"taxc-totf", (Object[])new Object[0]);
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getString("titlename").equals(titleName)).findFirst();
        DynamicObject dynamicObject = optional.orElse(null);
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue("titlename", (Object)titleName, rowIndex);
        this.getModel().setValue(ITEMNUMBER, (Object)(itemnumber + "_"), rowIndex);
        this.getModel().setValue("amount", (Object)0, rowIndex);
        this.getModel().setValue("cardadjustexplain", (Object)(dynamicObject != null ? dynamicObject.getString("adjustexplain") : ""), rowIndex);
        this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("totalamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("adjustamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("adjustamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("sumamount", (Object)this.calcSumAmount(genericObjects));
        this.getModel().setValue("adjustsumamount", this.calcAdjustsumamount());
    }

    private Object calcAdjustsumamount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        return entryentitycard.stream().map(s -> s.getBigDecimal("amount").add(s.getBigDecimal("adjustamount"))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal calcSumAmount(DynamicObject[] genericObjects) {
        if (genericObjects == null || genericObjects.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = Arrays.stream(genericObjects).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private DynamicObject[] getAdjustData(Map<String, Object> customParams, String adjustentryname, String selectPrope) {
        QFilter[] filters = null;
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String itemnumber = (String)customParams.get(ITEMNUMBER);
        QFilter itemnumberFilter = new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_")));
        filters = new QFilter[]{orgFilter, startFilter, endFilter, itemnumberFilter};
        return BusinessDataServiceHelper.load((String)adjustentryname, (String)selectPrope, (QFilter[])filters);
    }

    private void doSetAdjustList(Map<String, Object> customParams) {
        String selectPrope = "adjusttype,itemname,taxorg,preadjust,postadjust,adjustexplain,creator,createtime";
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, TOTF_DETAIL_EDIT, selectPrope);
        if (adjustDetails == null || adjustDetails.length == 0) {
            return;
        }
        for (DynamicObject a : adjustDetails) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("adjusttype", a.get("adjusttype"), rowIndex);
            this.getModel().setValue("title", a.get("itemname"), rowIndex);
            this.getModel().setValue("orgname", a.get("taxorg"), rowIndex);
            this.getModel().setValue("preadjust", a.get("preadjust"), rowIndex);
            this.getModel().setValue("postadjust", a.get("postadjust"), rowIndex);
            this.getModel().setValue("adjustexplain", a.get("adjustexplain"), rowIndex);
            this.getModel().setValue("creator", a.get("creator_id"), rowIndex);
            this.getModel().setValue("createtime", a.get("createtime"), rowIndex);
        }
    }

    private String formatPeriod(Date start, Date end) {
        int endMonth;
        int year = DateUtils.getYearOfDate((Date)start);
        int startMonth = DateUtils.getMonthOfDate((Date)start);
        if (startMonth == (endMonth = DateUtils.getMonthOfDate((Date)end))) {
            return DateUtils.format((Date)start, (String)DateUtils.YYYYMM_CHINESE);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s-%3$s\u6708", (String)"AccountDetailFormPlugin_2", (String)"taxc-totf", (Object[])new Object[0]), year, startMonth, endMonth);
    }
}

