/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.totf.business.account.OtherIncomeService;
import kd.taxc.totf.business.sjjt.DraftService;
import kd.taxc.totf.common.enums.TaxTypeEnum;
import kd.taxc.totf.formplugin.account.CommonAccountEditPlugin;

public class WaterFundEditPlugin
extends CommonAccountEditPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultProperty();
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Long zspmId = Optional.ofNullable((DynamicObject)this.getModel().getValue("zspm")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        if (orgId == 0L || zspmId == 0L) {
            return;
        }
        this.getModel().setValue("declaration", (Object)"1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
        } else {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            DynamicObject sbbid = dynamicObject.getDynamicObject("sbbid");
            String sourcedata = dynamicObject.getString("sourcedata");
            boolean auto = !"hand".equals(sourcedata) && !"import".equals(sourcedata);
            this.getView().setVisible(Boolean.valueOf(auto), new String[]{"labelap"});
            if (sbbid == null || "A".equals(sbbid.getString("billstatus"))) {
                this.getView().setEnable(Boolean.valueOf(!auto), new String[]{"taxableitem"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"taxableitem"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"taxdeduction"});
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if ("taxableitem".equals(name)) {
            BigDecimal rate = Optional.ofNullable((BigDecimal)this.getModel().getValue("rate")).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal taxableitem = Optional.ofNullable((BigDecimal)changeData.getNewValue()).orElseGet(() -> BigDecimal.ZERO);
            this.getModel().setValue("amount", (Object)rate.multiply(taxableitem).setScale(2, 4));
        } else if ("amount".equals(name) || "taxdeduction".equals(name)) {
            String deductiontype = Optional.ofNullable((DynamicObject)this.getModel().getValue("taxdeduction")).map(s -> s.getString("deductiontype")).orElseGet(() -> "");
            String number = Optional.ofNullable((DynamicObject)this.getModel().getValue("taxdeduction")).map(s -> s.getString("number")).orElseGet(() -> "");
            if ("1".equals(deductiontype)) {
                this.getModel().setValue("deductionamount", this.getModel().getValue("amount"));
            } else if (Arrays.asList("6499042402", "3499032401").contains(number)) {
                BigDecimal amount = Optional.ofNullable((BigDecimal)this.getModel().getValue("amount")).orElseGet(() -> BigDecimal.ZERO);
                this.getModel().setValue("deductionamount", (Object)amount.multiply(new BigDecimal("0.1")).setScale(2, 4));
            } else {
                this.getModel().setValue("deductionamount", (Object)BigDecimal.ZERO);
            }
        } else if ("startdate".equals(name) || "enddate".equals(name)) {
            Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            Date start = (Date)this.getModel().getValue("startdate");
            Date end = (Date)this.getModel().getValue("enddate");
            BigDecimal flhdwse = DraftService.getFeeRate(orgId, TaxTypeEnum.TAXTYPE_024, start, end);
            this.getModel().setValue("rate", (Object)flhdwse);
        }
        BigDecimal amount = Optional.ofNullable((BigDecimal)this.getModel().getValue("amount")).orElseGet(() -> BigDecimal.ZERO);
        BigDecimal deductionamount = Optional.ofNullable((BigDecimal)this.getModel().getValue("deductionamount")).orElseGet(() -> BigDecimal.ZERO);
        this.getModel().setValue("bqybtse", (Object)amount.subtract(deductionamount));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && "lookdetail".equals(key = ((Donothing)args.getSource()).getOperateKey())) {
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            customParams.put("pkid", dynamicObject.getLong("id"));
            customParams.put("serialno", dynamicObject.getString("id"));
            customParams.put("orgId", dynamicObject.getDynamicObject("org").getString("id"));
            customParams.put("startdate", DateUtils.formatDate((Date)dynamicObject.getDate("startdate"), (Object[])new Object[0]));
            customParams.put("enddate", DateUtils.formatDate((Date)dynamicObject.getDate("enddate"), (Object[])new Object[0]));
            customParams.put("table_account", "totf_water_fund");
            customParams.put("table_detail", "totf_waterfund_detail");
            customParams.put("ruletype", "waterfund");
            customParams.put("sbbBillStatus", Optional.ofNullable(dynamicObject.getDynamicObject("sbbid")).map(s -> s.getString("billstatus")).orElseGet(() -> ""));
            customParams.put("sbbDeclareStatus", Optional.ofNullable(dynamicObject.getDynamicObject("sbbid")).map(s -> s.getString("declarestatus")).orElseGet(() -> ""));
            boolean perm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"totf", (String)"totf_water_fund", (String)"4715a0df000000ac");
            customParams.put("hasModifyPerm", perm);
            param.setCustomParams(customParams);
            param.setFormId(StringUtil.isBlank((CharSequence)dynamicObject.getString("prepaytype")) ? "totf_water_fund_orgs" : "totf_wafund_account_detai");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hyperlink"));
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("hyperlink".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    protected boolean checkTaxLimit() {
        return false;
    }

    @Override
    protected boolean checkExistsAccount() {
        return true;
    }

    @Override
    protected List<Long> getZspmIds() {
        return Lists.newArrayList((Object[])new Long[]{ZspmConstant.ID_DFSLJSJJ_ZPSM});
    }

    @Override
    protected QFilter getTaxDeductionFilter() {
        return new QFilter("taxcategory.number", "=", (Object)"030");
    }

    @Override
    protected void setDefaultProperty() {
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Long zspmId = Optional.ofNullable((DynamicObject)this.getModel().getValue("zspm")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        if (orgId == 0L || zspmId == 0L) {
            return;
        }
        Optional<DynamicObject> cardRowOpt = OtherIncomeService.getCardRow(orgId, zspmId);
        if (cardRowOpt.isPresent()) {
            Map<String, Date> last = OtherIncomeService.getStartOrEndByType(cardRowOpt.get().getString("taxperiod"), "last", new Date());
            this.getModel().setValue("payperiod", (Object)cardRowOpt.get().getString("taxperiod"));
            Date start = last.get("startdate");
            Date end = last.get("enddate");
            Date effectivestart = cardRowOpt.get().getDate("effectivestart");
            Date effectiveend = cardRowOpt.get().getDate("effectiveend");
            if (OtherIncomeService.isContainAll(effectivestart, effectiveend, start, end)) {
                this.getModel().setValue("startdate", (Object)start);
                this.getModel().setValue("enddate", (Object)end);
                BigDecimal flhdwse = DraftService.getFeeRate(orgId, TaxTypeEnum.TAXTYPE_024, start, end);
                this.getModel().setValue("rate", (Object)flhdwse);
            } else {
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
            }
        }
    }
}

