/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBatchImportPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.totf.business.account.OtherIncomeService;
import kd.taxc.totf.common.enums.TaxTypeEnum;

public class WaterFundImportPlugin
extends AbstractLicenseCheckBatchImportPlugin {
    public static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99");
    public static final String INT_REGEX = "^[1-9]\\d*|0$";
    public static final String DOUBLE_REGEX = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$";
    private static final String JZJMCODE_NUMBER = "6499042402";
    private static final String JZZXQY_NUMBER = "3499032401";

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        List orgNumberList = billdatas.stream().filter(d -> d.getData().getJSONObject("org") != null).map(d -> d.getData().getJSONObject("org").getString("number")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("number", "in", orgNumberList);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        List orgIdList = orgs.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        Map zerodeclareSljsjjMap = SystemParamUtil.getAppParameterBatch((String)"totf", (String)"zerodeclare_sljsjj", orgIdList);
        Map<String, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(d -> d.getString("number"), d -> d, (oldVal, newVal) -> oldVal));
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            String taxperiod;
            Optional<DynamicObject> cardRowOpt;
            Date enddate;
            Date startdate;
            DynamicObject taxofficeExist;
            DynamicObject org;
            JSONObject zspmJsonObject;
            JSONObject data;
            int index;
            block20: {
                String number;
                ImportBillData importBillData = iterator.next();
                index = importBillData.getStartIndex();
                data = importBillData.getData();
                JSONObject orgJsonObject = data.getJSONObject("org");
                JSONObject taxofficeJsonObject = data.getJSONObject("taxoffice");
                zspmJsonObject = data.getJSONObject("zspm");
                if (orgJsonObject == null || zspmJsonObject == null || taxofficeJsonObject == null || (org = orgMap.get(number = orgJsonObject.getString("number"))) == null) continue;
                if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                    logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s\u3002", (String)"WaterFundImportPlugin_0", (String)"taxc-totf", (Object[])new Object[0]), org.get("number")));
                    iterator.remove();
                }
                if ((taxofficeExist = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", taxofficeJsonObject.get((Object)"number"))})) == null) {
                    logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u627e\u4e0d\u5230\u7a0e\u52a1\u673a\u5173.\u7a0e\u52a1\u673a\u5173\u7f16\u7801=\u201c%s\u201d\u7684\u7a0e\u52a1\u673a\u5173\u3002", (String)"WaterFundImportPlugin_1", (String)"taxc-totf", (Object[])new Object[0]), taxofficeJsonObject.get((Object)"number")));
                    iterator.remove();
                    continue;
                }
                if (taxofficeExist.getString("enable").equals("0")) {
                    logger.fail().log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"WaterFundImportPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
                    iterator.remove();
                    continue;
                }
                Boolean zereDeclare = (Boolean)zerodeclareSljsjjMap.get(org.getLong("id"));
                if (zereDeclare != null && zereDeclare.booleanValue()) {
                    logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u5f15\u5165\u53f0\u8d26\u3002", (String)"WaterFundImportPlugin_3", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
                    iterator.remove();
                    continue;
                }
                if (!this.isNumeric(data.getString("taxableitem")) || this.largeMaxValue(data.getBigDecimal("taxableitem"))) {
                    logger.fail().log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u5e94\u7a0e\u9879\u201d\u6570\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u6570\u503c\u9650\u5236\u4e3a\u6574\u657013\u4f4d\uff0c\u5c0f\u65702\u4f4d\uff0c\u4e14\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"WaterFundImportPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
                    iterator.remove();
                    continue;
                }
                if (!"0089".equals(zspmJsonObject.getString("number"))) {
                    logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u627e\u4e0d\u5230\u5f81\u6536\u54c1\u76ee.\u7f16\u7801=\u201c%s\u201d\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"WaterFundImportPlugin_5", (String)"taxc-totf", (Object[])new Object[0]), zspmJsonObject.getString("number")));
                    iterator.remove();
                    continue;
                }
                startdate = null;
                enddate = null;
                try {
                    startdate = DateUtils.stringToDate2((String)data.getString("startdate"));
                    enddate = DateUtils.stringToDate2((String)data.getString("enddate"));
                    if (!startdate.equals(DateUtils.getFirstDateOfMonth((Date)startdate))) {
                        logger.fail().log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u5fc5\u987b\u4e3a\u6708\u521d\u3002", (String)"WaterFundImportPlugin_6", (String)"taxc-totf", (Object[])new Object[0]));
                        iterator.remove();
                        continue;
                    }
                    if (!enddate.equals(DateUtils.getLastDateOfMonth2((Date)enddate))) {
                        logger.fail().log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u4e3a\u6708\u672b\u3002", (String)"WaterFundImportPlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
                        iterator.remove();
                        continue;
                    }
                    if (startdate.after(enddate)) {
                        logger.fail().log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u201d\u5e94\u65e9\u4e8e\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u201d\u3002", (String)"WaterFundImportPlugin_8", (String)"taxc-totf", (Object[])new Object[0]));
                        iterator.remove();
                        continue;
                    }
                    cardRowOpt = OtherIncomeService.getCardRow(org.getLong("id"), ZspmConstant.ID_DFSLJSJJ_ZPSM, startdate, enddate);
                    if (!cardRowOpt.isPresent()) {
                        logger.fail().log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u671f\u4e0d\u5b58\u5728\u6709\u6548\u7684\u201c\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u201d\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterFundImportPlugin_9", (String)"taxc-totf", (Object[])new Object[0]));
                        iterator.remove();
                        continue;
                    }
                    taxperiod = cardRowOpt.get().getString("taxperiod");
                    String taxLimit = DateUtils.getTaxLimit((Date)startdate, (Date)enddate);
                    if (!taxLimit.equals(taxperiod)) {
                        logger.fail().log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f15\u5165\u7684\u5c5e\u671f\u548c\u7a0e\u79cd\u5361\u7247\u7f34\u7eb3\u5c5e\u671f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WaterFundImportPlugin_10", (String)"taxc-totf", (Object[])new Object[0]));
                        iterator.remove();
                    }
                    break block20;
                }
                catch (Exception e) {
                    logger.fail().log(Integer.valueOf(index), e.getMessage());
                    iterator.remove();
                }
                continue;
            }
            Optional<DynamicObject> optional = OtherIncomeService.queryExistsAccount("totf_water_fund", org.getLong("id"), taxofficeExist.getLong("id"), ZspmConstant.ID_DFSLJSJJ_ZPSM, startdate, enddate);
            if (optional.isPresent()) {
                logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u5f53\u524d\u7a0e\u6b3e\u6240\u5c5e\u671f\u5df2\u5b58\u5728\u671f\u95f4\u76f8\u4ea4\u7684\u6570\u636e \u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WaterFundImportPlugin_11", (String)"taxc-totf", (Object[])new Object[0]), optional.get().getString("billno")));
                iterator.remove();
                continue;
            }
            JSONObject taxdeduction = data.getJSONObject("taxdeduction");
            DynamicObject taxDeductionObj = null;
            if (taxdeduction != null) {
                String zspmNumber = zspmJsonObject.getString("number");
                DynamicObject zspm = QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"taxtype.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)zspmNumber)});
                String taxdeductionNumber = taxdeduction.getString("number");
                taxDeductionObj = QueryServiceHelper.queryOne((String)"tpo_taxdeduction", (String)"deductiontype,number,taxcategory.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxdeductionNumber)});
                if (taxDeductionObj == null || zspm == null || !taxDeductionObj.getString("taxcategory.number").equals(zspm.getString("taxtype.number"))) {
                    logger.fail().log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"WaterFundImportPlugin_12", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
                    iterator.remove();
                    continue;
                }
            }
            BigDecimal amountrate = cardRowOpt.get().getBigDecimal("amountrate");
            data.put("zsxm", (Object)TaxTypeEnum.TAXTYPE_024.getZsxm());
            data.put("rate", (Object)amountrate);
            BigDecimal amount = this.isNumeric(data.getString("taxableitem")) ? data.getBigDecimal("taxableitem").multiply(amountrate).setScale(2, 4) : BigDecimal.ZERO;
            data.put("amount", (Object)amount);
            BigDecimal deductionamount = BigDecimal.ZERO;
            if (taxDeductionObj != null && "1".equals(taxDeductionObj.getString("deductiontype"))) {
                deductionamount = data.getBigDecimal("amount");
            } else if (taxDeductionObj != null && Arrays.asList(JZZXQY_NUMBER, JZJMCODE_NUMBER).contains(taxDeductionObj.getString("number"))) {
                deductionamount = data.getBigDecimal("amount").multiply(new BigDecimal("0.1"));
            }
            data.put("deductionamount", (Object)deductionamount);
            data.put("bqybtse", (Object)amount.subtract(deductionamount));
            data.put("payperiod", (Object)taxperiod);
            data.put("declaration", (Object)"1");
            data.put("sourcedata", (Object)"import");
        }
        super.beforeSave(billdatas, logger);
    }

    public String getAppId() {
        return "totf";
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        return super.save(rowdatas, logger);
    }

    public boolean isNumeric(String value) {
        return value != null && value.matches(DOUBLE_REGEX) || this.isInteger(value);
    }

    public boolean isInteger(String value) {
        return value != null && value.matches(INT_REGEX);
    }

    public boolean largeMaxValue(BigDecimal amount) {
        return amount != null && amount.compareTo(MAX_VALUE) > 0;
    }
}

