/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.totf.business.account.AccountDetailAdjustServiceHelper;
import kd.taxc.totf.business.account.WaterFundServiceHelper;
import kd.taxc.totf.business.account.WhsjjsfDetailAdjustServiceHelper;
import kd.taxc.totf.business.account.WhsyjsfAccountServiceHelper;
import kd.taxc.totf.business.engine.WaterFundHelper;

public class WaterFundOrgListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String GROUP_FORMAT = "%s_%s_%s_%s";
    private static final String BTN_HYPERLINK = "hyperlink";

    public void registerListener(EventObject e) {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.updateEntryEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("source") != null && "whsyjsf".equals(customParams.get("source"))) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            entryGrid.setColumnProperty("taxableitem", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u5f81\u6536\u5165", (String)"WaterFundOrgListPlugin_0", (String)"taxc-totf", (Object[])new Object[0])));
        }
    }

    private void updateEntryEntity() {
        DynamicObject object;
        Map<String, List<DynamicObject>> groupedDetailDatas;
        DynamicObjectCollection dynamicObjects;
        Map<String, List<DynamicObject>> groupedAdjustDatas;
        DynamicObjectCollection adjustDatas;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serialno = (String)customParams.get("serialno");
        String startdate = (String)customParams.get("startdate");
        String enddate = (String)customParams.get("enddate");
        String tableaccount = (String)customParams.get("table_account");
        BigDecimal rate = BigDecimal.ZERO;
        if (tableaccount.equals("totf_water_fund")) {
            adjustDatas = AccountDetailAdjustServiceHelper.queryAdjustCollection(serialno, null, null, startdate, enddate);
            groupedAdjustDatas = adjustDatas.stream().collect(Collectors.groupingBy(this.groupFunction("org")));
            dynamicObjects = WaterFundServiceHelper.queryWaterFundDetails(serialno, null, null, startdate, enddate);
            groupedDetailDatas = dynamicObjects.stream().collect(Collectors.groupingBy(this.groupFunction("taxorg")));
            object = QueryServiceHelper.queryOne((String)"totf_water_fund", (String)"rate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(serialno))});
            if (object != null) {
                rate = object.getBigDecimal("rate");
            }
        } else {
            adjustDatas = WhsjjsfDetailAdjustServiceHelper.queryAdjustCollection(serialno, null, null, startdate, enddate);
            groupedAdjustDatas = adjustDatas.stream().collect(Collectors.groupingBy(this.groupFunction("org")));
            dynamicObjects = WhsyjsfAccountServiceHelper.queryAccountDetails(serialno, null, null, startdate, enddate);
            groupedDetailDatas = dynamicObjects.stream().collect(Collectors.groupingBy(this.groupFunction("taxorg")));
            object = QueryServiceHelper.queryOne((String)"totf_whsyjsf_account", (String)"rate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(serialno))});
            if (object != null) {
                rate = object.getBigDecimal("rate");
            }
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (groupedDetailDatas.size() > 0) {
            model.batchCreateNewEntryRow("entryentity", groupedDetailDatas.size());
            int rowIndex = 0;
            for (Map.Entry<String, List<DynamicObject>> entry : groupedDetailDatas.entrySet()) {
                String[] keys = entry.getKey().split("_");
                model.setValue("org", (Object)keys[0], rowIndex);
                model.setValue("mappingtype", (Object)entry.getValue().get(0).getString("mappingtype"), rowIndex);
                model.setValue("mappingid", (Object)keys[1], rowIndex);
                model.setValue("taxperiod", (Object)(keys[2] + "~" + keys[3]), rowIndex);
                BigDecimal taxableitem = WaterFundHelper.calcSumAmountByGroup(entry.getValue());
                BigDecimal adjustamount = BigDecimalUtil.sumDynamicObjectAmount(groupedAdjustDatas.get(entry.getKey()), (String)"adjustamount");
                BigDecimal totalTaxAbleitem = BigDecimalUtil.addObjects((Object[])new Object[]{taxableitem, adjustamount});
                model.setValue("taxableitem", (Object)totalTaxAbleitem, rowIndex);
                model.setValue("rate", (Object)rate, rowIndex);
                model.setValue("bqynse", (Object)BigDecimalUtil.multiplyObject((Object)totalTaxAbleitem, (Object)rate, (int)2, (int)4), rowIndex);
                ++rowIndex;
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Function<DynamicObject, String> groupFunction(String orgKey) {
        return d -> String.format(GROUP_FORMAT, d.getString(orgKey), d.getString("mappingid"), DateUtils.format((Date)d.getDate("skssqq"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId())), DateUtils.format((Date)d.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId())));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("taxableitem".equals(evt.getFieldName())) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            int rowIndex = evt.getRowIndex();
            FormShowParameter param = new FormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", rowIndex);
            params.put("orgId", org.getString("id"));
            DynamicObject mappingid = (DynamicObject)this.getModel().getValue("mappingid", rowIndex);
            params.put("mappingid", mappingid.getString("id"));
            param.setCustomParams(params);
            param.setFormId("totf_account_detail");
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_HYPERLINK));
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (BTN_HYPERLINK.equals(closedCallBackEvent.getActionId())) {
            this.updateEntryEntity();
        }
    }
}

