/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.RequestResult;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.account.OtherIncomeService;
import kd.taxc.totf.business.engine.impl.WaterSoilCompensationEngine;

public class WaterSoilAccountEditPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    public static final String ORG = "org";
    public static final String ID = "id";
    public static final String TAXOFFICE = "taxoffice";
    public static final String ZSPM = "zspm";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";
    public static final String ZSXM = "zsxm";
    public static final String ZSZM = "zszm";
    public static final String TAXDEDUCTION = "taxdeduction";

    public void afterCreateNewData(EventObject e) {
        if (!this.initData(new Date(), true)) {
            return;
        }
        this.execute();
        this.cal();
    }

    public void afterBindData(EventObject e) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"totf", (String)"totf_stbcbcf_account", (String)"4715a0df000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && (CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) || !CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) && !hasPermOrgResult.getHasPermOrgs().contains(RequestContext.get().getOrgId()))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "recalculate"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"fs_baseinfo"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "recalculate"});
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"recalculate", "tbmain", "contentpanel", "lookdetail"});
        BasedataEdit zspm = (BasedataEdit)this.getControl(ZSPM);
        BasedataEdit zszm = (BasedataEdit)this.getControl(ZSZM);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        zspm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        zszm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        String key;
        if (args.getSource() instanceof Donothing && "lookdetail".equals(key = ((Donothing)args.getSource()).getOperateKey())) {
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            if (this.checkMustInput(true)) {
                return;
            }
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            customParams.put("pkid", dynamicObject.getLong(ID));
            customParams.put(ZSPM, dynamicObject.getDynamicObject(ZSPM).getLong(ID));
            if (dynamicObject.getDynamicObject(ZSZM) != null) {
                customParams.put(ZSZM, dynamicObject.getDynamicObject(ZSZM).getLong(ID));
            }
            customParams.put("orgid", dynamicObject.getDynamicObject(ORG).getString(ID));
            customParams.put("skssqq", kd.bos.login.utils.DateUtils.formatDate((Date)dynamicObject.getDate(STARTDATE), (Object[])new Object[0]));
            customParams.put("skssqz", kd.bos.login.utils.DateUtils.formatDate((Date)dynamicObject.getDate(ENDDATE), (Object[])new Object[0]));
            customParams.put("entryname", "totf_stbcbcf_detail");
            customParams.put("adjustentryname", "totf_adjust_detail");
            customParams.put("itemnumber", this.getModel().getValue("billno"));
            customParams.put("sbbBillStatus", Optional.ofNullable(dynamicObject.getDynamicObject("sbbid")).map(s -> s.getString("billstatus")).orElseGet(() -> ""));
            customParams.put("sbbDeclareStatus", Optional.ofNullable(dynamicObject.getDynamicObject("sbbid")).map(s -> s.getString("declarestatus")).orElseGet(() -> ""));
            param.setCustomParams(customParams);
            param.setFormId("totf_detail_account");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "lookdetail"));
            this.getView().showForm(param);
        }
        if ("save".equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            this.check(args, ORG, ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, TAXOFFICE, ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u673a\u5173\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_8", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, ZSPM, ResManager.loadKDString((String)"\u201c\u5f81\u6536\u54c1\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, STARTDATE, ResManager.loadKDString((String)"\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_9", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, ENDDATE, ResManager.loadKDString((String)"\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_10", (String)"taxc-totf", (Object[])new Object[0]));
            this.checkDate(args, ResManager.loadKDString((String)"\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u201d\u5e94\u65e9\u4e8e\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u201d\u3002", (String)"WaterSoilAccountEditPlugin_11", (String)"taxc-totf", (Object[])new Object[0]));
            Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong(ID)).orElseGet(() -> 0L);
            String orgName = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getString("name")).orElseGet(() -> "");
            Long zspmId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ZSPM)).map(s -> s.getLong(ID)).orElseGet(() -> 0L);
            Date start = (Date)this.getModel().getValue(STARTDATE);
            Date end = (Date)this.getModel().getValue(ENDDATE);
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WaterSoilAccountEditPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Optional<DynamicObject> cardRowOpt2 = OtherIncomeService.getCardRow(orgId, zspmId, start, end);
            if (!cardRowOpt2.isPresent()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u76f8\u5173\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201c\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterSoilAccountEditPlugin_2", (String)"taxc-totf", (Object[])new Object[0]), orgName));
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String actionId = evt.getActionId();
        if ("lookdetail".equals(actionId) && (returnData = evt.getReturnData()) != null) {
            this.getModel().setValue("yjfjs", returnData);
            Object id = this.getModel().getValue(ID);
            if (id != null && (Long)id != 0L) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"totf_stbcbcf_account");
                object.set("yjfjs", returnData);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject org;
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        if (ZSPM.equals(evt.getProperty().getName())) {
            if (this.getModel().getValue(ORG) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            org = this.getModel().getDataEntity().getDynamicObject(ORG);
            List<DynamicObject> zspmEntity = this.getZspmEntity(org);
            if (CollectionUtils.isEmpty(zspmEntity)) {
                evt.setCancel(true);
                return;
            }
            List zspmIds = zspmEntity.stream().map(e -> e.getLong("collectrate.id")).collect(Collectors.toList());
            listFilterParameter.getQFilters().add(new QFilter(ID, "in", zspmIds));
        }
        if (ZSZM.equals(evt.getProperty().getName())) {
            if (this.getModel().getValue(ORG) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.getModel().getValue(ZSPM) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5f81\u6536\u54c1\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            org = this.getModel().getDataEntity().getDynamicObject(ORG);
            Long currZspmId = this.getModel().getDataEntity().getDynamicObject(ZSPM).getLong(ID);
            List<DynamicObject> zspmEntity = this.getZspmEntity(org);
            if (CollectionUtils.isEmpty(zspmEntity)) {
                return;
            }
            List zszmIds = zspmEntity.stream().filter(e -> currZspmId.equals(e.getLong("collectrate.id"))).map(e -> e.getLong("collectitem.id")).collect(Collectors.toList());
            if (zszmIds.size() == 0) {
                zszmIds.add(0L);
            }
            listFilterParameter.getQFilters().add(new QFilter(ID, "in", zszmIds));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("recalculate".equals(itemKey) && !this.checkMustInput(true)) {
            this.execute();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (ORG.equals(name)) {
            this.getModel().setValue(ZSPM, null);
            if (changeData.getNewValue() != null && this.initData(new Date(), true)) {
                this.clearFieldValue();
                this.execute();
            }
        }
        if (ZSPM.equals(name)) {
            this.getModel().setValue(ZSZM, null);
            if (changeData.getNewValue() != null && this.initData(new Date(), true)) {
                this.clearFieldValue();
                this.execute();
            }
        }
        if (ZSZM.equals(name) && this.initData(new Date(), true)) {
            this.clearFieldValue();
            this.execute();
        }
        if ((STARTDATE.equals(name) || ENDDATE.equals(name)) && (newValue = (Date)changeData.getNewValue()) != null && this.initData((Date)newValue, false)) {
            this.clearFieldValue();
            this.execute();
            this.cal();
        }
        if (TAXDEDUCTION.equals(name) && (newValue = changeData.getNewValue()) == null) {
            this.getModel().setValue("deductionamount", (Object)BigDecimal.ZERO);
        }
    }

    private void cal() {
        BigDecimal yjfjs = this.getModel().getDataEntity().getBigDecimal("yjfjs");
        BigDecimal yjfjsjme = this.getModel().getDataEntity().getBigDecimal("yjfjsjme");
        BigDecimal rate = this.getModel().getDataEntity().getBigDecimal("rate");
        BigDecimal quickdeduction = this.getModel().getDataEntity().getBigDecimal("quickdeduction");
        BigDecimal bqynsfe = yjfjs.subtract(yjfjsjme).multiply(rate).subtract(quickdeduction);
        this.getModel().setValue("bqynsfe", (Object)bqynsfe);
        BigDecimal deductionamount = this.getModel().getDataEntity().getBigDecimal("deductionamount");
        BigDecimal bqyjse = this.getModel().getDataEntity().getBigDecimal("bqyjse");
        BigDecimal bqybtfe = bqynsfe.subtract(deductionamount).subtract(bqyjse);
        this.getModel().setValue("bqybtfe", (Object)bqybtfe);
    }

    private void clearFieldValue() {
        this.getModel().setValue("yjfjsjme", (Object)BigDecimal.ZERO);
        this.getModel().setValue("quickdeduction", (Object)BigDecimal.ZERO);
        this.getModel().setValue(TAXDEDUCTION, null);
        this.getModel().setValue("deductionamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("bqyjse", (Object)BigDecimal.ZERO);
    }

    private boolean initData(Date newdate, boolean newData) {
        if (this.checkMustInput(false)) {
            return false;
        }
        DynamicObject zspmObj = this.zspmObj();
        if (zspmObj == null) {
            this.getModel().setValue("rate", (Object)BigDecimal.ZERO);
            this.getModel().setValue("taxperiod", (Object)"");
            return false;
        }
        this.getModel().setValue("rate", (Object)zspmObj.getBigDecimal("amountrate"));
        this.getModel().setValue("taxperiod", (Object)zspmObj.getString("taxperiod"));
        return !this.setDeclareDate(zspmObj, newdate, newData);
    }

    private DynamicObject zspmObj() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject(ORG);
        List<DynamicObject> zspmEntity = this.getZspmEntity(org);
        if (!CollectionUtils.isEmpty(zspmEntity)) {
            if (zspmEntity.size() == 1) {
                DynamicObject zspmObject = zspmEntity.get(0);
                this.getModel().setValue(ZSPM, (Object)zspmObject.getLong("collectrate.id"));
                DynamicObject collectitem = zspmObject.getDynamicObject("collectitem");
                if (collectitem != null) {
                    this.getModel().setValue(ZSZM, (Object)collectitem.getLong(ID));
                }
                return zspmObject;
            }
            if (this.getModel().getValue(ZSPM) != null) {
                Long zspmId = this.getModel().getDataEntity().getDynamicObject(ZSPM).getLong(ID);
                List collect = zspmEntity.stream().filter(s -> zspmId.equals(s.getLong("collectrate.id"))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    if (this.getModel().getValue(ZSZM) != null) {
                        Long zszmId = this.getModel().getDataEntity().getDynamicObject(ZSZM).getLong(ID);
                        Optional<DynamicObject> zspmOpt = collect.stream().filter(e -> zszmId.equals(e.getLong("collectitem.id"))).findFirst();
                        if (zspmOpt.isPresent()) {
                            return zspmOpt.get();
                        }
                    } else {
                        Optional<DynamicObject> zspmOpt = collect.stream().filter(e -> e.get("collectitem") == null).findFirst();
                        if (zspmOpt.isPresent()) {
                            return zspmOpt.get();
                        }
                    }
                }
            }
        }
        return null;
    }

    private List<DynamicObject> getZspmEntity(DynamicObject org) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(org.getLong(ID)));
        if (!taxResult.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)taxResult.getData()))) {
            this.getModel().setValue(ORG, null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WaterSoilAccountEditPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
            return new ArrayList<DynamicObject>();
        }
        TaxResult check = TaxcLicenseCheckDataServiceHelper.check((Long)org.getLong(ID), (String)"totf");
        if (!check.isSuccess() || ((Boolean)check.getData()).booleanValue()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%s\u3011\u8bb8\u53ef\u5c1a\u672a\u6fc0\u6d3b\uff0c\u8bf7\u5148\u8fdb\u884c\u8bb8\u53ef\u6fc0\u6d3b\u3002", (String)"WaterSoilAccountEditPlugin_6", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
            return new ArrayList<DynamicObject>();
        }
        DynamicObject taxMain = (DynamicObject)((List)taxResult.getData()).get(0);
        this.getModel().setValue(TAXOFFICE, (Object)taxMain.getDynamicObject(TAXOFFICE).getLong(ID));
        Optional<DynamicObject> cardObj = taxMain.getDynamicObjectCollection("categoryentryentity").stream().filter(s -> "qtsf".equals(s.getString("taxtype"))).filter(s -> "1".equals(s.getString("enable"))).findFirst();
        if (!cardObj.isPresent()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u672a\u542f\u7528\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201c\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterSoilAccountEditPlugin_1", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
            return new ArrayList<DynamicObject>();
        }
        List<Long> zspmId = Arrays.asList(ZspmConstant.ID_STBCBCF_ZPSM, ZspmConstant.ID_STBCBCF_JSQSR_ZPSM, ZspmConstant.ID_STBCBCF_KCQSR_ZPSM, ZspmConstant.ID_STBCBCF_QTSR_ZPSM);
        DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
        if (CollectionUtils.isEmpty((Collection)qtsfentity)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u76f8\u5173\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201c\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterSoilAccountEditPlugin_2", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
            return new ArrayList<DynamicObject>();
        }
        return qtsfentity.stream().filter(e -> zspmId.contains(e.getLong("collectrate.id"))).collect(Collectors.toList());
    }

    private void execute() {
        if (this.getModel().getValue(ORG) == null) {
            return;
        }
        EngineModel engineModel = new EngineModel(this.getModel().getDataEntity().getDynamicObject(ORG).getString(ID), DateUtils.format((Date)this.getModel().getDataEntity().getDate(STARTDATE)), DateUtils.format((Date)this.getModel().getDataEntity().getDate(ENDDATE)));
        engineModel.getCustom().put(ZSPM, this.getModel().getDataEntity().getDynamicObject(ZSPM).getLong(ID));
        if (this.getModel().getDataEntity().getDynamicObject(ZSZM) != null) {
            engineModel.getCustom().put(ZSZM, this.getModel().getDataEntity().getDynamicObject(ZSZM).getLong(ID));
        }
        engineModel.getCustom().put("itemnumber", this.getModel().getValue("billno"));
        RequestResult result = WaterSoilCompensationEngine.execute(engineModel);
        Map data = (Map)result.getData();
        Boolean isrule = (Boolean)data.get("isrule");
        if (isrule.booleanValue()) {
            this.getModel().setValue("sourcedata", (Object)"1");
            this.getModel().setValue("isrulecollection", (Object)"1");
        } else {
            this.getModel().setValue("sourcedata", (Object)"0");
            this.getModel().setValue("isrulecollection", (Object)"0");
        }
        this.getModel().setValue("yjfjs", data.get("amount"));
        this.getView().updateView();
    }

    public void check(BeforeDoOperationEventArgs args, String field, String msg) {
        Object org;
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        if (properties.containsKey((Object)field) && (org = this.getModel().getValue(field)) == null) {
            args.setCancel(true);
            throw new KDBizException(msg);
        }
    }

    private void checkDate(BeforeDoOperationEventArgs args, String msg) {
        Date start = (Date)this.getModel().getValue(STARTDATE);
        Date end = (Date)this.getModel().getValue(ENDDATE);
        if (start == null || end == null) {
            return;
        }
        if (start.after(end)) {
            args.setCancel(true);
            throw new KDBizException(msg);
        }
    }

    private boolean checkMustInput(boolean checkDate) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"WaterSoilAccountEditPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
            return true;
        }
        if (checkDate) {
            DynamicObject zspm = this.getModel().getDataEntity().getDynamicObject(ZSPM);
            if (zspm == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5f81\u6536\u54c1\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
                return true;
            }
            Date startdate = this.getModel().getDataEntity().getDate(STARTDATE);
            Date enddate = this.getModel().getDataEntity().getDate(ENDDATE);
            if (startdate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_9", (String)"taxc-totf", (Object[])new Object[0]));
                return true;
            }
            if (enddate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterSoilAccountEditPlugin_10", (String)"taxc-totf", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean setDeclareDate(DynamicObject zspmObj, Date declareDate, boolean addDate) {
        Date endDate;
        Date startDate;
        Date effectivestart = zspmObj.getDate("effectivestart");
        Date effectiveend = zspmObj.getDate("effectiveend");
        String taxperiod = zspmObj.getString("taxperiod");
        if ("season".equals(taxperiod)) {
            Date date = addDate ? DateUtils.addMonth((Date)declareDate, (int)-3) : declareDate;
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            endDate = DateUtils.getLastDateOfSeason((Date)startDate);
        } else if ("halfyear".equals(taxperiod)) {
            Date date = addDate ? DateUtils.addMonth((Date)declareDate, (int)-6) : declareDate;
            startDate = DateUtils.getFirstDateOfHalfYear((Date)date);
            endDate = DateUtils.getLastDateOfHalfYear((Date)startDate);
        } else if ("year".equals(taxperiod)) {
            Date date = addDate ? DateUtils.addMonth((Date)declareDate, (int)-1) : declareDate;
            startDate = DateUtils.getFirstDateOfYear((Date)date);
            endDate = DateUtils.getLastDateOfYear((Date)startDate);
        } else {
            startDate = declareDate;
            endDate = declareDate;
        }
        startDate = DateUtils.trunc((Date)startDate);
        endDate = DateUtils.trunc((Date)endDate);
        if (effectivestart.compareTo(startDate) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u4e0d\u5b58\u5728\u751f\u6548\u7684\u7533\u62a5\u9879\u4fe1\u606f \uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterSoilAccountEditPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
            return true;
        }
        if (effectiveend != null && (startDate.compareTo(effectiveend) > 0 || endDate.compareTo(effectiveend) > 0)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u4e0d\u5b58\u5728\u751f\u6548\u7684\u7533\u62a5\u9879\u4fe1\u606f \uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterSoilAccountEditPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
            return true;
        }
        this.getModel().beginInit();
        this.getModel().setValue(STARTDATE, (Object)startDate);
        this.getModel().setValue(ENDDATE, (Object)endDate);
        this.getModel().setValue("taxperiod", (Object)taxperiod);
        this.getModel().endInit();
        this.getView().updateView();
        return false;
    }
}

