/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.DevprotalBizAppUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.declare.WhsyjsfAccountService;
import kd.taxc.totf.business.engine.impl.WhsyjsfAutoCollectEngine;
import org.apache.commons.lang.StringUtils;

public class WhsyjsfAccountAutoCollectFormPlugin
extends AbstractLicenseCheckFormPlugin
implements BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String ORG_ID = "orgid";
    private static final String COLLECTIONDATE = "collectiondate";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTITY_ORGNAME = "orgname";
    private static final String ENTITY_PAYPERIOD = "payperiod";
    private static final String ENTITY_STARTDATE = "startdate";
    private static final String ENTITY_ENDDATE = "enddate";
    private static final String ENTITY_RATE = "rate";
    private static final String ENTITY_ISGENERATED = "isgenerated";
    private static final String STATUS_ISGENERATED = "true";
    private static final String BTN_SAVE = "save";
    private static final String BTN_YES = "Yes";
    private static final String APP_ID = "totf";
    private static final String TOTF_WHSYJSF_AUTOCOLLECT = "totf_whsyjsf_autocollect";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ORG, COLLECTIONDATE, BTN_SAVE});
        BasedataEdit orgF7 = (BasedataEdit)this.getControl(ORG);
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String org = (String)customParams.get(ORG_ID);
        if (StringUtils.isNotEmpty((String)org)) {
            HasPermOrgResult permOrgs = PermissionUtils.getAllPermOrgs((String)APP_ID, (String)TOTF_WHSYJSF_AUTOCOLLECT, (String)"47150e89000000ac");
            if (permOrgs.hasAllOrgPerm() || permOrgs.getHasPermOrgs().contains(Long.valueOf(org))) {
                this.getModel().setValue(ORG, (Object)Long.valueOf(org));
            } else if (permOrgs.getHasPermOrgs().stream().findFirst().isPresent()) {
                this.getModel().setValue(ORG, permOrgs.getHasPermOrgs().get(0));
            } else {
                this.getModel().setValue(ORG, null);
            }
            this.getModel().setValue(COLLECTIONDATE, (Object)new Date());
            this.updateFormEntity();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ORG.equals(name)) {
            HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((String)APP_ID, (String)"totf_whsyjsf_account", (String)"47150e89000000ac");
            evt.addCustomQFilter(new QFilter("id", "in", TaxcMainDataServiceHelper.queryTaxcMainOrgIds().getData()));
            if (!permOrgResult.hasAllOrgPerm()) {
                QFilter qFilter = new QFilter("id", "in", (Object)permOrgResult.getHasPermOrgs());
                evt.addCustomQFilter(qFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (ORG.equals(name) || COLLECTIONDATE.equals(name)) {
            this.updateFormEntity();
        }
        super.propertyChanged(args);
    }

    private void updateFormEntity() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Date collectDate = (Date)this.getModel().getValue(COLLECTIONDATE);
        if (org == null || collectDate == null) {
            return;
        }
        Map<String, Object> map = WhsyjsfAccountService.getData(((DynamicObject)this.getModel().getValue(ORG)).getString("name"), org.getLong("id"), collectDate);
        if (EmptyCheckUtils.isNotEmpty(map)) {
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue(ENTITY_ORGNAME, map.get(ORG), index);
            this.getModel().setValue(ENTITY_PAYPERIOD, map.get("taxlimit"), index);
            this.getModel().setValue(ENTITY_STARTDATE, map.get(ENTITY_STARTDATE), index);
            this.getModel().setValue(ENTITY_ENDDATE, map.get(ENTITY_ENDDATE), index);
            this.getModel().setValue(ENTITY_RATE, map.get(ENTITY_RATE), index);
            this.getModel().setValue(ENTITY_ISGENERATED, map.get(ENTITY_ISGENERATED), index);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (BTN_SAVE.equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WhsyjsfAccountAutoCollectFormPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            if (STATUS_ISGENERATED.equals(this.getModel().getValue(ENTITY_ISGENERATED))) {
                this.showConfirmTips();
            } else {
                this.generateAccount();
                this.getView().close();
            }
        }
    }

    private void showConfirmTips() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_SAVE, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WhsyjsfAccountAutoCollectFormPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"WhsyjsfAccountAutoCollectFormPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011-\u3010%3$s\u3011\u53f0\u8d26\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8981\u8986\u76d6\uff1f", (String)"WhsyjsfAccountAutoCollectFormPlugin_5", (String)"taxc-totf", (Object[])new Object[0]), this.getModel().getValue(ENTITY_ORGNAME), DateUtils.format((Date)((Date)this.getModel().getValue(ENTITY_STARTDATE)), (String)"yyyy-MM-dd"), DateUtils.format((Date)((Date)this.getModel().getValue(ENTITY_ENDDATE)), (String)"yyyy-MM-dd"));
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (BTN_SAVE.equals(callBackId) && BTN_YES.equals(event.getResultValue())) {
            this.generateAccount();
            this.getView().close();
        }
    }

    private void generateAccount() {
        if (this.getModel().getEntryEntity(ENTRYENTITY).size() <= 0) {
            return;
        }
        String msg = "";
        DynamicObject entity = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(0);
        String orgid = ((DynamicObject)this.getModel().getValue(ORG)).getString("id");
        Date startdate = entity.getDate(ENTITY_STARTDATE);
        Date enddate = entity.getDate(ENTITY_ENDDATE);
        EngineModel engineModel = new EngineModel(orgid, DateUtils.format((Date)startdate), DateUtils.format((Date)enddate));
        engineModel.getCustom().put("entity", entity);
        boolean isexecute = WhsyjsfAutoCollectEngine.execute(engineModel);
        if (!isexecute) {
            msg = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u7684\u53d6\u6570\u89c4\u5219\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201d\u4e2d\u914d\u7f6e\u3002", (String)"WhsyjsfAccountAutoCollectFormPlugin_6", (String)"taxc-totf", (Object[])new Object[0]);
            this.getView().getParentView().showTipNotification(msg);
        } else {
            msg = ResManager.loadKDString((String)"\u53f0\u8d26\u751f\u6210\u6210\u529f\u3002", (String)"WhsyjsfAccountAutoCollectFormPlugin_0", (String)"taxc-totf", (Object[])new Object[0]);
            this.getView().getParentView().showSuccessNotification(msg);
        }
        String operateName = ResManager.loadKDString((String)"\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39\u53f0\u8d26\u81ea\u52a8\u53d6\u6570", (String)"WhsyjsfAccountAutoCollectFormPlugin_2", (String)"taxc-totf", (Object[])new Object[0]);
        OperatorDialogUtils.operateDialogByAppid((String)DevprotalBizAppUtil.getTaxcAppByNumber((String)APP_ID), (String)this.getView().getFormShowParameter().getFormId(), (String)operateName, (String)msg);
    }
}

