/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WhsyjsfAccountListPlugin
extends AbstractListPlugin {
    private static final String TOTF_WHSYJSF_AUTOCOLLECT = "totf_whsyjsf_autocollect";
    private static final String TOTF_WHSYJSF_ACCOUNT = "totf_whsyjsf_account";
    private static final String TOTF_ACCOUNT_ORGLIST = "totf_water_fund_orgs";
    private static final String ORG_ID = "orgId";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String SERIALNO = "serialno";
    private static final String BTN_AUTOCOLLECT = "autocollect";
    private static final String BTN_HYPERLINK = "hyperlink";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BTN_AUTOCOLLECT});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            List defaultValues = filterColumn.getDefaultValues();
            if (null == defaultValues || defaultValues.isEmpty()) continue;
            String orgid = (String)defaultValues.get(0);
            this.getPageCache().put("defaultorgid", orgid);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TOTF_WHSYJSF_ACCOUNT, (String)"id,org,startdate,enddate,sbbid.billstatus,sbbid.declarestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("pkid", pkid);
        customParams.put(SERIALNO, dynamicObject.getString("id"));
        customParams.put(ORG_ID, dynamicObject.getString("org"));
        customParams.put(STARTDATE, dynamicObject.getString(STARTDATE));
        customParams.put(ENDDATE, dynamicObject.getString(ENDDATE));
        customParams.put("table_account", TOTF_WHSYJSF_ACCOUNT);
        customParams.put("table_detail", "totf_whsyjsf_detail");
        customParams.put("ruletype", "waterfund");
        customParams.put("source", "whsyjsf");
        customParams.put("sbbBillStatus", dynamicObject.getString("sbbid.billstatus"));
        customParams.put("sbbDeclareStatus", dynamicObject.getString("sbbid.declarestatus"));
        param.setCustomParams(customParams);
        param.setFormId(TOTF_ACCOUNT_ORGLIST);
        param.getOpenStyle().setShowType(ShowType.NonModal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_HYPERLINK));
        this.getView().showForm(param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String itemKey = args.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Optional<Object> orgid = this.getControlFilters().getFilter("org.id").stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.toString())).findFirst();
        if (orgid.isPresent()) {
            customParams.put("orgid", orgid.get());
        } else {
            customParams.put("orgid", this.getPageCache().get("defaultorgid"));
        }
        if (BTN_AUTOCOLLECT.equals(itemKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(TOTF_WHSYJSF_AUTOCOLLECT);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_AUTOCOLLECT));
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        } else if ("managejmcode".equals(itemKey)) {
            QFilter filter = new QFilter("taxcategory.number", "=", (Object)"026");
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tpo_taxdeduction", (boolean)false, (int)2);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "managejmcode"));
            parameter.getListFilterParameter().setFilter(filter);
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("deldeductioncode".equals(itemKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deldeductioncode", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WhsyjsfAccountListPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"WhsyjsfAccountListPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6240\u9009\u6570\u636e\u7684\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u53ca\u5176\u51cf\u514d\u7a0e\u989d\uff1f", (String)"WhsyjsfAccountListPlugin_2", (String)"taxc-totf", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("deldeductioncode".equals(callBackId)) {
            this.deleteJmCode();
        }
    }

    private void deleteJmCode() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject[] selectRows = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_WHSYJSF_ACCOUNT));
        List<DynamicObject> taxDeductionList = Arrays.stream(selectRows).filter(e -> e.getDynamicObject("taxdeduction") != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(taxDeductionList)) {
            for (DynamicObject taxDeduction : taxDeductionList) {
                taxDeduction.set("deductionamount", (Object)BigDecimal.ZERO);
                taxDeduction.set("bqybtse", (Object)taxDeduction.getBigDecimal("amount"));
                taxDeduction.set("taxdeduction", (Object)0L);
            }
            SaveServiceHelper.save((DynamicObject[])taxDeductionList.toArray(new DynamicObject[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"WhsyjsfAccountListPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
            billList.refresh();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u6ca1\u6709\u53ef\u5220\u9664\u7684\u51cf\u514d\u4ee3\u7801\u3002", (String)"WhsyjsfAccountListPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        String actionId = closedCallBackEvent.getActionId();
        if (BTN_AUTOCOLLECT.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (BTN_HYPERLINK.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if ("managejmcode".equals(actionId) && EmptyCheckUtils.isNotEmpty((Object)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            this.updateJmCode(returnData);
        }
    }

    private void updateJmCode(ListSelectedRowCollection returnData) {
        DynamicObject[] dynamicObjects;
        ListSelectedRow row = returnData.get(0);
        Long jmcodeId = (Long)row.getPrimaryKeyValue();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (DynamicObject whsyjsfaccount : dynamicObjects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_WHSYJSF_ACCOUNT))) {
            whsyjsfaccount.set("taxdeduction", (Object)jmcodeId);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u6210\u529f\u3002", (String)"WhsyjsfAccountListPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
        billList.refresh();
    }
}

