/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.account;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.account.OtherIncomeService;
import kd.taxc.totf.formplugin.account.CommonAccountEditPlugin;

public class jsxzsyxsfAccountEditPlugin
extends CommonAccountEditPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultProperty();
    }

    @Override
    protected void setDefaultProperty() {
        Optional<DynamicObject> cardRowOpt;
        String entityName = this.getModel().getDataEntityType().getName();
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Long taxofficed = Optional.ofNullable((DynamicObject)this.getModel().getValue("taxoffice")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Long zspmId = Optional.ofNullable((DynamicObject)this.getModel().getValue("zspm")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        if (orgId == 0L || taxofficed == 0L || zspmId == 0L) {
            return;
        }
        Optional<DynamicObject> optional = OtherIncomeService.queryExistsAccount(entityName, orgId, taxofficed, zspmId);
        Map<Object, Object> last = new HashMap(16);
        if (optional.isPresent()) {
            DynamicObject object = optional.get();
            String taxLimit = DateUtils.getTaxLimit((Date)object.getDate("startdate"), (Date)object.getDate("enddate"));
            last = OtherIncomeService.getStartOrEndByType(taxLimit, "next", object.getDate("startdate"));
            cardRowOpt = OtherIncomeService.getCardRow(orgId, zspmId, (Date)last.get("startdate"), (Date)last.get("enddate"));
        } else {
            cardRowOpt = OtherIncomeService.getCardRow(orgId, zspmId);
            if (cardRowOpt.isPresent()) {
                last = OtherIncomeService.getStartOrEndByType(cardRowOpt.get().getString("taxperiod"), "last", new Date());
                cardRowOpt = OtherIncomeService.getCardRow(orgId, zspmId, (Date)last.get("startdate"), (Date)last.get("enddate"));
            }
        }
        if (cardRowOpt.isPresent()) {
            this.getModel().setValue("payperiod", (Object)cardRowOpt.get().getString("taxperiod"));
            this.getModel().setValue("zszm", (Object)cardRowOpt.get().getLong("collectitem_id"));
            Date start = (Date)last.get("startdate");
            Date end = (Date)last.get("enddate");
            Date effectivestart = cardRowOpt.get().getDate("effectivestart");
            Date effectiveend = cardRowOpt.get().getDate("effectiveend");
            if (OtherIncomeService.isContainAll(effectivestart, effectiveend, start, end)) {
                this.getModel().setValue("startdate", (Object)start);
                this.getModel().setValue("enddate", (Object)end);
            } else {
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
            }
        }
    }

    @Override
    protected List<Long> getZspmIds() {
        return Lists.newArrayList((Object[])new Long[]{ZspmConstant.ID_CZLJCLF_ZPSM});
    }

    @Override
    protected boolean checkTaxLimit() {
        return true;
    }

    @Override
    protected boolean checkExistsAccount() {
        return true;
    }

    @Override
    protected QFilter getTaxDeductionFilter() {
        return new QFilter("taxcategory.number", "=", (Object)"031");
    }
}

