/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.declare;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.totf.common.utils.WhsyjsfUtils;

public class CjrjybzjEditMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(CjrjybzjEditMultiPlugin.class);
    private static String ID = "id";
    private static String VERSION = "version";
    private static String ORG = "org";
    private static String TAXORG = "taxorg";
    private static String START_DATE = "startdate";
    private static String ENDDATE = "enddate";
    private static final String CLOSE_KEY = "close";
    private static final String AUDIT_KEY = "audit";
    private static final String DECLAREDATE = "declaredate";
    private static final String TAXOFFICE = "taxoffice";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long orgid;
        this.getView().setVisible(Boolean.FALSE, new String[]{"recalc", AUDIT_KEY});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramOrg = (String)customParams.get("orgid");
        long org = StringUtil.isNotBlank((CharSequence)paramOrg) ? Long.parseLong(paramOrg) : RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long l = orgid = this.isDefaultOrg() ? OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col) : this.getCustomOrg(customParams);
        if (orgid != null) {
            this.getModel().setValue(ORG, (Object)orgid);
            TaxResult result = TaxcMainDataServiceHelper.queryTaxOfficeIdByOrgId(Collections.singletonList(orgid));
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                this.getModel().setValue(TAXOFFICE, ((List)result.getData()).get(0));
                this.getPageCache().put(TAXOFFICE, String.valueOf(((List)result.getData()).get(0)));
            }
            if (customParams.get("entryid") != null) {
                if (this.checkOrg(customParams.get("orgid").toString())) {
                    this.getModel().setValue(ORG, null);
                    this.getModel().setValue(TAXOFFICE, null);
                    return;
                }
                QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(customParams.get("entryid").toString()));
                DynamicObject declareMain = QueryServiceHelper.queryOne((String)"totf_jybz_declare_query", (String)"id,entryentity.declaredate,taxauthority", (QFilter[])new QFilter[]{idFilter});
                this.getModel().setValue(DECLAREDATE, declareMain.get("entryentity.declaredate"));
                this.getModel().setValue(TAXOFFICE, declareMain.get("taxauthority"));
                this.getPageCache().put(TAXOFFICE, declareMain.get("taxauthority").toString());
            } else if (customParams.get("billno") != null) {
                if (this.checkOrg(customParams.get("orgid").toString())) {
                    this.getModel().setValue(ORG, null);
                    this.getModel().setValue(TAXOFFICE, null);
                    return;
                }
                QFilter idFilter = new QFilter("billno", "=", (Object)customParams.get("billno").toString());
                DynamicObject declareMain = QueryServiceHelper.queryOne((String)"totf_jybz_declare_query", (String)"id,entryentity.declaredate,taxauthority", (QFilter[])new QFilter[]{idFilter});
                this.getModel().setValue(DECLAREDATE, declareMain.get("entryentity.declaredate"));
                this.getModel().setValue(TAXOFFICE, declareMain.get("taxauthority"));
                this.getPageCache().put(TAXOFFICE, declareMain.get("taxauthority").toString());
            } else {
                String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
                TaxAppEnum enumInstanceByAppid = TaxAppEnum.getEnumInstanceByAppid((String)appid);
                boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(orgid), (String)appid, (String)(enumInstanceByAppid != null ? enumInstanceByAppid.getCategoryCode() : null));
                if (checkResult) {
                    this.getModel().setValue("org", null);
                    this.getModel().setValue(TAXOFFICE, null);
                    return;
                }
                if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgid).getData()).booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CjrjybzjEditMultiPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                    this.getModel().setValue(ORG, null);
                    this.getModel().setValue(TAXOFFICE, null);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "submit", AUDIT_KEY});
                    return;
                }
                this.getModel().setValue(DECLAREDATE, (Object)new Date());
                Date declaredate = (Date)this.getModel().getValue(DECLAREDATE);
                Date date = DateUtils.getFirstDateOfMonth((Date)declaredate);
                Date startdate = null;
                Date enddate = null;
                String taxlimit = CjrjybzjEditMultiPlugin.getTaxlimit(orgid, date);
                if (null == taxlimit) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"CjrjybzjEditMultiPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
                    this.getModel().setValue(DECLAREDATE, null);
                    this.getPageCache().put(DECLAREDATE, null);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "submit", AUDIT_KEY});
                    return;
                }
                Map<String, Date> map = WhsyjsfUtils.getStartAndEndDate(date, taxlimit);
                if ("year".equals(taxlimit)) {
                    map = new HashMap<String, Date>();
                    map.put("startdate", DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)date, (int)-1)));
                    map.put("enddate", DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)date, (int)-1)));
                }
                if (map.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"CjrjybzjEditMultiPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
                    this.getModel().setValue(DECLAREDATE, null);
                    this.getPageCache().put(DECLAREDATE, null);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "submit", AUDIT_KEY});
                    return;
                }
                startdate = map.get("startdate");
                enddate = map.get("enddate");
                if (startdate == null || enddate == null) {
                    return;
                }
                this.getPageCache().put(DECLAREDATE, DateUtils.format((Date)declaredate));
                this.getPageCache().put("skssqq", DateUtils.format((Date)startdate));
                this.getPageCache().put("skssqz", DateUtils.format((Date)enddate));
                this.getDraftNumber(DateUtils.format((Date)startdate), DateUtils.format((Date)enddate));
            }
            super.afterCreateNewData(e);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"CjrjybzjEditMultiPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
    }

    protected boolean isDefaultOrg() {
        return false;
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSCOO1.getModel();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    public void init() {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0 || changeData[0].getNewValue() == null) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
        Date declaredate = (Date)this.getModel().getValue(DECLAREDATE);
        if (e.getProperty().getName().equals("org") && org != null) {
            TaxAppEnum enumInstanceByAppid = TaxAppEnum.getEnumInstanceByAppid((String)appid);
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)org.get("id").toString(), (String)appid, (String)(enumInstanceByAppid != null ? enumInstanceByAppid.getCategoryCode() : null));
            if (checkResult) {
                this.getModel().setValue("org", changeData[0].getOldValue());
                return;
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxOfficeIdByOrgId(Collections.singletonList(org.getLong("id")));
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                this.getModel().setValue(TAXOFFICE, ((List)result.getData()).get(0));
                this.getPageCache().put(TAXOFFICE, String.valueOf(((List)result.getData()).get(0)));
            }
            this.getPageCache().put("orgid", org.getString(ID));
            DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
            this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString(ID));
        }
        if (org == null || taxoffice == null || declaredate == null) {
            return;
        }
        Date date = DateUtils.getFirstDateOfMonth((Date)declaredate);
        Date startdate = null;
        Date enddate = null;
        String taxlimit = CjrjybzjEditMultiPlugin.getTaxlimit(org.getLong("id"), date);
        if (null == taxlimit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"CjrjybzjEditMultiPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
            this.getModel().setValue(DECLAREDATE, null);
            this.getPageCache().put(DECLAREDATE, null);
            return;
        }
        Map<String, Date> map = WhsyjsfUtils.getStartAndEndDate(date, taxlimit);
        if ("year".equals(taxlimit)) {
            map = new HashMap<String, Date>();
            map.put("startdate", DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)date, (int)-1)));
            map.put("enddate", DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)date, (int)-1)));
        }
        if (map.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"CjrjybzjEditMultiPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
            this.getModel().setValue(DECLAREDATE, null);
            this.getPageCache().put(DECLAREDATE, null);
            return;
        }
        startdate = map.get("startdate");
        enddate = map.get("enddate");
        if (startdate == null || enddate == null) {
            return;
        }
        this.getPageCache().put(DECLAREDATE, DateUtils.format((Date)declaredate));
        this.getPageCache().put("skssqq", DateUtils.format((Date)startdate));
        this.getPageCache().put("skssqz", DateUtils.format((Date)enddate));
        this.getPageCache().put(TAXOFFICE, taxoffice.getString("id"));
        this.getPageCache().put("orgid", org.getString(ID));
        this.getDraftNumber(DateUtils.format((Date)startdate), DateUtils.format((Date)enddate));
        this.loadData(startdate, enddate, Boolean.FALSE, this.isNeedRefresh());
        this.getPageCache().remove("needMsg");
        this.init();
    }

    private void getDraftNumber(String sksqq, String sksqz) {
        String billno = this.getBillNumber(sksqq, sksqz);
        this.getModel().setValue("billno", (Object)billno);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("billno", billno);
    }

    private boolean isNeedRefresh() {
        return !QueryServiceHelper.exists((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (QFilter[])new QFilter[]{this.setDefaultQfilter()});
    }

    private QFilter setDefaultQfilter() {
        return new QFilter(ORG, "=", (Object)Long.valueOf(this.getModel().getDataEntity().getString("org.id"))).and("skssqq", "=", (Object)DateUtils.stringToDate((String)this.getPageCache().get("skssqq"))).and("skssqz", "=", (Object)DateUtils.stringToDate((String)this.getPageCache().get("skssqz"))).and("taxauthority", "=", (Object)Long.valueOf(this.getPageCache().get(TAXOFFICE))).and("templatetype", "=", (Object)this.getTemplateType());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (this.getModel().getValue(DECLAREDATE) == null || this.getModel().getValue(ORG) == null || this.getModel().getValue(TAXOFFICE) == null) {
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("save".equals(key) || "cancel".equals(key)) {
            if (this.getModel().getValue(DECLAREDATE) == null || this.getModel().getValue(ORG) == null || this.getModel().getValue(TAXOFFICE) == null) {
                evt.setCancel(true);
            }
            if ("save".equals(key) && !PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"0=KX5+QVF5+R")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1\u7533\u62a5\u201d\u7684\u4fdd\u5b58\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CjrjybzjEditMultiPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "totf_cjrjybzj";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(1);
        bizParamsMap.put("billno", this.getModel().getDataEntity().getString("billno"));
        bizParamsMap.put("taxauthority", this.getModel().getDataEntity().getString("taxoffice.id"));
        bizParamsMap.put(DECLAREDATE, DateUtils.format((Date)this.getModel().getDataEntity().getDate(DECLAREDATE), (String)"yyyy-MM-dd HH:mm:ss"));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        Long orgId = RequestContext.get().getOrgId();
        this.getPageCache().put("orgid", String.valueOf(orgId));
        return orgId;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String billno = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        this.getModel().setValue("billno", (Object)billno);
        this.getPageCache().put("billno", billno);
        return customParams;
    }

    protected QFilter getDeclareMainQueryParams() {
        return new QFilter("taxauthority", "=", (Object)Long.valueOf(this.getPageCache().get(TAXOFFICE)));
    }

    protected String getUniKey() {
        logger.info("getUniKey");
        String orgId = this.getPageCache().get("orgid");
        String skssq = this.getPageCache().get("skssqq");
        String skssz = this.getPageCache().get("skssqz");
        String taxoffice = this.getPageCache().get(TAXOFFICE);
        return String.format("%s_%s_%s_%s_%s", orgId, skssq, skssz, taxoffice, this.getTemplateType());
    }

    protected boolean viewDialog() {
        return false;
    }

    private String getBillNumber(String skssqq, String skssqz) {
        DynamicObject dynamicObject = this.checkRecordIsexist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, skssqz);
        String cnumber = null;
        cnumber = dynamicObject != null ? dynamicObject.getString("billno") : this.createNumber();
        return cnumber;
    }

    private String createNumber() {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"totf_jybz_declare_query");
        String number = codeRuleService.readNumber("totf_jybz_declare_query", dynamicObject, null);
        boolean exists = QueryServiceHelper.exists((String)"totf_jybz_declare_query", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (exists) {
            codeRuleService.getNumber("totf_jybz_declare_query", dynamicObject, null);
            number = codeRuleService.readNumber("totf_jybz_declare_query", dynamicObject, null);
        }
        return number;
    }

    private DynamicObject checkRecordIsexist(String maintable, String orgid, String type, String startDate, String endDate) {
        return YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        return Boolean.TRUE;
    }

    public static String getTaxlimit(Long orgid, Date date) {
        if (date == null) {
            return null;
        }
        Date preMonth = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)date), (int)-1);
        DynamicObjectCollection cards = CjrjybzjEditMultiPlugin.getTaxCard(orgid);
        Optional<DynamicObject> card = cards.stream().filter(e -> CjrjybzjEditMultiPlugin.isEffectiveDate(preMonth, null, e.getDate("qtsfentity.effectivestart"), e.getDate("qtsfentity.effectiveend"))).findFirst();
        if (card.isPresent()) {
            return card.get().getString("qtsfentity.taxperiod");
        }
        return null;
    }

    private static DynamicObjectCollection getTaxCard(Long orgid) {
        QFilter q1 = new QFilter("orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("qtsfentity.collectrate", "=", (Object)ZspmConstant.ID_CJRJYBZJ_ZPSM);
        return QueryServiceHelper.query((String)"tctb_tax_main", (String)"qtsfentity.taxperiod,qtsfentity.effectivestart,qtsfentity.effectiveend", (QFilter[])new QFilter[]{q1, q2});
    }

    private static boolean isEffectiveDate(Date date1, Date date2, Date start, Date end) {
        Date enddate;
        Date startdate = new Date(start.getTime());
        Date date = enddate = end != null ? new Date(end.getTime()) : null;
        if (null == date2) {
            return startdate.equals(date1) ? true : DateUtils.isEffectiveDate((Date)date1, (Date)startdate, (Date)enddate);
        }
        return !(!startdate.equals(date1) && !DateUtils.isEffectiveDate((Date)date1, (Date)startdate, (Date)enddate) || !date2.equals(enddate) && !DateUtils.isEffectiveDate((Date)date2, (Date)startdate, (Date)enddate));
    }

    private boolean checkOrg(String orgid) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        return OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
    }
}

