/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.declare;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.listener.IControlListener;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPlugin;
import kd.taxc.totf.business.declare.tysb.TysbServiceHelper;
import kd.taxc.totf.formplugin.declare.TotfTyDeclare;
import kd.taxc.totf.formplugin.declare.listener.GhjfslisListenerHelper;
import kd.taxc.totf.formplugin.declare.listener.GhjfslisOrgListener;
import kd.taxc.totf.formplugin.declare.listener.GhjfslisSbrqListener;
import kd.taxc.totf.formplugin.declare.listener.GhjfslisTaxofficeListener;
import kd.taxc.totf.formplugin.declare.listener.GhjfslisZspmListener;
import org.apache.commons.collections.CollectionUtils;

public class TotfGhjfsljsDeclarePlugin
extends AbstractDeclareReportPlugin
implements BeforeF7SelectListener {
    private static String ZSPM = "zspm";
    private static String DECLAREDATE = "declaredate";
    private static String ORG = "org";
    private static String TAXOFFICE = "taxoffice";
    private static String CACHEKEY_SELECTSBB = "selectsbb";
    private static List<IControlListener> controlListeners = new ArrayList<IControlListener>();

    public TotfGhjfsljsDeclarePlugin() {
        this.setControlListeners(controlListeners);
    }

    public String getTemplateType() {
        return "qtsf_tysbb";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bill = (BasedataEdit)this.getControl(ZSPM);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public boolean initModelValue(boolean orgChange, String orgId) {
        Date declaredate = new Date();
        this.getModel().setValue(DECLAREDATE, (Object)declaredate);
        this.getPageCache().put("declaredate", DateUtils.format((Date)declaredate));
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            this.getModel().setValue(TAXOFFICE, (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
            this.getPageCache().put("taxauthority", ((DynamicObject)result.getData()).getString("taxoffice.id"));
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ZSPM});
        this.selectSbb("click");
        return false;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String entity = this.getView().getFormShowParameter().getFormId();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if ("bar_edit".equals(key)) {
            if (org != null && StringUtil.isNotBlank((CharSequence)entity) && TotfGhjfsljsDeclarePlugin.checkPermission((Long)org.getLong("id"), (String)"0AQ3YJ2LET+U", (String)entity)) {
                super.beforeItemClick(evt);
            }
        } else {
            super.beforeItemClick(evt);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (!"bar_selectsbb".equals(key)) {
            if (StringUtil.isBlank((CharSequence)this.getPageCache().get("sbbid")) && !"bar_close".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u8868\u3002", (String)"TotfGhjfsljsDeclarePlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            if ("bar_reset".equals(key)) {
                return;
            }
            super.itemClick(evt);
        } else {
            this.selectSbb("click");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtil.isBlank((CharSequence)this.getPageCache().get("sbbid"))) {
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("recalc".equals(key)) {
            this.reset();
        }
    }

    private void selectSbb(String changetype) {
        if (this.isInvalidInput(GhjfslisZspmListener.class.getName())) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Date declaredate = (Date)this.getModel().getValue(DECLAREDATE);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Long orgid = org != null ? org.getLong("id") : 0L;
        DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
        Long taxofficeid = taxoffice != null ? taxoffice.getLong("id") : 0L;
        List<Long> sbbids = TysbServiceHelper.querySbbIds(orgid, taxofficeid, declaredate, this.getTemplateType());
        customParams.put("sbbids", sbbids);
        customParams.put("changetype", changetype);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"totf_tysb_selectsbb", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("totf_tysb_selectsbb".equals(evt.getActionId())) {
            ListSelectedRow listSelectedRow;
            Map returnData = (Map)evt.getReturnData();
            Object key = returnData.get("key");
            if (key == null) {
                Object changetype = returnData.get("changetype");
                if ("propertyChanged".equals(changetype)) {
                    this.getPageCache().remove("sbbid");
                }
            } else if ("newsbb".equals(key)) {
                Date declaredate = (Date)this.getModel().getValue("declaredate");
                Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)declaredate);
                Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)declaredate);
                Long sbbid = DeclareServiceHelper.generateSBBId((String)"totf_tysb_declare_main");
                String sbbbillno = DeclareServiceHelper.generateSBBNo((String)"totf_tysb_declare_main");
                this.getModel().setValue("declarenumber", (Object)sbbbillno);
                this.getPageCache().put("sbbid", String.valueOf(sbbid));
                this.getPageCache().put("sbbbillno", sbbbillno);
                this.getPageCache().put("declaredate", DateUtils.format((Date)declaredate));
                this.getPageCache().put("skssqq", DateUtils.format((Date)firstDateOfMonth));
                this.getPageCache().put("skssqz", DateUtils.format((Date)lastDateOfMonth));
                DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
                this.getPageCache().put("taxauthority", taxoffice.getString("id"));
                this.getModel().setValue(ZSPM, null);
                this.getPageCache().put("zspmids", "");
                this.showInnerPage(true, "edit");
            } else if ("btnok".equals(key) && (listSelectedRow = (ListSelectedRow)returnData.get("data")) != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"totf_tysb_declare_main");
                Date skssqq = object.getDate("skssqq");
                Date skssqz = object.getDate("skssqz");
                Long sbbid = object.getLong("id");
                String sbbbillno = object.getString("billno");
                this.getModel().setValue("declarenumber", (Object)sbbbillno);
                this.getPageCache().put(CACHEKEY_SELECTSBB, "true");
                this.setZSPM(sbbid);
                this.setTaxoffice(object.get("billno"));
                this.getPageCache().put("sbbid", String.valueOf(sbbid));
                this.getPageCache().put("sbbbillno", sbbbillno);
                this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
                this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
                this.showInnerPage(false, "read");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (ZSPM.equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"TotfGhjfsljsDeclarePlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Date declaredate = (Date)this.getModel().getValue(DECLAREDATE);
            if (declaredate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7533\u62a5\u65e5\u671f\u3002", (String)"TotfGhjfsljsDeclarePlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
            if (taxoffice == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u52a1\u673a\u5173\u3002", (String)"TotfGhjfsljsDeclarePlugin_8", (String)"taxc-totf", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String sbbid = this.getPageCache().get("sbbid");
            List<Long> objects = TotfTyDeclare.getTaxTypeCard(sbbid, org.getLong("id"), taxoffice.getLong("id"), declaredate, ZspmEnum.getZspmIdsByTemplateType((String)this.getTemplateType()));
            if (CollectionUtils.isEmpty(objects)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7f34\u7eb3\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"TotfGhjfsljsDeclarePlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", objects));
        }
    }

    public void afterPropertyChanged(PropertyChangedArgs args, String changetype) {
        String name = args.getProperty().getName();
        if (ZSPM.equals(name)) {
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(CACHEKEY_SELECTSBB))) {
                this.getPageCache().remove(CACHEKEY_SELECTSBB);
            } else {
                this.showInnerPage(true, "edit");
            }
        } else {
            this.selectSbb(changetype);
        }
    }

    protected void setRequestModel(DeclareRequestModel requestModel) {
        String operation = this.getPageCache().get("operation");
        this.getView().setEnable(Boolean.valueOf("edit".equals(operation)), new String[]{ZSPM});
        if (requestModel.getRefresh().booleanValue()) {
            requestModel.addBusinessValue(DECLAREDATE, this.getPageCache().get("declaredate"));
            requestModel.addBusinessValue("taxoffice", this.getPageCache().get("taxauthority"));
            long taxofficeId = 0L;
            DynamicObject taxofficeDyo = (DynamicObject)this.getModel().getValue(TAXOFFICE);
            if (null != taxofficeDyo) {
                taxofficeId = taxofficeDyo.getLong("id");
            }
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("taxauthority", taxofficeId);
            requestModel.setExtendParams(map);
            String zspmIds = this.getPageCache().get("zspmids");
            TotfTyDeclare.setZspmMessage(requestModel, zspmIds, this.getPageCache().get("orgid"), taxofficeId, (Date)this.getModel().getValue(DECLAREDATE), this.getPageCache());
        }
    }

    protected DynamicObject queryNsrxx(String orgId, String templateType, String startdate, String enddate) {
        return YbnsrService.queryYbnsr((String)this.getPageCache().get("sbbid"));
    }

    protected void doInLoadFromHyperLinkClick(DynamicObject nsrxx) {
        this.setZSPM(nsrxx.getLong("id"));
        GhjfslisListenerHelper.showZeroDeclareTips(this.getView(), this.getModel());
        this.setTaxoffice(nsrxx.get("billno"));
    }

    private void setZSPM(Long sbbid) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"totf_sjfzsf_dtb", (String)ZSPM, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            ArrayList objects = Lists.newArrayList();
            ArrayList zspmIds = Lists.newArrayList();
            for (int i = 0; i < query.size(); ++i) {
                Long zspmid = ZspmEnum.getZspmIdByNameAndTemplateType((String)((DynamicObject)query.get(i)).getString(ZSPM).trim(), (String)this.getTemplateType());
                if (zspmid == null) continue;
                objects.add(zspmid);
                zspmIds.add(zspmid.toString());
            }
            this.getModel().setValue(ZSPM, (Object)objects.toArray());
            this.getPageCache().put("zspmids", String.join((CharSequence)"#", zspmIds));
        }
    }

    private void setTaxoffice(Object billno) {
        DynamicObject query = BusinessDataServiceHelper.loadSingle((String)"totf_tysb_declare_main", (String)"taxauthority", (QFilter[])new QFilter[]{new QFilter("billno", "=", billno)});
        if (query != null) {
            DynamicObject taxoffice = (DynamicObject)query.get("taxauthority");
            this.getModel().setValue(TAXOFFICE, (Object)taxoffice.getString("id"));
            this.getPageCache().put("taxauthority", taxoffice.getString("id"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("bar_reset".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Date declaredate = (Date)this.getModel().getValue(DECLAREDATE);
            MulBasedataDynamicObjectCollection zspm = (MulBasedataDynamicObjectCollection)this.getModel().getValue(ZSPM);
            if (CollectionUtils.isEmpty((Collection)zspm)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f81\u6536\u54c1\u76ee\u201d\u3002", (String)"TotfGhjfsljsDeclarePlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            if (org != null && declaredate != null) {
                Date date = DateUtils.addMonth((Date)declaredate, (int)-1);
                int month = DateUtils.getMonthOfDate((Date)declaredate);
                TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(org.getLong("id")));
                if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                    DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
                    DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
                    List collect = qtsfentity.stream().filter(s -> Lists.newArrayList((Object[])new Long[]{ZspmConstant.ID_DFSLJSJJ_ZPSM, ZspmConstant.ID_DWFHF_ZPSM, ZspmConstant.ID_GHCBJ_ZPSM, ZspmConstant.ID_GHJH_ZPSM}).contains(s.getLong("collectrate.id"))).filter(s -> date.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || date.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
                    for (DynamicObject object : collect) {
                        String taxperiod = object.getString("taxperiod");
                        if ("season".equals(taxperiod)) {
                            if (month == 1 || month == 4 || month == 7 || month == 10) continue;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u7f34\u7eb3\u671f\u9650\u5df2\u6539\uff0c\u6b64\u5f81\u6536\u54c1\u76ee\u5728\u7533\u62a5\u8868\u4e2d\u4f1a\u79fb\u9664/\u589e\u52a0\u3002", (String)"TotfGhjfsljsDeclarePlugin_6", (String)"taxc-totf", (Object[])new Object[0]), object.getString("collectrate.name")));
                            continue;
                        }
                        if ("halfyear".equals(taxperiod)) {
                            if (month == 1 || month == 7) continue;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u7f34\u7eb3\u671f\u9650\u5df2\u6539\uff0c\u6b64\u5f81\u6536\u54c1\u76ee\u5728\u7533\u62a5\u8868\u4e2d\u4f1a\u79fb\u9664/\u589e\u52a0\u3002", (String)"TotfGhjfsljsDeclarePlugin_6", (String)"taxc-totf", (Object[])new Object[0]), object.getString("collectrate.name")));
                            continue;
                        }
                        if (!"year".equals(taxperiod) || month == 1) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u7f34\u7eb3\u671f\u9650\u5df2\u6539\uff0c\u6b64\u5f81\u6536\u54c1\u76ee\u5728\u7533\u62a5\u8868\u4e2d\u4f1a\u79fb\u9664/\u589e\u52a0\u3002", (String)"TotfGhjfsljsDeclarePlugin_6", (String)"taxc-totf", (Object[])new Object[0]), object.getString("collectrate.name")));
                    }
                    this.openDeclarePage(true);
                }
                return;
            }
        }
        super.confirmCallBack(e);
    }

    static {
        controlListeners.add((IControlListener)new GhjfslisOrgListener("qtsf_tysbb"));
        controlListeners.add(new GhjfslisSbrqListener());
        controlListeners.add(new GhjfslisZspmListener());
        controlListeners.add(new GhjfslisTaxofficeListener());
    }
}

