/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.declare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.totf.business.account.OtherIncomeServiceHelper;
import kd.taxc.totf.business.account.WaterFundServiceHelper;
import kd.taxc.totf.business.declare.tysb.TysbServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TotfTyDeclare {
    private static final String QTSRLIST = "jbrysfzjlx,jbrphone,operatorno,operator";
    private static final String FSSQTSRLIST = "jbrysfzjlx,jbrphone,operatorno,operator,remark";
    private static final String SPLIT = "_";
    public static final Map<Long, MultiLangEnumBridge> CcTypeMap = new HashMap<Long, MultiLangEnumBridge>(){
        {
            this.put(ZspmConstant.ID_CZLJCLF_ZPSM, new MultiLangEnumBridge("\u5efa\u8bbe\u884c\u653f\u4e8b\u4e1a\u6027\u6536\u8d39\u6536\u5165", "TotfTyDeclare_2", "taxc-totf"));
            this.put(ZspmConstant.ID_DFSLJSJJ_ZPSM, new MultiLangEnumBridge("\u6c34\u5229\u5efa\u8bbe\u4e13\u9879\u6536\u5165", "TotfTyDeclare_1", "taxc-totf"));
            this.put(ZspmConstant.ID_DWFHF_ZPSM, new MultiLangEnumBridge("\u6c34\u5229\u5efa\u8bbe\u4e13\u9879\u6536\u5165", "TotfTyDeclare_1", "taxc-totf"));
            this.put(ZspmConstant.ID_GHJH_ZPSM, new MultiLangEnumBridge("\u5176\u4ed6\u6536\u5165", "TotfTyDeclare_3", "taxc-totf"));
            this.put(ZspmConstant.ID_GHCBJ_ZPSM, new MultiLangEnumBridge("\u5176\u4ed6\u6536\u5165", "TotfTyDeclare_3", "taxc-totf"));
            this.put(ZspmConstant.ID_STBCBCF_ZPSM, new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165", "TotfTyDeclare_4", "taxc-totf"));
            this.put(ZspmConstant.ID_STBCBCF_JSQSR_ZPSM, new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165", "TotfTyDeclare_4", "taxc-totf"));
            this.put(ZspmConstant.ID_STBCBCF_KCQSR_ZPSM, new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165", "TotfTyDeclare_4", "taxc-totf"));
            this.put(ZspmConstant.ID_STBCBCF_QTSR_ZPSM, new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165", "TotfTyDeclare_4", "taxc-totf"));
        }
    };

    public static List<Long> getTaxTypeCard(String sbbid, Long orgid, Long taxofficeid, Date declaredate, List<Long> taxId) {
        TaxResult licenseResult;
        boolean hasLicense;
        ArrayList objects = Lists.newArrayList();
        Date date = DateUtils.addMonth((Date)declaredate, (int)-1);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgid));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
            List collect = qtsfentity.stream().filter(s -> taxId.contains(s.getLong("collectrate.id"))).filter(s -> date.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || date.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
            for (DynamicObject object : collect) {
                boolean exists;
                String taxperiod = object.getString("taxperiod");
                if ("count".equals(taxperiod)) {
                    objects.add(object.getLong("collectrate.id"));
                    continue;
                }
                if (ZspmConstant.ID_CZLJCLF_ZPSM.equals(object.getLong("collectrate.id"))) {
                    objects.add(object.getLong("collectrate.id"));
                    continue;
                }
                Map skssqzMap = DateUtils.getSkssqzMap((Date)declaredate, (String)taxperiod);
                if (!EmptyCheckUtils.isNotEmpty((Object)skssqzMap)) continue;
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("org", "=", (Object)orgid));
                qFilters.add(new QFilter("taxauthority", "=", (Object)taxofficeid));
                qFilters.add(new QFilter("entryentity.startdate", "=", skssqzMap.get("skssqq")));
                qFilters.add(new QFilter("entryentity.enddate", "=", skssqzMap.get("skssqz")));
                qFilters.add(new QFilter("entryentity.zspm", "=", (Object)object.getString("collectrate.name")));
                if (EmptyCheckUtils.isNotEmpty((Object)sbbid)) {
                    qFilters.add(new QFilter("id", "!=", (Object)Long.parseLong(sbbid)));
                }
                if (exists = QueryServiceHelper.exists((String)"totf_tysb_declare_main", (QFilter[])qFilters.toArray(new QFilter[0]))) continue;
                objects.add(object.getLong("collectrate.id"));
            }
        }
        if (!(hasLicense = Boolean.FALSE.equals((licenseResult = TaxcLicenseCheckDataServiceHelper.check((Long)orgid, (String)"totf")).getData()))) {
            objects.removeIf(zspmId -> {
                ZspmEnum zspmEnum = ZspmEnum.valueOfZspmId((Long)zspmId);
                if (zspmEnum != null && EmptyCheckUtils.isNotEmpty((Object)zspmEnum.getParamKey())) {
                    Object zeroDeclare = SystemParamUtil.getAppParameter((String)"totf", (String)zspmEnum.getParamKey(), (long)orgid);
                    return Boolean.FALSE.equals(zeroDeclare);
                }
                return true;
            });
        }
        return objects;
    }

    public static String setZspmMessage(DeclareRequestModel requestModel, String zspmIds, String orgid, Long taxofficeId, Date declaredate, IPageCache pageCache) {
        SourceOperateHelper.deleteSourceTpEntity((String)requestModel.getTemplateType(), (Long)requestModel.getId());
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        if (StringUtils.isNotEmpty((CharSequence)zspmIds)) {
            Date date = DateUtils.addMonth((Date)declaredate, (int)-1);
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(Long.parseLong(orgid)));
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
                DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
                if ("qtsf_fsstysbb".equals(requestModel.getTemplateType())) {
                    TotfTyDeclare.FssQtsrMessage(qtsfentity, requestModel, zspmIds, orgid, date, pageCache, maps, taxofficeId);
                } else {
                    TotfTyDeclare.QtsrMessage(qtsfentity, requestModel, zspmIds, orgid, date, pageCache, maps, taxofficeId);
                }
            }
        } else {
            TotfTyDeclare.setCommonMessage(requestModel, FSSQTSRLIST, false, null);
        }
        String jsonString = JSONObject.toJSONString(maps);
        Map<String, Date> skssqMap = TysbServiceHelper.getSkssqMap(maps);
        if (skssqMap.get("skssqq") != null && skssqMap.get("skssqz") != null) {
            requestModel.setSkssqq(DateUtils.format((Date)skssqMap.get("skssqq")));
            requestModel.setSkssqz(DateUtils.format((Date)skssqMap.get("skssqz")));
        }
        requestModel.addBusinessValue("zspm", jsonString);
        requestModel.addBusinessValue("billno", requestModel.getBillNo());
        return jsonString;
    }

    private static void QtsrMessage(DynamicObjectCollection qtsfentity, DeclareRequestModel requestModel, String zspm, String orgid, Date date, IPageCache pageCache, List<Map<String, Object>> maps, Long taxofficeId) {
        TotfTyDeclare.setCommonMessage(requestModel, QTSRLIST, false, null);
        String[] split = zspm.split("#");
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare", (long)Long.parseLong(orgid));
        boolean zerodeclareGhjf = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare_ghjf", (long)Long.parseLong(orgid));
        boolean zerodeclareGhcbj = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare_ghcbj", (long)Long.parseLong(orgid));
        for (String det : split) {
            List<DynamicObject> collect = qtsfentity.stream().filter(s -> det.equals(s.getString("collectrate.id"))).filter(s -> date.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || date.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
            String limit = CollectionUtils.isNotEmpty(collect) ? ((DynamicObject)collect.get(0)).getString("taxperiod") : "";
            String dateContact = TotfTyDeclare.setDateMessage(collect, requestModel, date);
            Date start = DateUtils.stringToDate((String)dateContact.substring(0, dateContact.indexOf("#")));
            Date end = DateUtils.stringToDate((String)dateContact.substring(dateContact.indexOf("#") + 1));
            boolean size = false;
            if (String.valueOf(ZspmConstant.ID_GHJH_ZPSM).equals(det) || String.valueOf(ZspmConstant.ID_GHCBJ_ZPSM).equals(det)) {
                DynamicObjectCollection accountList = new DynamicObjectCollection();
                if (!zerodeclareGhjf && String.valueOf(ZspmConstant.ID_GHJH_ZPSM).equals(det) || !zerodeclareGhcbj && String.valueOf(ZspmConstant.ID_GHCBJ_ZPSM).equals(det)) {
                    accountList = OtherIncomeServiceHelper.queryGhjfAccount(orgid, start, end, det, taxofficeId, requestModel.getId(), limit);
                }
                if (CollectionUtils.isEmpty((Collection)accountList)) {
                    TotfTyDeclare.setDataBlank(orgid, taxofficeId, collect, maps, start, end, null);
                    continue;
                }
                if ("count".equals(limit)) {
                    for (DynamicObject result : accountList) {
                        pageCache.put(det + "start", DateUtils.format((Date)start));
                        pageCache.put(det + "end", DateUtils.format((Date)end));
                        TotfTyDeclare.setQtsrMessage(collect, result, requestModel, start, end, maps);
                    }
                } else {
                    TotfTyDeclare.setQtsrMessageBySum(collect, accountList, requestModel, start, end, maps);
                }
                SourceOperateHelper.saveMappingData((String)"totf_otherincome_account", (Long)requestModel.getId(), (List)accountList);
                continue;
            }
            TotfTyDeclare.setDataBlank(orgid, taxofficeId, collect, maps, start, end, null);
        }
    }

    private static void FssQtsrMessage(DynamicObjectCollection qtsfentity, DeclareRequestModel requestModel, String zspmIds, String orgid, Date date, IPageCache pageCache, List<Map<String, Object>> maps, Long taxofficeId) {
        TotfTyDeclare.setCommonMessage(requestModel, FSSQTSRLIST, false, null);
        String[] split = zspmIds.split("#");
        boolean zerodeclare_czljcl = SystemParamUtil.getZeroDeclareParameter((String)"totf", (String)"zerodeclare_czljcl", (long)Long.parseLong(orgid));
        for (String zspmId : split) {
            List<DynamicObject> collect = qtsfentity.stream().filter(s -> zspmId.equals(s.getString("collectrate.id"))).filter(s -> date.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || date.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) continue;
            List<Long> zszmList = collect.stream().filter(s -> s.getDynamicObject("collectitem") != null).map(s -> s.getDynamicObject("collectitem").getLong("id")).collect(Collectors.toList());
            String limit = CollectionUtils.isNotEmpty(collect) ? ((DynamicObject)collect.get(0)).getString("taxperiod") : "";
            String dateContact = TotfTyDeclare.setDateMessage(collect, requestModel, date);
            Date start = DateUtils.stringToDate((String)dateContact.substring(0, dateContact.indexOf("#")));
            Date end = DateUtils.stringToDate((String)dateContact.substring(dateContact.indexOf("#") + 1));
            List<String> zszmNameList = collect.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("collectitem.projectname"))).map(s -> s.getString("collectitem.projectname")).collect(Collectors.toList());
            if (String.valueOf(ZspmConstant.ID_CZLJCLF_ZPSM).equals(zspmId)) {
                if (CollectionUtils.isNotEmpty(zszmList)) {
                    pageCache.put("zszmList", SerializationUtils.toJsonString(zszmList));
                } else {
                    pageCache.put("zszmList", null);
                }
                DynamicObjectCollection accountList = new DynamicObjectCollection();
                if (!zerodeclare_czljcl) {
                    accountList = OtherIncomeServiceHelper.queryLjclfAccount(orgid, taxofficeId, start, end, zszmList, requestModel.getId(), zspmId, limit);
                }
                if (CollectionUtils.isNotEmpty((Collection)accountList)) {
                    if ("count".equals(limit)) {
                        for (DynamicObject result : accountList) {
                            pageCache.put("0091start", DateUtils.format((Date)start));
                            pageCache.put("0091end", DateUtils.format((Date)end));
                            TotfTyDeclare.setFssQtsrMessage(requestModel, collect, result, maps);
                        }
                    } else {
                        TotfTyDeclare.setFssQtsrMessage(requestModel, collect, accountList, maps, DateUtils.format((Date)start), DateUtils.format((Date)end));
                    }
                }
                SourceOperateHelper.saveMappingData((String)"totf_jsxzsyxsf_account", (Long)requestModel.getId(), (List)accountList);
                if (!CollectionUtils.isEmpty((Collection)accountList)) continue;
                TotfTyDeclare.setDataBlank(orgid, taxofficeId, collect, maps, start, end, zszmNameList);
                continue;
            }
            if (String.valueOf(ZspmConstant.ID_STBCBCF_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_JSQSR_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_KCQSR_ZPSM).equals(zspmId) || String.valueOf(ZspmConstant.ID_STBCBCF_QTSR_ZPSM).equals(zspmId)) {
                DynamicObject[] accounts = OtherIncomeServiceHelper.queryWaterSoilAccount(orgid, taxofficeId, start, end, zspmId, requestModel.getId());
                if (accounts.length > 0) {
                    for (DynamicObject account : accounts) {
                        TotfTyDeclare.setFssStbcbcfMessage(account, maps);
                    }
                } else {
                    TotfTyDeclare.setDataBlank(orgid, taxofficeId, collect, maps, start, end, zszmNameList);
                }
                SourceOperateHelper.saveMappingData((String)"totf_stbcbcf_account", (Long)requestModel.getId(), Arrays.asList(accounts));
                continue;
            }
            TotfTyDeclare.setDataBlank(orgid, taxofficeId, collect, maps, start, end, zszmNameList);
        }
    }

    private static String setDateMessage(List<DynamicObject> collect, DeclareRequestModel requestModel, Date date) {
        Date start = new Date();
        Date end = new Date();
        if (CollectionUtils.isNotEmpty(collect)) {
            String taxperiod;
            DynamicObject object = collect.get(0);
            switch (taxperiod = object.getString("taxperiod")) {
                case "month": {
                    start = DateUtils.getFirstDateOfMonth((Date)date);
                    end = DateUtils.getLastDateOfMonth((Date)date);
                    break;
                }
                case "season": {
                    start = DateUtils.getFirstDateOfSeason((Date)date);
                    end = DateUtils.getLastDateOfSeason((Date)date);
                    break;
                }
                case "halfyear": {
                    start = DateUtils.getFirstDateOfHalfYear((Date)date);
                    end = DateUtils.getLastDateOfHalfYear((Date)date);
                    break;
                }
                case "year": {
                    start = DateUtils.getFirstDateOfYear((Date)date);
                    end = DateUtils.getLastDateOfYear((Date)date);
                    break;
                }
                case "count": {
                    start = DateUtils.addMonth((Date)date, (int)1);
                    end = DateUtils.addMonth((Date)date, (int)1);
                    break;
                }
            }
            if (requestModel.getSkssqq() == null || start.compareTo(DateUtils.stringToDate((String)requestModel.getSkssqq())) < 0) {
                requestModel.setSkssqq(DateUtils.format((Date)start));
                requestModel.setSkssqz(DateUtils.format((Date)end));
            }
        }
        return DateUtils.format((Date)start) + "#" + DateUtils.format((Date)end);
    }

    private static int setQtsrMessage(List<DynamicObject> collect, DynamicObject result, DeclareRequestModel requestModel, Date start, Date end, List<Map<String, Object>> maps) {
        int size = maps.size();
        HashMap<String, Object> resultMap = TotfTyDeclare.initResultMap(collect, start, end);
        if (null != result) {
            resultMap.put("zspmId", collect.get(0).getString("collectrate.id"));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)result.getDate("startdate")));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)result.getDate("enddate")));
            resultMap.put("totf_sjfzsf_dtb#ysx", result.getBigDecimal("taxableitem"));
            resultMap.put("totf_sjfzsf_dtb#jcx", result.getBigDecimal("deductitem"));
            resultMap.put("totf_sjfzsf_dtb#yssdl", result.getBigDecimal("taxrate"));
            resultMap.put("totf_sjfzsf_dtb#sskcs", result.getBigDecimal("quickdeduction"));
            resultMap.put("totf_sjfzsf_dtb#jmse", result.getBigDecimal("deductionamount"));
            resultMap.put("totf_sjfzsf_dtb#deductioncode", result.getLong("taxdeduction"));
            resultMap.put("totf_sjfzsf_dtb#xgmjmxz", result.getLong("zzsdeducttype"));
            resultMap.put("totf_sjfzsf_dtb#xgmjzbl", result.getBigDecimal("zzsdeductrate"));
            resultMap.put("totf_sjfzsf_dtb#yjse", result.getBigDecimal("bqyjse"));
            TotfTyDeclare.setCommonMessage(requestModel, QTSRLIST, true, result);
        }
        maps.add(resultMap);
        return maps.size() - size;
    }

    private static BigDecimal getSum(DynamicObjectCollection result, String field) {
        return result.stream().map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static Object getlastNotEmptyValue(DynamicObjectCollection result, String field) {
        return result.stream().sorted(Comparator.comparing(s -> s.getDate("startdate")).reversed()).filter(s -> s.get(field) != null).map(s -> s.get(field)).findFirst().orElseGet(() -> null);
    }

    private static HashMap<String, Object> initResultMap(List<DynamicObject> collect, Date start, Date end) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject object = collect.get(0);
        String name = object.getString("collectrate.name");
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)start));
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)end));
        resultMap.put("totf_sjfzsf_dtb#symc", "");
        resultMap.put("totf_sjfzsf_dtb#sybh", "");
        resultMap.put("totf_sjfzsf_dtb#xgmjmxz", "");
        return resultMap;
    }

    private static int setQtsrMessageBySum(List<DynamicObject> collect, DynamicObjectCollection result, DeclareRequestModel requestModel, Date start, Date end, List<Map<String, Object>> maps) {
        int size = maps.size();
        HashMap<String, Object> resultMap = TotfTyDeclare.initResultMap(collect, start, end);
        if (result != null && result.size() > 0) {
            resultMap.put("zspmId", collect.get(0).getString("collectrate.id"));
            resultMap.put("totf_sjfzsf_dtb#ysx", TotfTyDeclare.getSum(result, "taxableitem"));
            resultMap.put("totf_sjfzsf_dtb#jcx", TotfTyDeclare.getSum(result, "deductitem"));
            resultMap.put("totf_sjfzsf_dtb#yssdl", TotfTyDeclare.getlastNotEmptyValue(result, "taxrate"));
            resultMap.put("totf_sjfzsf_dtb#sskcs", TotfTyDeclare.getSum(result, "quickdeduction"));
            resultMap.put("totf_sjfzsf_dtb#jmse", TotfTyDeclare.getSum(result, "deductionamount"));
            resultMap.put("totf_sjfzsf_dtb#deductioncode", TotfTyDeclare.getlastNotEmptyValue(result, "taxdeduction"));
            resultMap.put("totf_sjfzsf_dtb#xgmjmxz", TotfTyDeclare.getlastNotEmptyValue(result, "zzsdeducttype"));
            resultMap.put("totf_sjfzsf_dtb#xgmjzbl", TotfTyDeclare.getSum(result, "zzsdeductrate"));
            resultMap.put("totf_sjfzsf_dtb#yjse", TotfTyDeclare.getSum(result, "bqyjse"));
            TotfTyDeclare.setCommonMessage(requestModel, QTSRLIST, true, (DynamicObject)result.get(0));
        }
        maps.add(resultMap);
        return maps.size() - size;
    }

    private static void setFssQtsrMessage(DeclareRequestModel requestModel, List<DynamicObject> collect, DynamicObject result, List<Map<String, Object>> maps) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject object = collect.get(0);
        String name = object.getString("collectrate.name");
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
        if (null != result) {
            resultMap.put("zspmId", object.getString("collectrate.id"));
            resultMap.put("zszmId", result.getString("zszm"));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)result.getDate("startdate")));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)result.getDate("enddate")));
            resultMap.put("totf_sjfzsf_dtb#zszm", OtherIncomeServiceHelper.getZszmName(result.getLong("zszm")));
            resultMap.put("totf_sjfzsf_dtb#yjfjs", result.getBigDecimal("taxableitem"));
            resultMap.put("totf_sjfzsf_dtb#yjfjscke", result.getBigDecimal("deductitem"));
            resultMap.put("totf_sjfzsf_dtb#sskcs", result.getBigDecimal("quickdeduction"));
            resultMap.put("totf_sjfzsf_dtb#jmse", result.getBigDecimal("deductionamount"));
            resultMap.put("totf_sjfzsf_dtb#zsbl", result.getBigDecimal("taxrate"));
            resultMap.put("totf_sjfzsf_dtb#deductioncode", result.getLong("taxdeduction"));
            resultMap.put("totf_sjfzsf_dtb#yjse", result.getBigDecimal("bqyjse"));
            TotfTyDeclare.setCommonMessage(requestModel, FSSQTSRLIST, true, result);
        }
        maps.add(resultMap);
    }

    public static void setFssStbcbcfMessage(DynamicObject account, List<Map<String, Object>> maps) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        String name = account.getString("zspm.name");
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), CcTypeMap.get(account.getLong("zspm.id")).loadKDString());
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), account.getBigDecimal("rate"));
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)account.getDate("startdate")));
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)account.getDate("enddate")));
        resultMap.put("totf_sjfzsf_dtb#zszm", account.get("zszm") != null ? account.getString("zszm.projectname") : "");
        resultMap.put("totf_sjfzsf_dtb#yjfjs", account.getBigDecimal("yjfjs"));
        resultMap.put("totf_sjfzsf_dtb#jmse", account.getBigDecimal("deductionamount"));
        resultMap.put("totf_sjfzsf_dtb#deductioncode", account.get("taxdeduction.id"));
        resultMap.put("totf_sjfzsf_dtb#yjfjscke", account.getBigDecimal("yjfjsjme"));
        resultMap.put("totf_sjfzsf_dtb#sskcs", account.getBigDecimal("quickdeduction"));
        resultMap.put("totf_sjfzsf_dtb#yjse", account.getBigDecimal("bqyjse"));
        resultMap.put("totf_sjfzsf_dtb#zsbl", BigDecimal.valueOf(1L));
        maps.add(resultMap);
    }

    public static void setFssQtsrMessage(DeclareRequestModel requestModel, List<DynamicObject> collect, DynamicObjectCollection accountObjects, List<Map<String, Object>> maps, String startDate, String endDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject object = collect.get(0);
        String name = object.getString("collectrate.name");
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
        resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
        if (EmptyCheckUtils.isNotEmpty((Object)accountObjects)) {
            resultMap.put("zspmId", object.getString("collectrate.id"));
            resultMap.put("zszmId", ((DynamicObject)accountObjects.get(0)).getString("zszm"));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), startDate);
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), endDate);
            resultMap.put("totf_sjfzsf_dtb#zszm", OtherIncomeServiceHelper.getZszmName(((DynamicObject)accountObjects.get(0)).getLong("zszm")));
            BigDecimal taxableitem = BigDecimal.ZERO;
            BigDecimal deductitem = BigDecimal.ZERO;
            BigDecimal quickdeduction = BigDecimal.ZERO;
            BigDecimal deductionamount = BigDecimal.ZERO;
            BigDecimal bqyjse = BigDecimal.ZERO;
            BigDecimal taxrate = BigDecimal.ZERO;
            Long taxdeduction = 0L;
            Date date = DateUtils.stringToDate2((String)startDate);
            for (DynamicObject account : accountObjects) {
                taxableitem = taxableitem.add(account.getBigDecimal("taxableitem"));
                deductitem = deductitem.add(account.getBigDecimal("deductitem"));
                quickdeduction = quickdeduction.add(account.getBigDecimal("quickdeduction"));
                deductionamount = deductionamount.add(account.getBigDecimal("deductionamount"));
                bqyjse = bqyjse.add(account.getBigDecimal("bqyjse"));
                Date enddate = account.getDate("enddate");
                if (date == null || enddate == null || enddate.compareTo(date) <= 0) continue;
                date = enddate;
                taxrate = account.getBigDecimal("taxrate");
                taxdeduction = account.getLong("taxdeduction");
            }
            resultMap.put("totf_sjfzsf_dtb#yjfjs", taxableitem);
            resultMap.put("totf_sjfzsf_dtb#yjfjscke", deductitem);
            resultMap.put("totf_sjfzsf_dtb#sskcs", quickdeduction);
            resultMap.put("totf_sjfzsf_dtb#jmse", deductionamount);
            resultMap.put("totf_sjfzsf_dtb#zsbl", taxrate);
            resultMap.put("totf_sjfzsf_dtb#deductioncode", taxdeduction);
            resultMap.put("totf_sjfzsf_dtb#yjse", bqyjse);
            TotfTyDeclare.setCommonMessage(requestModel, FSSQTSRLIST, true, (DynamicObject)accountObjects.get(0));
        }
        maps.add(resultMap);
    }

    public static void setCommonMessage(DeclareRequestModel requestModel, String typeList, Boolean isInsert, DynamicObject result) {
        String[] typeArray = typeList.split(",");
        if (isInsert.booleanValue()) {
            for (String type : typeArray) {
                String businessValue = requestModel.getBusinessValue(type);
                if (!StringUtils.isEmpty((CharSequence)businessValue) || result == null) continue;
                requestModel.addBusinessValue(type, result.getString(type));
            }
        } else {
            for (String type : typeArray) {
                String businessValue = requestModel.getBusinessValue(type);
                if (!StringUtils.isEmpty((CharSequence)businessValue)) continue;
                if ("jbrysfzjlx".equals(type)) {
                    requestModel.addBusinessValue("jbrysfzjlx", "1");
                    continue;
                }
                requestModel.addBusinessValue(type, "");
            }
        }
    }

    public static void setDataBlank(String orgid, Long taxofficeId, List<DynamicObject> collect, List<Map<String, Object>> maps, Date start, Date end, List<String> zszmList) {
        if (!CollectionUtils.isEmpty(zszmList)) {
            int i = 0;
            for (String zszmName : zszmList) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                DynamicObject object = collect.get(i);
                String name = object.getString("collectrate.name");
                resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
                resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
                resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
                resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)start));
                resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)end));
                resultMap.put("totf_sjfzsf_dtb#yssdl", BigDecimal.valueOf(1L));
                resultMap.put("totf_sjfzsf_dtb#zsbl", BigDecimal.valueOf(1L));
                resultMap.put("totf_sjfzsf_dtb#zszm", zszmName);
                resultMap.put("totf_sjfzsf_dtb#symc", "");
                resultMap.put("totf_sjfzsf_dtb#sybh", "");
                resultMap.put("totf_sjfzsf_dtb#xgmjmxz", "");
                maps.add(resultMap);
                ++i;
            }
        } else {
            DynamicObject dynamicObjects;
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            DynamicObject object = collect.get(0);
            String name = object.getString("collectrate.name");
            if (String.valueOf(ZspmConstant.ID_DFSLJSJJ_ZPSM).equals(object.getString("collectrate.id")) && Objects.nonNull(dynamicObjects = WaterFundServiceHelper.querySljjAccount(orgid, start, end, object.getString("collectrate.id"), taxofficeId, null))) {
                resultMap.put("zspmId", object.getString("collectrate.id"));
            }
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zspm"), name);
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "zsxm"), CcTypeMap.get(object.getLong("collectrate.id")).loadKDString());
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "flhdwse"), object.getBigDecimal("amountrate").setScale(6, 4));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "startdate"), DateUtils.format((Date)start));
            resultMap.put(String.format("%1$s#%2$s", "totf_sjfzsf_dtb", "enddate"), DateUtils.format((Date)end));
            resultMap.put("totf_sjfzsf_dtb#yssdl", BigDecimal.valueOf(1L));
            resultMap.put("totf_sjfzsf_dtb#zsbl", BigDecimal.valueOf(1L));
            resultMap.put("totf_sjfzsf_dtb#symc", "");
            resultMap.put("totf_sjfzsf_dtb#sybh", "");
            resultMap.put("totf_sjfzsf_dtb#zszm", "");
            resultMap.put("totf_sjfzsf_dtb#xgmjmxz", "");
            maps.add(resultMap);
        }
    }
}

