/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.listener.IControlListener;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPlugin;
import kd.taxc.totf.business.declare.WhsyjsfDeclareService;
import kd.taxc.totf.common.utils.WhsyjsfUtils;
import kd.taxc.totf.formplugin.declare.listener.WhsyjsfOrgListener;
import kd.taxc.totf.formplugin.declare.listener.WhsyjsfSbrqListener;

public class WhsyjsfDeclarePlugin
extends AbstractDeclareReportPlugin {
    private static final String DECLAREDATE = "declaredate";
    private static String TAXOFFICE = "taxoffice";
    private static final String TOTF_WHSYJS_DECLARE_QUERY = "totf_whsyjs_declare_query";
    private static List<IControlListener> controlListeners = new ArrayList<IControlListener>();

    public WhsyjsfDeclarePlugin() {
        this.setControlListeners(controlListeners);
    }

    public String getTemplateType() {
        return "whsyjsf";
    }

    public boolean initModelValue(boolean orgChange, String orgId) {
        this.getModel().setValue(DECLAREDATE, (Object)new Date());
        if (EmptyCheckUtils.isEmpty((Object)orgId)) {
            return false;
        }
        WhsyjsfDeclareService.initPeriod(this.getModel(), this.getView(), this.getPageCache(), Long.valueOf(orgId));
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        String declaredate = this.getPageCache().get(DECLAREDATE);
        return null != skssqq && null != skssqz && null != declaredate;
    }

    public void afterPropertyChanged(PropertyChangedArgs args, String changetype) {
        String sbbbillno;
        Long sbbid;
        QFilter q4;
        QFilter q3;
        QFilter q2;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date declaredate = (Date)this.getModel().getValue(DECLAREDATE);
        DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
        if (null == org || taxoffice == null) {
            return;
        }
        Date date = DateUtils.getFirstDateOfMonth((Date)declaredate);
        Date startdate = null;
        Date enddate = null;
        String taxlimit = WhsyjsfUtils.getTaxlimit(org.getLong("id"), date);
        if (null == taxlimit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"WhsyjsfDeclarePlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
            this.getModel().setValue(DECLAREDATE, null);
            this.getPageCache().put(DECLAREDATE, null);
            return;
        }
        Map<String, Date> map = WhsyjsfUtils.getStartAndEndDate(date, taxlimit);
        if (map.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee\u3002", (String)"WhsyjsfDeclarePlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
            this.getModel().setValue(DECLAREDATE, null);
            this.getPageCache().put(DECLAREDATE, null);
            return;
        }
        startdate = map.get("startdate");
        enddate = map.get("enddate");
        String operationStatus = "read";
        boolean refresh = false;
        QFilter q1 = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billno,declaredate,billstatus", (QFilter[])new QFilter[]{q1, q2 = new QFilter("type", "=", (Object)"whsyjsf"), q3 = new QFilter("skssqz", "=", (Object)enddate).and(new QFilter("skssqq", "=", (Object)startdate)), q4 = new QFilter("taxauthority", "=", taxoffice.get("id"))});
        if (nsrxx != null) {
            if ("A".equals(nsrxx.getString("billstatus"))) {
                operationStatus = "edit";
            }
            sbbid = nsrxx.getLong("id");
            sbbbillno = nsrxx.getString("billno");
        } else {
            operationStatus = "edit";
            sbbid = DeclareServiceHelper.generateSBBId((String)TOTF_WHSYJS_DECLARE_QUERY);
            sbbbillno = DeclareServiceHelper.generateSBBNo((String)TOTF_WHSYJS_DECLARE_QUERY);
            refresh = true;
        }
        this.getModel().setValue("declarenumber", (Object)sbbbillno);
        this.getModel().setValue(DECLAREDATE, (Object)declaredate);
        this.getPageCache().put("sbbid", String.valueOf(sbbid));
        this.getPageCache().put("sbbbillno", sbbbillno);
        this.getPageCache().put(DECLAREDATE, DateUtils.format((Date)declaredate));
        this.getPageCache().put("skssqq", DateUtils.format((Date)startdate));
        this.getPageCache().put("skssqz", DateUtils.format((Date)enddate));
        this.getPageCache().put(TAXOFFICE, taxoffice.getString("id"));
        this.getPageCache().put("operationStatus", operationStatus);
        this.getPageCache().put("refresh", String.valueOf(refresh));
        this.showInnerPage(refresh, operationStatus);
    }

    protected void setRequestModel(DeclareRequestModel requestModel) {
        requestModel.addBusinessValue(DECLAREDATE, this.getPageCache().get(DECLAREDATE));
        requestModel.addBusinessValue("billno", this.getPageCache().get("sbbbillno"));
        requestModel.addBusinessValue("taxoffice", this.getPageCache().get(TAXOFFICE));
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put(DECLAREDATE, this.getPageCache().get(DECLAREDATE));
        extendParams.put("billno", this.getPageCache().get("sbbbillno"));
        extendParams.put("taxauthority", this.getPageCache().get(TAXOFFICE));
        requestModel.setExtendParams(extendParams);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String entity = this.getView().getFormShowParameter().getFormId();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if ("bar_edit".equals(key)) {
            if (org != null && StringUtil.isNotBlank((CharSequence)entity) && WhsyjsfDeclarePlugin.checkPermission((Long)org.getLong("id"), (String)"0AQ3YJ2LET+U", (String)entity)) {
                super.beforeItemClick(evt);
            }
        } else {
            super.beforeItemClick(evt);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_reset".equals(key)) {
            return;
        }
        super.itemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (this.getModel().getValue(DECLAREDATE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u65e5\u671f\u3002", (String)"WhsyjsfDeclarePlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("recalc".equals(key)) {
            this.reset();
        }
    }

    protected void doInLoadFromHyperLinkClick(DynamicObject nsrxx) {
        this.setTaxoffice(nsrxx.get("billno"));
    }

    private void setTaxoffice(Object billno) {
        DynamicObject query = BusinessDataServiceHelper.loadSingle((String)"totf_tysb_declare_main", (String)"taxauthority", (QFilter[])new QFilter[]{new QFilter("billno", "=", billno)});
        if (query != null) {
            DynamicObject taxoffice = (DynamicObject)query.get("taxauthority");
            this.getModel().setValue(TAXOFFICE, (Object)taxoffice.getString("id"));
            this.getPageCache().put(TAXOFFICE, taxoffice.getString("id"));
        }
    }

    static {
        controlListeners.add((IControlListener)new WhsyjsfOrgListener());
        controlListeners.add(new WhsyjsfSbrqListener());
    }
}

