/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.declare.list;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;

public class CjrjybzjMultiQueryListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    private static final String SEPARATOR = System.getProperty("line.separator");

    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
    }

    public String getModelNumber() {
        return MultiTableEnum.TSCOO1.getModel();
    }

    protected List<String> getTemplateTypeList() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("totf_cjrjybzj");
        return types;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if ("new".equals(evt.getOperateKey())) {
            String querytype = this.getQuerytype(evt.getOperateKey());
            HashMap<String, String> custom = new HashMap<String, String>(16);
            custom.put("type", querytype);
            this.showDeclarePage(querytype, custom, null, null);
        }
        if ("viewflowchart".equals(evt.getOperateKey()) || "import".equals(evt.getOperateKey()) || "export".equals(evt.getOperateKey())) {
            super.afterDoOperation(evt);
        }
        if ("submit".equals(evt.getOperateKey()) || "unsubmit".equals(evt.getOperateKey()) || "audit".equals(evt.getOperateKey()) || "unaudit".equals(evt.getOperateKey()) || "pay".equals(evt.getOperateKey()) || "apply".equals(evt.getOperateKey()) || "cancelapply".equals(evt.getOperateKey()) || "cancelpay".equals(evt.getOperateKey()) || "rectify".equals(evt.getOperateKey())) {
            super.afterDoOperation(evt);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            return;
        }
        if ("riskcontent".equals(args.getFieldName())) {
            DeclareUtils.showRiskDialog((String)currentSelectedRowInfo.getPrimaryKeyValue().toString(), (IFormView)this.getView());
        } else {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tpo_declare_main_tsc");
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("entryid", object.getString("id"));
            customParams.put("billno", object.getString("billno"));
            customParams.put("orgid", object.getDynamicObject("org").getString("id"));
            customParams.put("orgname", object.getDynamicObject("org").getString("name"));
            Date skssqq = object.getDate("skssqq");
            Date skssqz = object.getDate("skssqz");
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", object.getDate("modifytime"));
            String dataType = object.getString("datatype");
            customParams.put("datatype", dataType);
            this.setExtendCustomParams(customParams, object);
            String type = object.getString("templatetype.number");
            this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, null, object);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection list = billList.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tpo_declare_main_tsc", (String)MetadataUtil.getAllFieldToQuery((String)"tpo_declare_main_tsc"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
            this.pay(billList, declares, payDate);
        } else if (actionId.equals("import")) {
            super.closedCallBack(closedCallBackEvent);
        }
    }

    protected boolean setCustomCheckInfo(AfterDoOperationEventArgs evt) {
        OperationResult opResult = evt.getOperationResult();
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo != null && allErrorOrValidateInfo.size() > 0) {
            return false;
        }
        String msg = opResult.getMessage();
        this.getView().invokeOperation("refresh");
        if (msg != null) {
            String[] messages = msg.split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(msg);
                this.getView().showOperationResult(operationResult);
            }
            return false;
        }
        return true;
    }

    private void pay(BillList billlist, DynamicObject[] declares, Date payDate) {
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            for (DynamicObject declare : declares) {
                declare.set("paystatus", (Object)"paid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"0");
                declare.set("paydate", (Object)payDate);
                declare.set("payer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[0]));
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"CjrjybzjMultiQueryListPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                billlist.refresh();
                this.calcElement(modifyDynamicObjects, "pay");
            }
        }
    }

    private void calcElement(List<DynamicObject> modifyDynamicObjects, String act) {
        for (DynamicObject modifyob : modifyDynamicObjects) {
            if ("cancelpay".equals(act)) {
                Date paydate = DateUtils.stringToDate((String)this.getPageCache().get(modifyob.getString("id")));
                DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)paydate, (String)DeclareMQType.PAY.name(), (String)act);
                continue;
            }
            DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)CjrjybzjMultiQueryListPlugin.getPayDate(modifyob), (String)DeclareMQType.PAY.name(), (String)act);
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }
}

