/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.declare.listener;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.declare.handler.IDeclareHandler;
import kd.taxc.bdtaxr.common.declare.listener.impl.OrgListener;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.totf.business.zerodeclare.ZeroDeclareHelper;

public class GhjfslisOrgListener
extends OrgListener {
    private String templateType;

    public GhjfslisOrgListener(String templateType) {
        this.templateType = templateType;
    }

    public boolean checkOrg(IFormView view, IPageCache pageCache, IDataModel model, Long orgId, String appId, String categoryType) {
        TaxResult licenseResult = TaxcLicenseCheckDataServiceHelper.check((Long)orgId, (String)"totf");
        boolean hasLicense = Boolean.FALSE.equals(licenseResult.getData());
        if (!hasLicense) {
            boolean success;
            Date declaredate = (Date)model.getValue("declaredate");
            if (declaredate == null) {
                declaredate = new Date();
            }
            if (!(success = ZeroDeclareHelper.checkOrgLicenseAndZeroDeclare(view, this.templateType, orgId, declaredate))) {
                model.setValue("org", null);
                pageCache.remove("orgid");
                return true;
            }
        }
        return OrgCheckUtil.withoutLicenseCheck((IFormView)view, (String)String.valueOf(orgId), (String)appId, (String)categoryType);
    }

    public void afterPropertyChanged(PropertyChangedArgs args, IDeclareHandler handler, IFormView view, IPageCache pageCache, IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        try {
            if (org == null) {
                model.setValue("taxoffice", null);
            } else {
                TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
                if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                    DynamicObject taxMain = (DynamicObject)result.getData();
                    String oldTaxoffice = pageCache.get("taxauthority");
                    model.setValue("taxoffice", (Object)taxMain.getLong("taxoffice.id"));
                    String newTaxoffice = taxMain.getString("taxoffice.id");
                    pageCache.put("taxauthority", newTaxoffice);
                    if (Objects.equals(newTaxoffice, oldTaxoffice)) {
                        handler.afterPropertyChanged(args, "propertyChanged");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

