/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.totf.common.enums.RuleTypeEnum;

public abstract class AbstractRuleCollectTreeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final String PRIVATE_STR = "private";
    private static final String publicStr = "public";
    private static final String copy = "copy";
    private static final String allocationSharePlan = "allocationshareplan";
    private static final String TOTF_ALL_RULE_CONFIG = "totf_all_rule_config";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        Long parent = this.getParentTreeId();
        this.getTreeModel().getTreeFilter().add(new QFilter("parent", "=", (Object)parent));
        ((TreeListModel)this.getTreeModel()).getQueryParas().put("order", "id asc");
        TreeNode root = this.getTreeModel().getRoot();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractRuleCollectTreeListPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
        super.refreshNode(e);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams.get("orgid")) {
            return;
        }
        List commonFilters = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            filterColumn.setDefaultValues(new Object[]{customParams.get("orgid")});
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        OrgUtils.listFilterByIsTaxpayerAndEnableAndAudit((BeforeFilterF7SelectEvent)args);
    }

    public void setFilter(SetFilterEvent e) {
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
        if (root.getId().equals(currentNode.getId())) {
            Long parent = this.getParentTreeId();
            QFilter qFilter = new QFilter("group.parent", "=", (Object)parent);
            e.getQFilters().add(qFilter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(String.valueOf(this.getTreeModel().getCurrentNodeId()));
        List listColumns = args.getListColumns();
        if (!"2015939841581248512".equals(currentNode.getId())) {
            listColumns.removeIf(column -> "zszm.projectname".equals(column.getListFieldKey()));
        }
        args.setListColumns(listColumns);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] primaryKeyValues;
        super.beforeDoOperation(args);
        String operationKey = ((FormOperate)args.getSource()).getOperateKey();
        if (allocationSharePlan.equals(operationKey)) {
            primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)TOTF_ALL_RULE_CONFIG, (String)"org,ruletype,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
            boolean hasDisable = ruleCollection.stream().anyMatch(s -> "0".equals(s.getString("enable")));
            if (hasDisable) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u542f\u7528\u518d\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u3002", (String)"AbstractRuleCollectTreeListPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long orgCount = ruleCollection.stream().map(s -> s.getLong("org")).distinct().count();
            if (orgCount > 1L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u521b\u5efa\u7ec4\u7ec7\u7684\u53ef\u5206\u914d\u89c4\u5219\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRuleCollectTreeListPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasPrivateRule = ruleCollection.stream().anyMatch(s -> PRIVATE_STR.equals(s.getString("ruletype")));
            if (hasPrivateRule) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u7528\u89c4\u5219\u4e0d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractRuleCollectTreeListPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (PRIVATE_STR.equals(operationKey) || publicStr.equals(operationKey)) {
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
            if (root.getId().equals(currentNode.getId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7ec4\u5b50\u8282\u70b9\u3002", (String)"AbstractRuleCollectTreeListPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (copy.equals(operationKey) && (primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AbstractRuleCollectTreeListPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String formId;
        BaseShowParameter baseShowParameter;
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        if (allocationSharePlan.equals(operationKey)) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)this.sharePlanFormId(), (boolean)true);
            listShowParameter.setCustomParam("ruleidarray", Arrays.asList(primaryKeyValues));
            String billFormId = ((ListView)this.getView()).getBillFormId();
            DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)TOTF_ALL_RULE_CONFIG, (String)"org,ruletype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
            QFilter createOrgFilter = new QFilter("createorg", "=", (Object)((DynamicObject)ruleCollection.get(0)).getLong("org"));
            listShowParameter.getListFilterParameter().setFilter(createOrgFilter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, allocationSharePlan));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (PRIVATE_STR.equals(operationKey) || publicStr.equals(operationKey)) {
            baseShowParameter = new BaseShowParameter();
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            RuleTypeEnum nodeEnum = RuleTypeEnum.getStrategyByGroupId(Long.parseLong(currentNodeId));
            formId = nodeEnum.getEntry();
            baseShowParameter.setFormId(formId);
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
            Map customParams = baseShowParameter.getShowParameter().getCustomParams();
            customParams.put("ruletype", operationKey);
            customParams.put("orgid", String.valueOf(this.getCreateOrgId()));
            baseShowParameter.setCustomParam("groupId", (Object)currentNodeId);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        } else if (copy.equals(operationKey)) {
            baseShowParameter = new BaseShowParameter();
            DynamicObject ruleObject = this.getSelectBill(Long.parseLong(primaryKeyValues[0].toString()));
            String ruletype = ruleObject.getString("ruletype");
            formId = RuleTypeEnum.getStrategyByGroupId(ruleObject.getDynamicObject("group").getLong("id")).getEntry();
            String orgid = ruleObject.getDynamicObject("org").getString("id");
            if (((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(orgid)).getData()).booleanValue()) {
                baseShowParameter.getShowParameter().getCustomParams().put("orgid", orgid);
            }
            baseShowParameter.setFormId(formId);
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
            baseShowParameter.getShowParameter().getCustomParams().put("iscopy", Boolean.TRUE);
            baseShowParameter.getShowParameter().getCustomParams().put("isCopyRelateEntity", Boolean.FALSE);
            baseShowParameter.getShowParameter().getCustomParams().put("CopyEmptyRow", Boolean.FALSE);
            baseShowParameter.getShowParameter().getCustomParams().put("ruletype", ruletype);
            baseShowParameter.setPkId(primaryKeyValues[0]);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
        if ("downloadrule".equals(operationKey)) {
            boolean valiableOrg;
            ArrayList ruletypeList;
            ArrayList orgList = this.getControlFilters().getFilters().get("org.id") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("org.id")).getValue();
            List list = ruletypeList = this.getControlFilters().getFilters().get("ruletype") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("ruletype")).getValue();
            if (kd.bos.util.CollectionUtils.isEmpty(orgList) || orgList.size() != 1 || StringUtil.isBlank((CharSequence)String.valueOf(orgList.get(0)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u8bf7\u9009\u4e2d\u5355\u4e2a\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AbstractRuleCollectTreeListPlugin_9", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            if (kd.bos.util.CollectionUtils.isEmpty(ruletypeList) || ruletypeList.size() != 1 || StringUtil.isBlank((CharSequence)String.valueOf(ruletypeList.get(0)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u7684\u89c4\u5219\u7c7b\u578b\u3002", (String)"AbstractRuleCollectTreeListPlugin_10", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            String org = String.valueOf(orgList.get(0));
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(org));
            boolean bl = valiableOrg = result.isSuccess() && result.getData() != null;
            if (!valiableOrg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u672a\u5ba1\u6838\u6216\u4f7f\u7528\u72b6\u6001\u4e3a\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AbstractRuleCollectTreeListPlugin_11", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            String ruleType = String.valueOf(ruletypeList.get(0));
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tpo_rule", (boolean)true);
            listShowParameter.setCustomParam("org", (Object)org);
            listShowParameter.setCustomParam("ruleType", (Object)ruleType);
            listShowParameter.setCustomParam("parent", this.getParentRootIds());
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operationKey));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        if ("batchdownloadrule".equals(operationKey)) {
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((String)"tpo", (String)"tpo_rule", (String)"47150e89000000ac");
            if (!allPermOrgs.hasAllOrgPerm()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u9884\u7f6e\u89c4\u5219\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractRuleCollectTreeListPlugin_12", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setBillFormId("tpo_rule");
            showParameter.setCustomParam("operateSource", (Object)"downloadFromBusiness");
            showParameter.setCustomParam("operateType", (Object)operationKey);
            showParameter.setCustomParam("org", (Object)RequestContext.get().getOrgId());
            showParameter.setCustomParam("parent", this.getParentRootIds());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    protected List<Long> getParentRootIds() {
        return new ArrayList<Long>(0);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (allocationSharePlan.equals(closedCallBackEvent.getActionId())) {
            DynamicObjectCollection ruleentity;
            Object returnData = closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            BillList list = (BillList)this.getControl("billlistap");
            Object[] ruleIds = list.getSelectedRows().getPrimaryKeyValues();
            List collectRuleIds = Arrays.stream(ruleIds).map(s -> Long.parseLong(s.toString())).collect(Collectors.toList());
            List sharePlanSelectedRow = (List)closedCallBackEvent.getReturnData();
            List sharePlanidList = sharePlanSelectedRow.stream().map(s -> s.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] sharePlanArray = BusinessDataServiceHelper.load((Object[])sharePlanidList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.sharePlanFormId()));
            StringBuilder errorMeg = new StringBuilder();
            for (DynamicObject dynamicObject : sharePlanArray) {
                ruleentity = dynamicObject.getDynamicObjectCollection("ruleentity");
                for (DynamicObject rule : ruleentity) {
                    long existsRuleId = rule.getDynamicObject("rule").getLong("id");
                    if (!collectRuleIds.contains(existsRuleId)) continue;
                    errorMeg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u89c4\u5219\u540d\u79f0\u4e3a %1$s \u7684\u89c4\u5219, \u5df2\u5b58\u5728 %2$s \u5171\u4eab\u65b9\u6848\u4e2d\u3002\n", (String)"AbstractRuleCollectTreeListPlugin_6", (String)"taxc-totf", (Object[])new Object[0]), rule.getDynamicObject("rule").getString("name"), dynamicObject.getString("name")));
                    collectRuleIds.removeIf(s -> s == existsRuleId);
                }
            }
            if (StringUtil.isNotEmpty((CharSequence)errorMeg)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u5931\u8d25\u3002", (String)"AbstractRuleCollectTreeListPlugin_7", (String)"taxc-totf", (Object[])new Object[0]), errorMeg.toString(), MessageTypes.Default);
            }
            for (DynamicObject sharePlan : sharePlanArray) {
                ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
                for (Long ruleId : collectRuleIds) {
                    DynamicObject entryObject = ruleentity.addNew();
                    entryObject.set("rule", (Object)ruleId);
                    String string = Optional.ofNullable(this.getSelectBill(ruleId)).map(s -> s.getDynamicObject("group")).map(s -> s.getString("id")).orElseGet(() -> "");
                }
            }
            SaveServiceHelper.save((DynamicObject[])sharePlanArray);
            if (StringUtil.isBlank((CharSequence)errorMeg)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"AbstractRuleCollectTreeListPlugin_8", (String)"taxc-totf", (Object[])new Object[0]));
            }
        }
        if ("downloadrule".equals(closedCallBackEvent.getActionId())) {
            ArrayList orgList = this.getControlFilters().getFilters().get("org.id") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("org.id")).getValue();
            ArrayList ruletypeList = this.getControlFilters().getFilters().get("ruletype") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("ruletype")).getValue();
            Object returnData = closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty(orgList) || CollectionUtils.isEmpty(ruletypeList) || null == returnData) {
                return;
            }
            Long org = Long.parseLong(String.valueOf(orgList.get(0)));
            String ruleType = String.valueOf(ruletypeList.get(0));
            List sharePlanSelectedRow = (List)returnData;
            List ruleList = sharePlanSelectedRow.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
            TaxResult downloadResult = ServiceInvokeUtils.invokeTaxcTpoService(Map.class, (String)"PresetRuleService", (String)"downloadRule", (Object[])new Object[]{ruleList, org, ruleType});
            if (downloadResult != null) {
                this.getView().showMessage((String)downloadResult.getData());
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject ruleObject = this.getSelectBill(pkid);
        Long groupId = ruleObject.getDynamicObject("group").getLong("id");
        String formId = RuleTypeEnum.getStrategyByGroupId(groupId).getEntry();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)pkid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("groupId", (Object)groupId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject getSelectBill(Long pkid) {
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)TOTF_ALL_RULE_CONFIG);
    }

    public Long getCreateOrgId() {
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        Long orgId = selectedMainOrgIds.size() != 1 ? Long.valueOf(RequestContext.get().getOrgId()) : (Long)selectedMainOrgIds.get(0);
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
            if (orgId.compareTo(PermissionUtils.getDefaultOrgId()) == 0) {
                return 0L;
            }
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)PermissionUtils.getDefaultOrgId()).getData()).booleanValue()) {
                return 0L;
            }
            orgId = PermissionUtils.getDefaultOrgId();
        }
        return orgId;
    }

    protected abstract String sharePlanFormId();

    protected abstract Long getParentTreeId();
}

