/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.rule.sharingplan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.totf.common.enums.TotfRuleQueryEnum;

public class RuleSelectPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String CURRENT_TAB = "current_tab";
    private static final String TAB = "tab";
    private static final String WATER_FUND_NOTAX = "sljjbhssr";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void initialize() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        Object shareMeType = parentView.getFormShowParameter().getCustomParams().get("shareMeType");
        JSONObject org = (JSONObject)customParams.get("org");
        QFilter q1 = new QFilter("org", "=", (Object)(org == null ? Long.valueOf(0L) : org.getLong("id")));
        QFilter q2 = new QFilter("ruletype", "=", (Object)"public");
        QFilter q3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        for (TotfRuleQueryEnum totfRuleQueryEnum : TotfRuleQueryEnum.values()) {
            if (!shareMeType.equals(totfRuleQueryEnum.getCode())) continue;
            this.setFilter(totfRuleQueryEnum.getName() + "list", q1, q2, q3);
        }
        this.setShareTypeVisible();
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("orgid", RequestContext.get().getOrgId());
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        Object shareMeType = parentView.getFormShowParameter().getCustomParams().get("shareMeType");
        JSONArray ruleentity = (JSONArray)customParams.get("ruleentity");
        for (TotfRuleQueryEnum totfRuleQueryEnum : TotfRuleQueryEnum.values()) {
            if (!shareMeType.equals(totfRuleQueryEnum.getCode())) continue;
            this.selectRules(ruleentity, totfRuleQueryEnum.getName() + "list", totfRuleQueryEnum.getName());
        }
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.activeTab(customParams.get(CURRENT_TAB).toString());
        this.setShareTypeVisible();
    }

    private void selectRules(JSONArray ruleentity, String billList, String type) {
        BillList list = (BillList)this.getControl(billList);
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (int i = 0; i < ruleentity.size(); ++i) {
            JSONObject jsonObject = ruleentity.getJSONObject(i);
            String type1 = jsonObject.getString("type");
            if (!type1.equals(type)) continue;
            Long ruleid = jsonObject.getLong("ruleid");
            listSelectedRowCollection.add((Object)new ListSelectedRow((Object)ruleid));
        }
        list.putSelectedRows(listSelectedRowCollection);
    }

    private void setFilter(String billList, QFilter ... filters) {
        BillList list = (BillList)this.getControl(billList);
        ListFilterParameter filterParameter = new ListFilterParameter();
        for (QFilter filter : filters) {
            filterParameter.setFilter(filter);
        }
        list.setFilterParameter((FilterParameter)filterParameter);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        Object shareMeType = this.getView().getParentView().getFormShowParameter().getCustomParams().get("shareMeType");
        if (source instanceof Button && "btnok".equals(((Button)source).getKey())) {
            HashMap<String, Object[]> result = new HashMap<String, Object[]>();
            boolean lengthFlag = false;
            for (TotfRuleQueryEnum totfRuleQueryEnum : TotfRuleQueryEnum.values()) {
                if (!shareMeType.equals(totfRuleQueryEnum.getCode())) continue;
                BillList list = (BillList)this.getControl(totfRuleQueryEnum.getName() + "list");
                ListSelectedRowCollection rows = list.getSelectedRows();
                Object[] ids = rows.getPrimaryKeyValues();
                result.put(totfRuleQueryEnum.getName(), ids);
                if (ids.length <= 0) continue;
                lengthFlag = true;
            }
            if (!lengthFlag) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u89c4\u5219\u3002", (String)"RuleSelectPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
        this.setShareTypeVisible();
    }

    private void setShareTypeVisible() {
        Object shareMeType = this.getView().getParentView().getFormShowParameter().getCustomParams().get("shareMeType");
        for (TotfRuleQueryEnum totfRuleQueryEnum : TotfRuleQueryEnum.values()) {
            if (shareMeType.equals(totfRuleQueryEnum.getCode())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{totfRuleQueryEnum.getName() + TAB});
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{totfRuleQueryEnum.getName() + TAB});
        }
    }
}

