/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.rule.sharingplan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.shareplan.AbstractSharePlanFormPlugin;
import kd.taxc.totf.common.enums.RuleTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class TotfSharePlanFormPlugin
extends AbstractSharePlanFormPlugin
implements Consumer<BeforeF7ViewDetailEvent> {
    private static final String CREATEPLAN_KEY = "createplan";
    private String SEPARATOR = System.getProperty("line.separator");

    protected void initData() {
        super.initData();
        this.planFieldMap.put("createorg", "carcreateorg");
    }

    protected void planAdd(AfterDoOperationEventArgs args) {
        this.getPageCache().put(CREATEPLAN_KEY, "false");
        super.planAdd(args);
        this.getPageCache().put(CREATEPLAN_KEY, "true");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit rule = (BasedataEdit)this.getView().getControl("rule");
        BasedataEdit createorg = (BasedataEdit)this.getView().getControl("createorg");
        rule.addBeforeF7ViewDetailListener(this::accept);
        createorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected DynamicObject[] loadPlanDatas() {
        List orgIds = new ArrayList(10);
        TaxResult result = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"40");
        if (result != null && result.isSuccess()) {
            orgIds = (List)result.getData();
        }
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", orgIds)};
        return BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)this.getSharePlanEntityName(), (String)"id", (QFilter[])filters).stream().map(s -> s.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName()));
    }

    protected DynamicObject loadPlanData(Long id) {
        return id > 0L ? BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getSharePlanEntityName()) : null;
    }

    protected String getSharePlanEntityName() {
        return "totf_shareplan";
    }

    protected void createNewPlan(int selectRow) {
        TaxResult orgIdList;
        super.createNewPlan(selectRow);
        Long createOrg = null;
        TaxResult result = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"40");
        if (null != result && ((List)result.getData()).size() > 0 && (orgIdList = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds((List)((List)result.getData()))).isSuccess() && ((List)orgIdList.getData()).size() > 0) {
            createOrg = ((DynamicObject)((List)orgIdList.getData()).get(0)).getLong("taxorg.id");
        }
        this.getModel().setValue("createorg", createOrg);
    }

    protected void setRuleFilter(BeforeF7SelectEvent event) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TotfSharePlanFormPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObjectCollection rules = this.getModel().getEntryEntity("ruleentity");
        List ruleIds = rules.stream().filter(o -> o.getPkValue() != null && o.getDynamicObject("rule") != null).map(v -> v.getLong("rule.id")).collect(Collectors.toList());
        QFilter ruleIdsFilter = new QFilter("id", "not in", ruleIds);
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"public");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter groupIdFilter = new QFilter("group.parent", "=", (Object)2015937644915316736L);
        event.getCustomQFilters().add(orgFilter);
        event.getCustomQFilters().add(ruletypeFilter);
        event.getCustomQFilters().add(ruleIdsFilter);
        event.getCustomQFilters().add(enableFilter);
        event.getCustomQFilters().add(groupIdFilter);
        QFilter longNumberfilter = new QFilter("longnumber", "like", (Object)"tysbtzgzpz%");
        ((ListShowParameter)event.getFormShowParameter()).getTreeFilterParameter().setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{longNumberfilter}));
        ((ListShowParameter)event.getFormShowParameter()).setShowApproved(false);
    }

    protected void afterRestPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity("planentity", startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            if (planentities[0].getLong("id") == 0L) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"createorg"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"createorg"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save")) {
            if (!this.beforeSavePlan()) {
                args.setCancel(true);
                return;
            }
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
            if (createorg != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)createorg.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TotfSharePlanFormPlugin_26", (String)"taxc-totf", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String planName = ((DynamicObject)this.getModel().getEntryEntity("planentity").get(this.getSelectRows())).getString("carname");
            DynamicObjectCollection orgentiy = this.getModel().getEntryEntity("orgentity");
            List org = orgentiy.stream().filter(o -> null != o.getDynamicObject("org")).collect(Collectors.toList());
            if (org.isEmpty()) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"TotfSharePlanFormPlugin_4", (String)"taxc-totf", (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg);
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection ruleentity = this.getModel().getEntryEntity("ruleentity");
            List rule = ruleentity.stream().filter(o -> null != o.getDynamicObject("rule")).collect(Collectors.toList());
            if (rule.isEmpty()) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u5171\u4eab\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5171\u4eab\u89c4\u5219\u3002", (String)"TotfSharePlanFormPlugin_5", (String)"taxc-totf", (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg);
                args.setCancel(true);
                return;
            }
        }
        if (args.getSource() instanceof DeleteEntry && "deleteorg".equals((deleteEntry = (DeleteEntry)args.getSource()).getOperateKey())) {
            args.setCancel(true);
            EntryGrid entrye = (EntryGrid)this.getControl("orgentity");
            entrye.getSelectRows();
            String orgName = this.getModel().getEntryRowEntity("orgentity", entrye.getSelectRows()[0]).getString("orgid.name");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgDeleteConform", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TotfSharePlanFormPlugin_6", (String)"taxc-totf", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"TotfSharePlanFormPlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u4ece\u201c%2$s\u201d\u65b9\u6848\u7684\u5171\u4eab\u8303\u56f4\u4e2d\u5254\u9664\uff1f", (String)"TotfSharePlanFormPlugin_8", (String)"taxc-totf", (Object[])new Object[0]), orgName, this.getModel().getValue("planname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        super.beforeDoOperation(args);
    }

    protected boolean beforeSavePlan() {
        DynamicObjectCollection planentityCollection = this.getModel().getEntryEntity("planentity");
        int planCount = planentityCollection.getRowCount();
        if (planCount == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"TotfSharePlanFormPlugin_22", (String)"taxc-totf", (Object[])new Object[0]));
            return false;
        }
        HashSet<String> planMap = new HashSet<String>(planentityCollection.size());
        for (int row = 0; row < planentityCollection.size(); ++row) {
            String planName = ((DynamicObject)planentityCollection.get(row)).getString("carname");
            String planCreateOrg = ((DynamicObject)planentityCollection.get(row)).getDynamicObject("carcreateorg").getString("id");
            String uniqueFields = planName + planCreateOrg;
            if (planMap.contains(uniqueFields)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\uff08%s\uff09\u91cd\u590d\uff0c\u8bf7\u8bbe\u7f6e\u4e0d\u540c\u7684\u65b9\u6848\u540d\u79f0\u3002", (String)"TotfSharePlanFormPlugin_21", (String)"taxc-totf", (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg);
                return false;
            }
            planMap.add(uniqueFields);
        }
        return true;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String resultMsg;
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"bar_close") && StringUtil.isNotBlank((CharSequence)(resultMsg = this.checkChangeData()))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TotfSharePlanFormPlugin_11", (String)"taxc-totf", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TotfSharePlanFormPlugin_12", (String)"taxc-totf", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TotfSharePlanFormPlugin_13", (String)"taxc-totf", (Object[])new Object[0]);
            this.getView().showConfirm(msg, resultMsg, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        String userName = RequestContext.get().getUserName();
        Object number = this.getModel().getValue("number");
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"plandel")) {
            this.getPageCache().put(CREATEPLAN_KEY, "false");
            if (this.getModel().getValue("createorg") != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7528\u6237 %1$s \u5220\u9664\u4e86\u7f16\u7801\u4e3a %2$s \u521b\u5efa\u7ec4\u7ec7\u4e3a %3$s \u7684 %4$s \u5171\u4eab\u65b9\u6848", (String)"TotfSharePlanFormPlugin_9", (String)"taxc-totf", (Object[])new Object[0]), userName, number, createorg.getString("name"), name.getLocaleValue());
                OperatorDialogUtils.operateDialog((String)"qtsf_fsstysbb", (String)this.getView().getFormShowParameter().getFormId(), (String)ResManager.loadKDString((String)"\u5220\u9664\u65b9\u6848", (String)"TotfSharePlanFormPlugin_24", (String)"taxc-totf", (Object[])new Object[0]), (String)msg);
            }
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save")) {
            OperationResult result = args.getOperationResult();
            if (result.isSuccess()) {
                this.getPageCache().put(CREATEPLAN_KEY, "false");
            }
            if (this.getModel().getValue("createorg") != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7528\u6237 %1$s \u7f16\u8f91\u4fdd\u5b58\u4e86\u7f16\u7801\u4e3a %2$s \u521b\u5efa\u7ec4\u7ec7\u4e3a %3$s \u7684 %4$s \u5171\u4eab\u65b9\u6848", (String)"TotfSharePlanFormPlugin_10", (String)"taxc-totf", (Object[])new Object[0]), userName, number, createorg.getString("name"), name.getLocaleValue());
                OperatorDialogUtils.operateDialog((String)"qtsf_fsstysbb", (String)this.getView().getFormShowParameter().getFormId(), (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TotfSharePlanFormPlugin_25", (String)"taxc-totf", (Object[])new Object[0]), (String)msg);
            }
        }
        super.afterDoOperation(args);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"createorg")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("ruleentity");
                this.getModel().deleteEntryData("orgentity");
                this.getView().invokeOperation("ruleadd");
                this.getView().invokeOperation("orgadd");
                DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
                if (null == createorg) {
                    return;
                }
            } else {
                this.getPageCache().put(CREATEPLAN_KEY, "false");
                this.getModel().setValue("createorg", (Object)this.getPageCache().get("olddata"));
                this.getPageCache().put(CREATEPLAN_KEY, "true");
            }
        }
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"cardSwitch")) {
            this.getPageCache().put(CREATEPLAN_KEY, "false");
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"cardSwitch")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                String oldRow = this.getPageCache().get("oldRow");
                DynamicObjectCollection collection = this.getModel().getEntryEntity("planentity");
                DynamicObject oldObject = (DynamicObject)collection.get(Integer.parseInt(oldRow));
                DynamicObject planRow = this.loadPlanData(oldObject.getLong("id"));
                if (null != planRow) {
                    List ruleList = planRow.getDynamicObjectCollection("ruleentity").stream().filter(r -> null != r.getDynamicObject("rule") && "1".equals(r.getString("rule.enable"))).map(o -> o.getString("rule.id")).collect(Collectors.toList());
                    List orgList = planRow.getDynamicObjectCollection("orgentity").stream().map(o -> o.getString("org.id")).collect(Collectors.toList());
                    oldObject.set("olddata", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{planRow}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName())));
                    for (Map.Entry entry : this.planFieldMap.entrySet()) {
                        oldObject.set((String)entry.getValue(), planRow.get((String)entry.getKey()));
                    }
                    this.getModel().setEntryCurrentRowIndex("planentity", Integer.parseInt(oldRow));
                    this.getModel().deleteEntryData("ruleentity");
                    ruleList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow("ruleentity");
                        this.getModel().setValue("rule", (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getModel().deleteEntryData("orgentity");
                    orgList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow("orgentity");
                        this.getModel().setValue("org", (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getView().updateView("planentity");
                } else {
                    this.getModel().deleteEntryRow("planentity", Integer.parseInt(oldRow));
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get("newRow")));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get("oldRow")));
            }
            return;
        }
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String createplan;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("createorg".equals(key) && "true".equals(createplan = this.getPageCache().get(CREATEPLAN_KEY))) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (null == oldValue) {
                this.getPageCache().put("olddata", "");
            } else {
                this.getPageCache().put("olddata", "taxpayertype".equals(key) ? oldValue.toString() : ((DynamicObject)oldValue).getString("id"));
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
            this.showConfirmCallBack(confirmCallBacks);
        }
    }

    public void accept(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        beforeF7ViewDetailEvent.setCancel(true);
        Object pkId = beforeF7ViewDetailEvent.getPkId();
        DynamicObject prepayRuleObject = QueryServiceHelper.queryOne((String)"totf_all_rule_config", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        String formId = RuleTypeEnum.getStrategyByGroupId(prepayRuleObject.getLong("group")).getEntry();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(pkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String checkChangeData() {
        DynamicObjectCollection planCollection = this.getModel().getEntryEntity("planentity");
        if (planCollection.isEmpty()) {
            return "";
        }
        DynamicObject newPlan = this.getPlanObject((DynamicObject)planCollection.get(this.getSelectRows()));
        StringBuilder msg = new StringBuilder();
        Long planId = (Long)this.getModel().getValue("id");
        if (planId == null || planId == 0L) {
            String name = ResManager.loadKDString((String)"\u65b0\u589e\u5171\u4eab\u65b9\u6848\u5747\u672a\u4fdd\u5b58\u3002", (String)"TotfSharePlanFormPlugin_14", (String)"taxc-totf", (Object[])new Object[0]);
            msg.append(name);
            return msg.toString();
        }
        DynamicObject[] planObject = this.loadPlanDatas();
        Map<String, DynamicObject> oldPlanMap = Arrays.stream(planObject).collect(Collectors.toMap(a -> a.getString("id"), b -> b));
        StringBuilder words = new StringBuilder();
        String newName = newPlan.getLocaleString("name").toString();
        String id = newPlan.getString("id");
        if (!oldPlanMap.containsKey(id)) {
            String name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u4e3a\u65b0\u589e\u65b9\u6848\u8fd8\u672a\u4fdd\u5b58\u3002", (String)"TotfSharePlanFormPlugin_15", (String)"taxc-totf", (Object[])new Object[0]), newName);
            if (StringUtil.isBlank((CharSequence)msg)) {
                msg.append(name);
            } else {
                msg.append(this.SEPARATOR).append(name);
            }
        } else {
            String oldAutoshar;
            String newAutoshar;
            String name;
            DynamicObject oldPlan = oldPlanMap.get(id);
            List ruleEntityList = oldPlan.getDynamicObjectCollection("ruleentity").stream().filter(r -> null != r.getDynamicObject("rule") && "1".equals(r.getString("rule.enable"))).map(o -> o.getString("rule.id")).collect(Collectors.toList());
            List orgEntityList = oldPlan.getDynamicObjectCollection("orgentity").stream().map(o -> o.getString("org_id")).collect(Collectors.toList());
            String oldName = oldPlan.getString("name");
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newPlan.getDynamicObjectCollection("ruleentity");
            ruleCol.stream().filter(r -> null != r.getDynamicObject("rule") && "1".equals(r.getString("rule.enable"))).forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = newPlan.getDynamicObjectCollection("orgentity");
            orgCol.stream().filter(r -> null != r.getDynamicObject("org")).forEach(orgRow -> orgList.add(orgRow.getDynamicObject("org").getString("id")));
            if (!newName.equals(oldName)) {
                name = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"TotfSharePlanFormPlugin_16", (String)"taxc-totf", (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (oldPlan.containsProperty("autoshar") && newPlan.containsProperty("autoshar") && !(newAutoshar = newPlan.getString("autoshar")).equals(oldAutoshar = oldPlan.getString("autoshar"))) {
                String name2 = ResManager.loadKDString((String)"\u81ea\u52a8\u5171\u4eab", (String)"TotfSharePlanFormPlugin_17", (String)"taxc-totf", (Object[])new Object[0]);
                words.append(name2).append(",");
            }
            if (!CollectionUtils.isEqualCollection(ruleList, ruleEntityList)) {
                name = ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u5361\u7247", (String)"TotfSharePlanFormPlugin_18", (String)"taxc-totf", (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(orgList, orgEntityList)) {
                name = ResManager.loadKDString((String)"\u88ab\u5171\u4eab\u8303\u56f4", (String)"TotfSharePlanFormPlugin_19", (String)"taxc-totf", (Object[])new Object[0]);
                words.append(name).append(",");
            }
            name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u53d8\u66f4\u5b57\u6bb5\uff1a", (String)"TotfSharePlanFormPlugin_20", (String)"taxc-totf", (Object[])new Object[0]), newName);
            if (StringUtil.isNotBlank((CharSequence)words)) {
                words.deleteCharAt(words.lastIndexOf(","));
                if (StringUtil.isBlank((CharSequence)msg)) {
                    msg.append(name).append((CharSequence)words);
                } else {
                    msg.append(this.SEPARATOR).append(name).append((CharSequence)words);
                }
            }
        }
        return msg.toString();
    }

    private void showConfirmCallBack(ConfirmCallBackListener confirmCallBacks) {
        DynamicObjectCollection ruleEntity = this.getModel().getEntryEntity("ruleentity");
        long rule = ruleEntity.stream().filter(r -> null != r.getDynamicObject("rule")).count();
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
        long org = orgEntity.stream().filter(r -> null != r.getDynamicObject("org")).count();
        if (rule == 0L && org == 0L) {
            return;
        }
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TotfSharePlanFormPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TotfSharePlanFormPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        String msg = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u201c%s\u201d\u5c06\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u53ca\u5171\u4eab\u9879\u76ee\uff0c\r\n\u60a8\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"TotfSharePlanFormPlugin_23", (String)"taxc-totf", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"TotfSharePlanFormPlugin_27", (String)"taxc-totf", (Object[])new Object[0]));
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }
}

