/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.sjjt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.totf.business.engine.impl.WaterFundAccrualDataService;
import kd.taxc.totf.business.engine.impl.WhsyjsfAccrualDataService;
import kd.taxc.totf.business.sjjt.DraftService;
import kd.taxc.totf.common.enums.TaxTypeEnum;

public class DraftEditPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    public static final String ACCOUNTORG = "accountorg";
    public static final String ORG = "org";
    public static final String TAXTYPE = "taxtype";
    public static final String DRAFTTYPE = "drafttype";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String ACCRUALPLAN = "accrualplan";
    public static final String ZSXM = "zsxm";
    public static final String ZSPM = "zspm";
    public static final String ENTRYENTITY = "entryentity";
    public static final String TAXSYSTEM = "taxsystem";
    public static final String TAXAREAGROUP = "taxareagroup";
    public static final String CHECKJTD = "checkjtd";
    public static final String BILLSTATUS = "billstatus";
    public static final String ACCOUNTSETTYPE = "accountsettype";
    public static final String PZHC = "pzhc";
    public static final String DELETEJTD = "deletejtd";
    public static final String NEWJTD = "newjtd";
    private Predicate<TaxTypeEnum> taxType024_enum = taxTypeEnum -> TaxTypeEnum.TAXTYPE_024 == taxTypeEnum;
    private Predicate<String> name024 = name -> Lists.newArrayList((Object[])new String[]{"yjfjs", "jcx", "kcs", "zsbl", "jmfe", "yjfe"}).contains(name);
    private Predicate<TaxTypeEnum> taxType026_enum = taxTypeEnum -> TaxTypeEnum.TAXTYPE_026 == taxTypeEnum;
    private Predicate<String> name026 = name -> Lists.newArrayList((Object[])new String[]{"yzsr", "jcx", "yjfe", "jmfe"}).contains(name);
    private Predicate<TaxTypeEnum> taxType023_034_036_enum = taxTypeEnum -> TaxTypeEnum.TAXTYPE_023 == taxTypeEnum || TaxTypeEnum.TAXTYPE_034 == taxTypeEnum || TaxTypeEnum.TAXTYPE_036 == taxTypeEnum;
    private Predicate<String> name023_034_036 = name -> Lists.newArrayList((Object[])new String[]{"jcx", "yssdl", "jmfe"}).contains(name);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountorgBase = (BasedataEdit)this.getView().getControl(ACCOUNTORG);
        accountorgBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit base = (BasedataEdit)this.getView().getControl(ORG);
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        String isChangingMainOrg = (String)this.getModel().getContextVariable("isChangingMainOrg");
        if (!"true".equals(isChangingMainOrg)) {
            Long orgId = RequestContext.get().getOrgId();
            this.doSetTaxOrg(orgId);
        } else {
            String newOrgValue = (String)this.getModel().getContextVariable("newOrgValue");
            if (StringUtil.isNotEmpty((CharSequence)newOrgValue)) {
                TaxResult existByOrgId = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)Long.parseLong(newOrgValue));
                if (((Boolean)existByOrgId.getData()).booleanValue()) {
                    this.getModel().setValue(ORG, (Object)Long.parseLong(newOrgValue));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"DraftEditPlugin_21", (String)"taxc-totf", (Object[])new Object[0]));
                    this.getModel().setValue(ORG, null);
                }
            }
        }
        this.doSetAccountOrg();
        TaxTypeEnum typeEnum = TaxTypeEnum.TAXTYPE_023;
        String draftType = typeEnum.getDraftType();
        String number = typeEnum.getNumber();
        this.getModel().setItemValueByNumber(TAXTYPE, number);
        this.getModel().setValue(DRAFTTYPE, (Object)draftType);
        this.getModel().setValue(SKSSQQ, (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
        this.getModel().setValue(TAXSYSTEM, (Object)AccrualConstant.TAXSYSTEM_CHINA);
        this.getModel().setValue(TAXAREAGROUP, (Object)AccrualConstant.TAXAREAGROUP_CHINA);
        this.getModel().setValue(ACCOUNTSETTYPE, (Object)"");
        this.getModel().setValue(BILLSTATUS, (Object)"A");
        this.getModel().setValue(PZHC, (Object)"0");
        this.doSetSkssqzAndResetSkssqq();
        this.loadDetailData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean generatebusinessdoc = this.getModel().getDataEntity().getBoolean("generatebusinessdoc");
        this.getView().setEnable(Boolean.valueOf(generatebusinessdoc), new String[]{CHECKJTD, DELETEJTD});
        String taxType = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAXTYPE)).map(s -> s.getString("number")).orElseGet(() -> null);
        this.doSetEntityList(taxType, () -> {});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        Object newValue = changeData.getNewValue();
        List<String> allColumns = DraftService.getAllColumns();
        String taxType = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAXTYPE)).map(s -> s.getString("number")).orElseGet(() -> null);
        if (ORG.equals(name)) {
            this.doSetAccountOrg();
            this.doSetSkssqzAndResetSkssqq();
            this.loadDetailData();
        } else if (TAXTYPE.equals(name)) {
            this.doSetSkssqzAndResetSkssqq();
            if (newValue == null) {
                this.getModel().setValue(SKSSQZ, null);
                this.getModel().setValue(DRAFTTYPE, null);
                Optional.ofNullable(this.getModel().getEntryEntity(ENTRYENTITY)).ifPresent(s -> this.doClearAndSet(null));
            } else {
                String number = ((DynamicObject)newValue).getString("number");
                this.doSetEntityList(number, () -> this.doClearAndSet(number));
                TaxTypeEnum taxTypeEnum = TaxTypeEnum.get(number);
                this.getModel().setValue(DRAFTTYPE, (Object)taxTypeEnum.getDraftType());
                this.loadDetailData();
            }
        } else if (SKSSQQ.equals(name)) {
            if (newValue == null) {
                this.getModel().setValue(SKSSQZ, null);
            } else {
                this.doSetSkssqzAndResetSkssqq();
                this.loadDetailData();
            }
        } else if (allColumns.contains(name)) {
            if (StringUtil.isBlank((CharSequence)taxType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u79cd\u7c7b\u578b\u3002", (String)"DraftEditPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
            }
            TaxTypeEnum taxTypeEnum = TaxTypeEnum.get(taxType);
            if (this.taxType024_enum.test(taxTypeEnum) && this.name024.test(name)) {
                this.taxType24Changed();
            } else if (this.taxType026_enum.test(taxTypeEnum) && this.name026.test(name)) {
                this.taxType26Changed();
            } else if (this.taxType023_034_036_enum.test(taxTypeEnum) && this.name023_034_036.test(name)) {
                this.taxType23_34_36Changed();
            }
        }
    }

    public void taxType23_34_36Changed() {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, 0);
        if (rowEntity != null) {
            BigDecimal ysx = rowEntity.getBigDecimal("ysx");
            BigDecimal jcx = rowEntity.getBigDecimal("jcx");
            BigDecimal flhdwse = rowEntity.getBigDecimal("flhdwse");
            BigDecimal yssdl = rowEntity.getBigDecimal("yssdl");
            BigDecimal sskcs = rowEntity.getBigDecimal("sskcs");
            BigDecimal jmfe = rowEntity.getBigDecimal("jmfe");
            BigDecimal yjfe = rowEntity.getBigDecimal("yjfe");
            BigDecimal jfyj = ysx.subtract(jcx).multiply(yssdl).setScale(2, 4);
            BigDecimal ynfe = jfyj.multiply(flhdwse).subtract(sskcs).setScale(2, 4);
            BigDecimal jtynfe = ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4);
            this.getModel().setValue("jfyj", (Object)jfyj, 0);
            this.getModel().setValue("ynfe", (Object)ynfe, 0);
            this.getModel().setValue("jtynfe", (Object)jtynfe, 0);
        }
    }

    public void taxType26Changed() {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, 0);
        if (rowEntity != null) {
            BigDecimal yzsr = rowEntity.getBigDecimal("yzsr");
            BigDecimal jcx = rowEntity.getBigDecimal("jcx");
            BigDecimal feerate = rowEntity.getBigDecimal("feerate");
            BigDecimal jmfe = rowEntity.getBigDecimal("jmfe");
            BigDecimal yjfe = rowEntity.getBigDecimal("yjfe");
            BigDecimal jfxse = yzsr.subtract(jcx).setScale(2, 4);
            BigDecimal ynfe = jfxse.multiply(feerate).setScale(2, 4);
            BigDecimal jtynfe = ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4);
            this.getModel().setValue("jfxse", (Object)jfxse, 0);
            this.getModel().setValue("ynfe", (Object)ynfe, 0);
            this.getModel().setValue("jtynfe", (Object)jtynfe, 0);
        }
    }

    public void taxType24Changed() {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, 0);
        if (rowEntity != null) {
            BigDecimal yjfjs = rowEntity.getBigDecimal("yjfjs");
            BigDecimal jcx = rowEntity.getBigDecimal("jcx");
            BigDecimal zsbz = rowEntity.getBigDecimal("zsbz");
            BigDecimal kcs = rowEntity.getBigDecimal("kcs");
            BigDecimal zsbl = rowEntity.getBigDecimal("zsbl");
            BigDecimal jfyj = yjfjs.subtract(jcx).setScale(2, 4);
            BigDecimal ynfe = jfyj.multiply(zsbz).subtract(kcs).multiply(zsbl).setScale(2, 4);
            BigDecimal jmfe = rowEntity.getBigDecimal("jmfe");
            BigDecimal yjfe = rowEntity.getBigDecimal("yjfe");
            BigDecimal jtynfe = ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4);
            this.getModel().setValue("jfyj", (Object)jfyj, 0);
            this.getModel().setValue("ynfe", (Object)ynfe, 0);
            this.getModel().setValue("jtynfe", (Object)jtynfe, 0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "recal".equals(operateKey) || NEWJTD.equals(operateKey)) {
            this.check(args, ORG, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DraftEditPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, ACCOUNTORG, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DraftEditPlugin_20", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, TAXTYPE, ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DraftEditPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, ACCRUALPLAN, ResManager.loadKDString((String)"\u8ba1\u7a0e\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DraftEditPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, SKSSQQ, ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DraftEditPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
            this.check(args, SKSSQZ, ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DraftEditPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
            ValidDataResultVo validDataResultVo = this.checkPeriodIsSame();
            if (!validDataResultVo.getSuccess()) {
                args.setCancel(true);
                this.getView().showErrorNotification(validDataResultVo.getMessage());
            }
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.getModel().setValue("jtynsesum", (Object)this.getModel().getEntryEntity(ENTRYENTITY).stream().map(s -> s.getBigDecimal("jtynfe")).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("recal".equals(operateKey)) {
            this.loadDetailData();
        } else if (CHECKJTD.equals(operateKey)) {
            String orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getString("id")).orElseGet(() -> "0");
            String taxsystemId = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAXSYSTEM)).map(s -> s.getString("id")).orElseGet(() -> "0");
            String number = (String)this.getModel().getValue("billno");
            this.openProvistonBillPage(orgId, taxsystemId, number);
        } else if ((NEWJTD.equals(operateKey) || DELETEJTD.equals(operateKey)) && args.getOperationResult().isSuccess()) {
            boolean generatebusinessdoc = this.getModel().getDataEntity().getBoolean("generatebusinessdoc");
            this.getView().setEnable(Boolean.valueOf(generatebusinessdoc), new String[]{CHECKJTD, DELETEJTD});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (ORG.equals(beforeF7SelectEvent.getProperty().getName())) {
            HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm()) {
                List orgList = permOrgResult.getHasPermOrgs();
                List customQFilters = beforeF7SelectEvent.getCustomQFilters();
                customQFilters.add(new QFilter("id", "in", (Object)orgList));
            }
            OrgUtils.addFilterByConditionBeforeF7Select((Object)beforeF7SelectEvent, (IFormView)this.getView(), null, null, null);
        } else if (ACCOUNTORG.equals(beforeF7SelectEvent.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                return;
            }
            Long taxOrg = org.getLong("id");
            Date startDate = (Date)this.getModel().getValue(SKSSQQ);
            Date endDate = (Date)this.getModel().getValue(SKSSQZ);
            List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            customQFilters.add(new QFilter("id", "in", (Object)orgRelations));
        }
    }

    private void doSetEntityList(String taxtype, Runnable runnable) {
        this.doVisible(taxtype);
        runnable.run();
        this.doTips(taxtype);
        this.doSetName(taxtype);
    }

    private void doTips(String taxtype) {
        if (taxtype == null) {
            return;
        }
        Map<String, String> tips = DraftService.getTips(taxtype);
        tips.forEach((k, v) -> this.createTip((String)k, (String)v));
    }

    private void doSetName(String taxtype) {
        if (taxtype == null) {
            return;
        }
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.get(taxtype);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (TaxTypeEnum.TAXTYPE_026 == taxTypeEnum) {
            grid.setColumnProperty("jcx", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u51cf\u9664\u989d", (String)"DraftEditPlugin_7", (String)"taxc-totf", (Object[])new Object[0])));
        } else {
            grid.setColumnProperty("jcx", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u51cf\u9664\u9879", (String)"DraftEditPlugin_8", (String)"taxc-totf", (Object[])new Object[0])));
        }
        if (TaxTypeEnum.TAXTYPE_023 == taxTypeEnum || TaxTypeEnum.TAXTYPE_034 == taxTypeEnum || TaxTypeEnum.TAXTYPE_036 == taxTypeEnum) {
            grid.setColumnProperty("jfyj", "header", (Object)ResManager.loadKDString((String)"\u8ba1\u7a0e\uff08\u8d39\uff09\u4f9d\u636e", (String)"DraftEditPlugin_10", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("ynfe", "header", (Object)ResManager.loadKDString((String)"\u5e94\u7eb3\u7a0e\uff08\u8d39\uff09\u989d", (String)"DraftEditPlugin_11", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("jmfe", "header", (Object)ResManager.loadKDString((String)"\u51cf\u514d\u7a0e\uff08\u8d39\uff09\u989d", (String)"DraftEditPlugin_12", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("yjfe", "header", (Object)ResManager.loadKDString((String)"\u5df2\u7f34\u7a0e\uff08\u8d39\uff09\u989d", (String)"DraftEditPlugin_13", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("jtynfe", "header", (Object)ResManager.loadKDString((String)"\u8ba1\u63d0\u5e94\u7eb3\u7a0e\uff08\u8d39\uff09\u989d", (String)"DraftEditPlugin_14", (String)"taxc-totf", (Object[])new Object[0]));
        } else {
            grid.setColumnProperty("jfyj", "header", (Object)ResManager.loadKDString((String)"\u8ba1\u8d39\u4f9d\u636e", (String)"DraftEditPlugin_15", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("ynfe", "header", (Object)ResManager.loadKDString((String)"\u5e94\u7eb3\u8d39\u989d", (String)"DraftEditPlugin_16", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("jmfe", "header", (Object)ResManager.loadKDString((String)"\u51cf\u514d\u8d39\u989d", (String)"DraftEditPlugin_17", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("yjfe", "header", (Object)ResManager.loadKDString((String)"\u5df2\u7f34\u8d39\u989d", (String)"DraftEditPlugin_18", (String)"taxc-totf", (Object[])new Object[0]));
            grid.setColumnProperty("jtynfe", "header", (Object)ResManager.loadKDString((String)"\u8ba1\u63d0\u5e94\u7eb3\u8d39\u989d", (String)"DraftEditPlugin_19", (String)"taxc-totf", (Object[])new Object[0]));
        }
    }

    private void doVisible(String taxtype) {
        if (taxtype == null) {
            return;
        }
        List<String> listColumns = DraftService.getListColumns(taxtype);
        listColumns.forEach(s -> this.getView().setVisible(Boolean.TRUE, new String[]{s}));
        List<String> allColumns = DraftService.getAllColumns();
        allColumns.removeAll(listColumns);
        allColumns.forEach(s -> this.getView().setVisible(Boolean.FALSE, new String[]{s}));
    }

    private void doClearAndSet(String taxtype) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
        this.getModel().setValue(ZSXM, (Object)(StringUtil.isEmpty((CharSequence)taxtype) ? "" : TaxTypeEnum.get(taxtype).getZsxm()), newEntryRow);
        this.getModel().setItemValueByNumber(ZSPM, taxtype, newEntryRow);
    }

    private void createTip(String key, String msg) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        HashMap<String, Object> m = new HashMap<String, Object>(16);
        HashMap<String, String> m1 = new HashMap<String, String>(16);
        m1.put("zh_CN", msg);
        m.put("content", m1);
        m.put("type", "text");
        entryGrid.setColumnProperty(key, "tips", m);
    }

    private void doSetTaxOrg(Long orgId) {
        long currUserId = RequestContext.get().getCurrUserId();
        Long orgid = OrgCheckUtil.setDefaultOrg((Long)orgId, (Long)currUserId, (IFormView)this.getView());
        if (orgid != null) {
            this.getModel().setValue(ORG, (Object)orgid);
        }
    }

    private void doSetAccountOrg() {
        Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).ifPresent(s -> {
            Long accountOrg = DraftService.setDefaultAccountOrg(s.getLong("id"));
            if (accountOrg == null && s.getBoolean("fisaccounting")) {
                this.getModel().setValue(ACCOUNTORG, (Object)s.getLong("id"));
            } else {
                this.getModel().setValue(ACCOUNTORG, (Object)accountOrg);
            }
        });
    }

    public void check(BeforeDoOperationEventArgs args, String field, String msg) {
        Object org = this.getModel().getValue(field);
        if (org == null) {
            args.setCancel(true);
            throw new KDBizException(msg);
        }
    }

    public ValidDataResultVo checkPeriodIsSame() {
        String limit = Optional.ofNullable((DynamicObject)this.getModel().getValue(ACCRUALPLAN)).map(s -> s.getString("cycle")).orElseGet(() -> "");
        Date start = (Date)this.getModel().getValue(SKSSQQ);
        Date end = (Date)this.getModel().getValue(SKSSQZ);
        String msg = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77\u5e94\u8be5\u4e3a\uff1a", (String)"DraftEditPlugin_6", (String)"taxc-totf", (Object[])new Object[0]);
        if ("month".equals(limit) && start.compareTo(DateUtils.getFirstDateOfMonth((Date)end)) != 0) {
            return ValidDataResultVo.fail((String)(msg + DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)end))));
        }
        if ("season".equals(limit) && start.compareTo(DateUtils.getFirstDateOfSeason((Date)end)) != 0) {
            return ValidDataResultVo.fail((String)(msg + DateUtils.format((Date)DateUtils.getFirstDateOfSeason((Date)end))));
        }
        if ("year".equals(limit) && start.compareTo(DateUtils.getFirstDateOfYear((Date)end)) != 0) {
            return ValidDataResultVo.fail((String)(msg + DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)end))));
        }
        return ValidDataResultVo.success();
    }

    public void doSetSkssqzAndResetSkssqq() {
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Long taxTypeId = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAXTYPE)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Date startdate = (Date)this.getModel().getValue(SKSSQQ);
        Long planId = DraftService.getPlanId(orgId, taxTypeId, AccrualConstant.TAXSYSTEM_CHINA, startdate, DateUtils.getLastDateOfMonth((Date)startdate));
        this.getModel().setValue(ACCRUALPLAN, (Object)planId);
        String limit = Optional.ofNullable((DynamicObject)this.getModel().getValue(ACCRUALPLAN)).map(s -> s.getString("cycle")).orElseGet(() -> "");
        if (planId == null || planId == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5728\u6240\u9009\u7a0e\u671f\u65e0\u53ef\u7528\u7684\u8ba1\u7a0e\u65b9\u6848\u3002", (String)"DraftEditPlugin_9", (String)"taxc-totf", (Object[])new Object[0]));
            this.getModel().setValue(SKSSQZ, null);
            return;
        }
        if ("month".equals(limit)) {
            this.getModel().setValue(SKSSQZ, (Object)DateUtils.getLastDateOfMonth((Date)((Date)this.getModel().getValue(SKSSQQ))));
            this.getModel().setValue(SKSSQQ, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue(SKSSQZ))));
        }
        if ("season".equals(limit)) {
            this.getModel().setValue(SKSSQZ, (Object)DateUtils.getLastDateOfSeason((Date)((Date)this.getModel().getValue(SKSSQQ))));
            this.getModel().setValue(SKSSQQ, (Object)DateUtils.getFirstDateOfSeason((Date)((Date)this.getModel().getValue(SKSSQZ))));
        }
        if ("year".equals(limit)) {
            this.getModel().setValue(SKSSQZ, (Object)DateUtils.getLastDateOfYear((Date)((Date)this.getModel().getValue(SKSSQQ))));
            this.getModel().setValue(SKSSQQ, (Object)DateUtils.getFirstDateOfYear((Date)((Date)this.getModel().getValue(SKSSQZ))));
        }
    }

    private BigDecimal getData(String field, DynamicObjectCollection dynamicObjects) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return BigDecimal.ZERO;
        }
        if ("taxrate".equals(field) || "ratio".equals(field)) {
            return dynamicObjects.stream().filter(s -> s.get(field) != null && s.getBigDecimal(field).compareTo(BigDecimal.ZERO) > 0).map(s -> s.getBigDecimal(field)).findFirst().orElseGet(() -> BigDecimal.ZERO);
        }
        return dynamicObjects.stream().map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getLatestData(String field, DynamicObjectCollection dynamicObjects) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return BigDecimal.ZERO;
        }
        return dynamicObjects.stream().filter(s -> s.get(field) != null && s.getBigDecimal(field).compareTo(BigDecimal.ZERO) > 0).map(s -> s.getBigDecimal(field)).findFirst().orElseGet(() -> BigDecimal.ZERO);
    }

    private Integer getIntData(String field, DynamicObjectCollection dynamicObjects) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return 0;
        }
        return dynamicObjects.stream().filter(s -> s.get(field) != null && s.getInt(field) > 0).map(s -> s.getInt(field)).findFirst().orElseGet(() -> 0);
    }

    private void loadDetailData() {
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong("id")).orElseGet(() -> null);
        Long taxTypeId = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAXTYPE)).map(s -> s.getLong("id")).orElseGet(() -> null);
        String taxType = Optional.ofNullable((DynamicObject)this.getModel().getValue(TAXTYPE)).map(s -> s.getString("number")).orElseGet(() -> null);
        Date start = (Date)this.getModel().getValue(SKSSQQ);
        Date end = (Date)this.getModel().getValue(SKSSQZ);
        if (StringUtil.isBlank((CharSequence)taxType) || orgId == null) {
            return;
        }
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.get(taxType);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entity)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)entity.get(0);
        dynamicObject.set(ZSXM, (Object)taxTypeEnum.getZsxm());
        dynamicObject.set("zspm_id", (Object)taxTypeId);
        if (start != null && end != null) {
            if (TaxTypeEnum.TAXTYPE_024 == taxTypeEnum) {
                this.load24(orgId, taxTypeId, start, end, taxTypeEnum, dynamicObject);
            } else if (TaxTypeEnum.TAXTYPE_025 == taxTypeEnum) {
                this.load25(orgId, taxTypeId, start, end, taxTypeEnum, dynamicObject);
            } else if (TaxTypeEnum.TAXTYPE_026 == taxTypeEnum) {
                this.load26(orgId, taxTypeId, start, end, taxTypeEnum, dynamicObject);
            } else if (TaxTypeEnum.TAXTYPE_023 == taxTypeEnum || TaxTypeEnum.TAXTYPE_034 == taxTypeEnum || TaxTypeEnum.TAXTYPE_036 == taxTypeEnum) {
                this.load23_34_36(orgId, taxTypeId, start, end, taxTypeEnum, dynamicObject);
            } else if (TaxTypeEnum.TAXTYPE_027 == taxTypeEnum) {
                this.load27(orgId, taxTypeId, start, end, taxTypeEnum, dynamicObject);
            }
        }
        this.getView().updateView(ENTRYENTITY);
        this.getView().sendFormAction(this.getView());
    }

    private void load24(Long orgId, Long taxTypeId, Date start, Date end, TaxTypeEnum taxTypeEnum, DynamicObject dynamicObject) {
        long id = DBUtils.getLongId(null);
        BigDecimal yjfjs = WaterFundAccrualDataService.doCalcDetails(orgId, start, end, id);
        dynamicObject.set("yjfjs", (Object)yjfjs);
        BigDecimal jcx = dynamicObject.getBigDecimal("jcx");
        BigDecimal jfyj = yjfjs.subtract(jcx).setScale(2, 4);
        dynamicObject.set("jfyj", (Object)jfyj);
        BigDecimal zsbz = DraftService.getFeeRate(orgId, taxTypeEnum, start, end);
        dynamicObject.set("zsbz", (Object)zsbz);
        BigDecimal kcs = dynamicObject.getBigDecimal("kcs");
        BigDecimal zsbl = dynamicObject.getBigDecimal("zsbl");
        BigDecimal ynfe = jfyj.multiply(zsbz).subtract(kcs).multiply(zsbl).setScale(2, 4);
        dynamicObject.set("ynfe", (Object)ynfe);
        BigDecimal jmfe = dynamicObject.getBigDecimal("jmfe");
        BigDecimal yjfe = dynamicObject.getBigDecimal("yjfe");
        dynamicObject.set("jtynfe", (Object)ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4));
    }

    private void load25(Long orgId, Long taxTypeId, Date start, Date end, TaxTypeEnum taxTypeEnum, DynamicObject dynamicObject) {
        DynamicObjectCollection account = DraftService.queryByAccount(taxTypeEnum, orgId, taxTypeId, start, end);
        BigDecimal yjfjs = this.getData("taxableitem", account);
        dynamicObject.set("yjfjs", (Object)yjfjs);
        BigDecimal jcx = this.getData("deductitem", account);
        dynamicObject.set("jcx", (Object)jcx);
        BigDecimal jfyj = yjfjs.subtract(jcx).setScale(2, 4);
        dynamicObject.set("jfyj", (Object)jfyj);
        BigDecimal zsbz = DraftService.getFeeRate(orgId, taxTypeEnum, start, end);
        dynamicObject.set("zsbz", (Object)zsbz);
        BigDecimal kcs = this.getData("quickdeduction", account);
        dynamicObject.set("kcs", (Object)kcs);
        BigDecimal zsbl = CollectionUtils.isEmpty((Collection)account) ? BigDecimal.ONE : this.getData("taxrate", account);
        dynamicObject.set("zsbl", (Object)zsbl);
        BigDecimal ynfe = jfyj.multiply(zsbz).subtract(kcs).multiply(zsbl).setScale(2, 4);
        dynamicObject.set("ynfe", (Object)ynfe);
        BigDecimal jmfe = this.getData("deductionamount", account);
        dynamicObject.set("jmfe", (Object)jmfe);
        BigDecimal yjfe = this.getData("bqyjse", account);
        dynamicObject.set("yjfe", (Object)yjfe);
        dynamicObject.set("jtynfe", (Object)ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4));
    }

    private void load26(Long orgId, Long taxTypeId, Date start, Date end, TaxTypeEnum taxTypeEnum, DynamicObject dynamicObject) {
        DynamicObjectCollection account = DraftService.queryTaxableDeductItemAccount(orgId, start, end);
        long id = DBUtils.getLongId(null);
        BigDecimal yzsr = WhsyjsfAccrualDataService.doCalcDetails(orgId, start, end, id);
        dynamicObject.set("yzsr", (Object)yzsr);
        BigDecimal jcx = this.getData("amount", account);
        dynamicObject.set("jcx", (Object)jcx);
        BigDecimal jfxse = yzsr.subtract(jcx).setScale(2, 4);
        dynamicObject.set("jfxse", (Object)jfxse);
        BigDecimal feerate = DraftService.getFeeRate(orgId, taxTypeEnum, start, end);
        dynamicObject.set("feerate", (Object)feerate);
        BigDecimal ynfe = jfxse.multiply(feerate).setScale(2, 4);
        dynamicObject.set("ynfe", (Object)ynfe);
        BigDecimal jmfe = dynamicObject.getBigDecimal("jmfe");
        BigDecimal yjfe = dynamicObject.getBigDecimal("yjfe");
        dynamicObject.set("jtynfe", (Object)ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4));
    }

    private void load27(Long orgId, Long taxTypeId, Date start, Date end, TaxTypeEnum taxTypeEnum, DynamicObject dynamicObject) {
        DynamicObjectCollection account = DraftService.queryEmploymentFund(orgId, start, end);
        BigDecimal snzzzgzze = this.getData("salary", account);
        dynamicObject.set("snzzzgzze", (Object)snzzzgzze);
        BigDecimal snzzzgrs = this.getLatestData("staffnumbernew", account);
        dynamicObject.set("snzzzgrsnew", (Object)snzzzgrs);
        BigDecimal zapcjrjybl = this.getData("ratio", account);
        dynamicObject.set("zapcjrjybl", (Object)zapcjrjybl);
        BigDecimal snsjapcjrjyrs = this.getLatestData("disablednumbernew", account);
        dynamicObject.set("snsjapcjrjyrsnew", (Object)snsjapcjrjyrs);
        BigDecimal snzzzgnpjgz = BigDecimalUtil.divideObject((Object)snzzzgzze, (Object)snzzzgrs, (int)2);
        dynamicObject.set("snzzzgnpjgz", (Object)(snzzzgnpjgz == null ? BigDecimal.ZERO : snzzzgnpjgz));
        BigDecimal ynfe = snzzzgrs.multiply(zapcjrjybl).subtract(snsjapcjrjyrs).multiply(snzzzgnpjgz != null ? snzzzgnpjgz : BigDecimal.ZERO).setScale(2, 4);
        if (ynfe.compareTo(BigDecimal.ZERO) < 0) {
            ynfe = BigDecimal.ZERO;
        }
        dynamicObject.set("ynfe", (Object)ynfe);
        BigDecimal jmfe = this.getData("deductionamount", account);
        dynamicObject.set("jmfe", (Object)jmfe);
        BigDecimal yjfe = this.getData("bqyjse", account);
        dynamicObject.set("yjfe", (Object)yjfe);
        dynamicObject.set("jtynfe", (Object)ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4));
    }

    private void load23_34_36(Long orgId, Long taxTypeId, Date start, Date end, TaxTypeEnum taxTypeEnum, DynamicObject dynamicObject) {
        DynamicObjectCollection account = DraftService.queryByAccount(taxTypeEnum, orgId, taxTypeId, start, end);
        BigDecimal ysx = this.getData("taxableitem", account);
        BigDecimal jcx = this.getData("deductitem", account);
        BigDecimal yssdl = CollectionUtils.isEmpty((Collection)account) ? BigDecimal.ONE : this.getData("taxrate", account);
        dynamicObject.set("ysx", (Object)ysx);
        dynamicObject.set("jcx", (Object)jcx);
        dynamicObject.set("yssdl", (Object)yssdl);
        BigDecimal jfyj = ysx.subtract(jcx).multiply(yssdl).setScale(2, 4);
        dynamicObject.set("jfyj", (Object)jfyj);
        BigDecimal flhdwse = DraftService.getFeeRate(orgId, taxTypeEnum, start, end);
        dynamicObject.set("flhdwse", (Object)flhdwse);
        BigDecimal sskcs = this.getData("quickdeduction", account);
        dynamicObject.set("sskcs", (Object)sskcs);
        BigDecimal ynfe = jfyj.multiply(flhdwse).subtract(sskcs).setScale(2, 4);
        dynamicObject.set("ynfe", (Object)ynfe);
        BigDecimal jmfe = this.getData("deductionamount", account);
        dynamicObject.set("jmfe", (Object)jmfe);
        BigDecimal yjfe = this.getData("bqyjse", account);
        dynamicObject.set("yjfe", (Object)yjfe);
        dynamicObject.set("jtynfe", (Object)ynfe.subtract(jmfe).subtract(yjfe).setScale(2, 4));
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String draftBillNo) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put(TAXSYSTEM, taxsystem);
        hashMap.put("taxtype.number", Arrays.stream(TaxTypeEnum.values()).map(s -> s.getNumber()).collect(Collectors.joining(",")));
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

