/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.formplugin.sjjt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.totf.common.enums.TaxTypeEnum;
import org.apache.commons.lang3.ObjectUtils;

public class DraftListPlugin
extends AbstractListPlugin {
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String DRAFTTYPE = "drafttype";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"checkjtd", (CharSequence)((Donothing)args.getSource()).getOperateKey()) && ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DraftListPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        String operateKey = evt.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd") || StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd")) {
            billlist.refresh();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"checkjtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            List ids = evt.getOperationResult().getSuccessPkIds();
            if (ObjectUtils.isNotEmpty((Object)ids)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityId, (String)"billno,org.id ,taxsystem.id,drafttype");
                String taxsystemId = Optional.ofNullable(dynamicObject.getDynamicObject("taxsystem")).map(s -> s.getString("id")).orElseGet(() -> "0");
                this.openProvistonBillPage(dynamicObject.getString("org.id"), taxsystemId, dynamicObject.getString("billno"));
            }
        }
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String draftBillNo) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        hashMap.put("taxtype.number", Arrays.stream(TaxTypeEnum.values()).map(s -> s.getNumber()).collect(Collectors.joining(",")));
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (SKSSQQ.equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList customQFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter(DRAFTTYPE, "in", TaxTypeEnum.getDraftTypes())});
        e.setCustomQFilters((List)customQFilters);
    }
}

