/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.opplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.account.AccountServiceHelper;

public class EmploymentFundSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Long JM_ID1 = 1660876890359052288L;
    private static final Long JM_ID2 = 1660876893370563584L;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    List existCollection;
                    boolean check;
                    String det;
                    boolean taxofficeExist;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    DynamicObject org = dynamicObject.getDynamicObject("org");
                    boolean orgExist = QueryServiceHelper.exists((String)"tctb_tax_main", (QFilter[])new QFilter[]{new QFilter("number", "=", org.get("number"))});
                    Boolean permission = PermissionUtils.getPermByUserIdOrg((Long)org.getLong("id"), (Long)RequestContext.get().getCurrUserId(), (String)"totf", (String)"totf_employment_fund", (String)"47150e89000000ac");
                    if (!(TaxcMainDataServiceHelper.isTaxcMainByOrgNum((String)org.getString("number")).isSuccess() && permission.booleanValue() && orgExist)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5b58\u5728\u3001\u6216\u662f\u5426\u6709\u6743\u9650\u3001\u6216\u662f\u5426\u5df2\u5ba1\u6838\u3001\u6216\u662f\u5426\u5df2\u542f\u7528", (String)"EmploymentFundSaveOpPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject taxoffice = dynamicObject.getDynamicObject("taxoffice");
                    if (taxoffice != null && !(taxofficeExist = QueryServiceHelper.exists((String)"bastax_taxorgan", (QFilter[])new QFilter[]{new QFilter("number", "=", taxoffice.get("number"))}))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u4e0d\u5b58\u5728\u4e8e\u7a0e\u52a1\u57fa\u7840\u670d\u52a1-\u7a0e\u52a1\u673a\u5173\u8d44\u6599\u91cc\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u7a0e\u52a1\u673a\u5173\u7f16\u7801\u3002", (String)"EmploymentFundSaveOpPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    Date startdate = (Date)dynamicObject.get("startdate");
                    Date enddate = (Date)dynamicObject.get("enddate");
                    DynamicObject zspm = dynamicObject.getDynamicObject("zspm");
                    String string = det = zspm != null ? zspm.getString("id") : "0";
                    if (!String.valueOf(ZspmConstant.ID_CJRJYBZJ_ZPSM).equals(det)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u4e0d\u662f\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1\u7684\u5f81\u6536\u54c1\u76ee", (String)"EmploymentFundSaveOpPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(org.getLong("id")));
                    if (!result.isSuccess() || !EmptyCheckUtils.isNotEmpty((Object)result.getData())) continue;
                    DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
                    DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
                    List zspmCollect = qtsfentity.stream().filter(s -> det.equals(s.getString("collectrate.id"))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(zspmCollect)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1\u201d\u4e0d\u5b58\u5728\u4e8e\u201c\u5176\u4ed6\u7a0e\u8d39\u201d\u5361\u7247\uff0c\u8bf7\u8fdb\u5165\u8be5\u7a0e\u52a1\u7ec4\u7ec7\u7684\u201c\u5176\u4ed6\u7a0e\u8d39\u201d\u5361\u7247\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"EmploymentFundSaveOpPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    List<Object> DateCollect = new ArrayList();
                    if (startdate == null || enddate == null) continue;
                    DateCollect = qtsfentity.stream().filter(s -> det.equals(s.getString("collectrate.id"))).filter(s -> startdate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddate.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(DateCollect)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u3010\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u7684\u8303\u56f4\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u6b64\u8303\u56f4\u5fc5\u987b\u88ab\u5305\u542b\u4e0e\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u8be5\u5f81\u6536\u54c1\u76ee\u7684\u6709\u6548\u671f\u8d77\u6b62\u8303\u56f4\u5185", (String)"EmploymentFundSaveOpPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    String taxperiod = ((DynamicObject)DateCollect.get(0)).getString("taxperiod");
                    boolean bl = "count".equals(taxperiod) ? DateUtils.validDateRange((String)taxperiod, (Date)startdate, (Date)enddate) : (check = DateUtils.validDateRange((String)taxperiod, (Date)startdate, (Date)enddate) || DateUtils.validDateRange((String)"month", (Date)startdate, (Date)enddate));
                    if (!check) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u8303\u56f4\u4e0d\u7b26\u5408\u7f34\u7eb3\u671f\u9650\uff0c\u8bf7\u68c0\u67e5\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u8be5\u7ec4\u7ec7\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1\u7684\u7f34\u7eb3\u671f\u9650", (String)"EmploymentFundSaveOpPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    dynamicObject.set("payperiod", (Object)((DynamicObject)DateCollect.get(0)).getString("taxperiod"));
                    Long orgId = org.getLong("id");
                    Long taxofficeId = taxoffice != null ? taxoffice.getLong("id") : 0L;
                    DynamicObjectCollection collection = AccountServiceHelper.queryEmploymentFund(orgId, taxofficeId, Long.parseLong(det));
                    if (CollectionUtils.isEmpty((Collection)collection) || (existCollection = collection.stream().filter(a -> a.getDate("startdate") != null && a.getDate("enddate") != null).filter(a -> this.filterDate((DynamicObject)a, dynamicObject, startdate, enddate)).filter(a -> !DateUtils.checkTimeRepeat((Date)a.getDate("startdate"), (Date)a.getDate("enddate"), (Date)startdate, (Date)enddate)).collect(Collectors.toList())).size() <= 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d \u201c\u5f81\u6536\u54c1\u76ee\u201d \u201c\u7a0e\u52a1\u673a\u5173\u201d \u7684\u7ec4\u5408\u503c\u76f8\u540c\u65f6\uff0c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u7684\u65e5\u671f\u4e0d\u80fd\u6709\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EmploymentFundSaveOpPlugin_6", (String)"taxc-totf", (Object[])new Object[0]));
                    return;
                }
            }

            private boolean filterDate(DynamicObject existObject, DynamicObject dynamicObject, Date startdate, Date enddate) {
                if (dynamicObject != null && dynamicObject.getLong("id") != 0L) {
                    return !startdate.equals(existObject.getDate("startdate")) && !enddate.equals(existObject.getDate("enddate"));
                }
                return true;
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            BigDecimal bqynse;
            BigDecimal staffnumber = dynamicObject.getBigDecimal("staffnumbernew");
            BigDecimal disablednumber = dynamicObject.getBigDecimal("disablednumbernew");
            BigDecimal staffnumbers = staffnumber;
            BigDecimal disablednumbers = disablednumber;
            BigDecimal salary = (BigDecimal)dynamicObject.get("salary");
            BigDecimal ratio = (BigDecimal)dynamicObject.get("ratio");
            BigDecimal averagesalary = (BigDecimal)dynamicObject.get("averagesalary");
            if (staffnumber.compareTo(BigDecimal.ZERO) > 0) {
                averagesalary = salary.divide(staffnumbers, 2, 4);
                dynamicObject.set("averagesalary", (Object)averagesalary);
            }
            if ((bqynse = staffnumbers.multiply(ratio).subtract(disablednumbers).multiply(averagesalary)).compareTo(BigDecimal.ZERO) < 0) {
                bqynse = BigDecimal.ZERO;
            }
            dynamicObject.set("bqynse", (Object)bqynse);
            if (staffnumber.compareTo(new BigDecimal(30)) <= 0) {
                dynamicObject.set("taxdeduction_id", (Object)JM_ID2);
            } else if (disablednumber.compareTo(BigDecimal.ZERO) > 0) {
                if (staffnumbers.compareTo(new BigDecimal("30")) > 0 && disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) >= 0 && disablednumbers.divide(staffnumbers, 2, 4).compareTo(ratio) < 0 || disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) < 0) {
                    dynamicObject.set("taxdeduction_id", (Object)JM_ID1);
                } else {
                    dynamicObject.set("taxdeduction_id", (Object)0L);
                }
            } else {
                dynamicObject.set("taxdeduction_id", (Object)0L);
            }
            Long taxdeduction = (Long)dynamicObject.get("taxdeduction_id");
            if (taxdeduction != null) {
                if (taxdeduction.equals(JM_ID1)) {
                    if (disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) >= 0 && disablednumbers.divide(staffnumbers, 2, 4).compareTo(ratio) < 0) {
                        dynamicObject.set("deductionamount", (Object)bqynse.multiply(new BigDecimal("0.5")));
                    } else if (disablednumbers.divide(staffnumbers, 2, 4).compareTo(new BigDecimal("0.01")) < 0) {
                        dynamicObject.set("deductionamount", (Object)bqynse.multiply(new BigDecimal("0.9")));
                    }
                } else if (staffnumber.compareTo(new BigDecimal(30)) <= 0 && taxdeduction.equals(JM_ID2)) {
                    dynamicObject.set("deductionamount", (Object)bqynse);
                }
            }
            dynamicObject.set("bqybtse", (Object)bqynse.subtract(dynamicObject.getBigDecimal("deductionamount")).subtract(dynamicObject.getBigDecimal("bqyjse")));
        }
    }
}

