/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.opplugin.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.account.AccountServiceHelper;

public class FssTysbAccountSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String ENTITYNAME = "totf_jsxzsyxsf_account";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(Arrays.asList("org", "zspm", "taxoffice", "zszm", "startdate", "enddate"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    List existCollection;
                    DynamicObjectCollection collection;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    DynamicObject zspm = (DynamicObject)dataEntity.getValue("zspm");
                    Date startdate = (Date)dataEntity.getValue("startdate");
                    Date enddate = (Date)dataEntity.getValue("enddate");
                    DynamicObject org = (DynamicObject)dataEntity.getValue("org");
                    DynamicObject taxoffice = (DynamicObject)dataEntity.getValue("taxoffice");
                    DynamicObject zszm = (DynamicObject)dataEntity.getValue("zszm");
                    if (zspm == null || startdate == null || enddate == null || org == null || taxoffice == null) continue;
                    Long orgId = org.getLong("id");
                    Long taxofficeId = taxoffice.getLong("id");
                    String zspmNumber = zspm.getString("number");
                    ArrayList<Long> zszmIds = new ArrayList<Long>();
                    if (zszm != null) {
                        zszmIds.add(zszm.getLong("id"));
                    }
                    if (CollectionUtils.isEmpty((Collection)(collection = AccountServiceHelper.queryJsxzsyxsfAccount(orgId, taxofficeId, zspmNumber, zszmIds))) || (existCollection = collection.stream().filter(a -> a.getDate("startdate") != null && a.getDate("enddate") != null).filter(a -> this.filterDate((DynamicObject)a, dynamicObject, startdate, enddate)).filter(a -> !DateUtils.checkTimeRepeat((Date)a.getDate("startdate"), (Date)a.getDate("enddate"), (Date)startdate, (Date)enddate)).collect(Collectors.toList())).size() <= 0) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d \u201c\u5f81\u6536\u54c1\u76ee\u201d \u201c\u5f81\u6536\u5b50\u76ee\u201d \u201c\u7a0e\u52a1\u673a\u5173\u201d \u7684\u7ec4\u5408\u503c\u76f8\u540c\u65f6\uff0c\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u7684\u65e5\u671f\u4e0d\u80fd\u6709\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FssTysbAccountSaveOpPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
                    return;
                }
            }

            private boolean filterDate(DynamicObject existObject, DynamicObject dynamicObject, Date startdate, Date enddate) {
                if (dynamicObject != null && dynamicObject.getLong("id") != 0L) {
                    return !startdate.equals(existObject.getDate("startdate")) && !enddate.equals(existObject.getDate("enddate"));
                }
                return true;
            }
        });
    }
}

