/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.opplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBatchImportPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.totf.business.account.AccountServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaxableDeductItemAccountImportPlugin
extends BatchImportPlugin {
    private static Log logger = LogFactory.getLog(TaxableDeductItemAccountImportPlugin.class);
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    public static final int TAXLIMIT_MONTH = 1;
    public static final int TAXLIMIT_SEASON = 3;
    public static final int TAXLIMIT_HALF_YEAR = 6;
    public static final int TAXLIMIT_YEAR = 12;

    protected ApiResult save(List<ImportBillData> billdatas, ImportLogger importLogger) {
        for (ImportBillData billdata : billdatas) {
            List existCollection;
            String vouchernumber;
            String vouchertype;
            String itemname;
            JSONObject taxoffice;
            JSONObject data = billdata.getData();
            if (!this.checkDate(data.getString(STARTDATE))) {
                return this.mockResult(ResManager.loadKDString((String)"\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"TaxableDeductItemAccountImportPlugin_9", (String)"taxc-totf", (Object[])new Object[0]));
            }
            if (!this.checkDate(data.getString(ENDDATE))) {
                return this.mockResult(ResManager.loadKDString((String)"\u8d39\u6b3e\u6240\u5c5e\u671f\u6b62:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"TaxableDeductItemAccountImportPlugin_10", (String)"taxc-totf", (Object[])new Object[0]));
            }
            Date startdate = data.getDate(STARTDATE);
            Date enddate = data.getDate(ENDDATE);
            Date startDay = DateUtils.getFirstDateOfMonth((Date)startdate);
            Date endDay = DateUtils.getLastDateOfMonth((Date)enddate);
            if (!DateUtils.format((Date)startdate).equals(DateUtils.format((Date)startDay))) {
                return this.mockResult(ResManager.loadKDString((String)"\u3010\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u5fc5\u987b\u662f\u6708\u7b2c\u4e00\u5929", (String)"TaxableDeductItemAccountImportPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
            }
            if (!DateUtils.format((Date)enddate).equals(DateUtils.format((Date)endDay))) {
                return this.mockResult(ResManager.loadKDString((String)"\u3010\u8d39\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5fc5\u987b\u662f\u6708\u6700\u540e\u4e00\u5929", (String)"TaxableDeductItemAccountImportPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
            }
            if (DateUtils.getDayDiff((Date)startdate, (Date)enddate) <= 0) {
                return this.mockResult(ResManager.loadKDString((String)"\u3010\u8d39\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5fc5\u987b\u5927\u4e8e\u3010\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77\u3011", (String)"TaxableDeductItemAccountImportPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
            }
            int monthDiff = DateUtils.getMonthDiff((Date)startdate, (Date)enddate);
            String taxlimit = null;
            switch (monthDiff) {
                case 12: {
                    taxlimit = "year";
                    break;
                }
                case 6: {
                    taxlimit = "halfyear";
                    break;
                }
                case 3: {
                    taxlimit = "season";
                    break;
                }
                case 1: {
                    taxlimit = "month";
                }
            }
            boolean isValidDate = DateUtils.validDateRange((String)taxlimit, (Date)startdate, (Date)enddate);
            if (!isValidDate) {
                return this.mockResult(ResManager.loadKDString((String)"\u3010\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u8d39\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u8303\u56f4\u5fc5\u987b\u662f\u6574\u6708\u3001\u6574\u5b63\u3001\u534a\u5e74\u3001\u6574\u5e74", (String)"TaxableDeductItemAccountImportPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
            }
            String orgNumber = data.getJSONObject("org").getString("number");
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)orgNumber);
            if (!result.isSuccess()) {
                return this.mockResult(result.getMessage());
            }
            if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                return this.mockResult(ResManager.loadKDString((String)"\u586b\u5199\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"TaxableDeductItemAccountImportPlugin_6", (String)"taxc-totf", (Object[])new Object[0]));
            }
            DynamicObject taxMain = (DynamicObject)result.getData();
            Long orgId = taxMain.getLong("taxorg.id");
            StringBuilder message = this.orgLicenseCheckMessage(orgNumber, orgId);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)message)) {
                return this.mockResult(message.toString());
            }
            TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgId));
            if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObjectCollection collection = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("qtsfentity");
                Optional<DynamicObject> card = collection.stream().filter(e -> "0096".equals(e.get("collectrate.number"))).filter(e -> {
                    Date start = new Date(e.getDate("effectivestart").getTime());
                    Date end = e.getDate("effectiveend") != null ? new Date(e.getDate("effectiveend").getTime()) : null;
                    logger.info("\u5e94\u7a0e\u670d\u52a1\u51cf\u9664\u9879\u76ee\u6e05\u5355\u5f15\u5165-start:{}-end:{}-startdate:{}-enddate:{}", new Object[]{start, end, startdate, enddate});
                    return !(!startdate.equals(start) && !DateUtils.isEffectiveDate((Date)startdate, (Date)start, (Date)end) || !enddate.equals(end) && !DateUtils.isEffectiveDate((Date)enddate, (Date)start, (Date)end));
                }).findFirst();
                if (card.isPresent()) {
                    String taxperiod = card.get().getString("taxperiod");
                    if (!"month".equals(taxlimit) && !org.apache.commons.lang3.StringUtils.equals((CharSequence)taxlimit, (CharSequence)taxperiod)) {
                        return this.mockResult(ResManager.loadKDString((String)"\u586b\u5199\u7684\u8d39\u671f\u4e0e\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26", (String)"TaxableDeductItemAccountImportPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
                    }
                } else {
                    return this.mockResult(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7f34\u7eb3\u671f\u9650\u7684\u5f81\u6536\u54c1\u76ee", (String)"TaxableDeductItemAccountImportPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
                }
            }
            if ((taxoffice = billdata.getData().getJSONObject("taxoffice")) != null && !taxoffice.get((Object)"number").equals(taxMain.get("taxoffice.number"))) {
                return this.mockResult(ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u4e0e\u57fa\u7840\u8d44\u6599\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u4fe1\u606f\u4e0d\u7b26", (String)"TaxableDeductItemAccountImportPlugin_7", (String)"taxc-totf", (Object[])new Object[0]));
            }
            String kpfnsrsbh = data.getString("kpfnsrsbh");
            DynamicObjectCollection collection = AccountServiceHelper.queryTaxableDeductItemAccount(kpfnsrsbh, itemname = data.getString("itemname"), vouchertype = data.getString("vouchertype"), vouchernumber = data.getString("vouchernumber"), orgId);
            if (CollectionUtils.isNotEmpty((Collection)collection) && (existCollection = collection.stream().filter(a -> a.getDate(STARTDATE) != null).filter(a -> !DateUtils.checkTimeRepeat((Date)a.getDate(STARTDATE), (Date)a.getDate(ENDDATE), (Date)startdate, (Date)enddate)).collect(Collectors.toList())).size() > 0) {
                return this.mockResult(ResManager.loadKDString((String)"\u201d\u5f00\u7968\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u201d \u201c\u670d\u52a1\u9879\u76ee\u540d\u79f0\u201d \u201c\u51ed\u8bc1\u79cd\u7c7b\u201d \u201c\u51ed\u8bc1\u53f7\u7801\u201d \u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u7684\u7ec4\u5408\u503c\u91cd\u590d\u65f6\uff0c\u8d39\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u7684\u65e5\u671f\u4e0d\u80fd\u6709\u4ea4\u96c6\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"TaxableDeductItemAccountImportPlugin_11", (String)"taxc-totf", (Object[])new Object[0]));
            }
            this.setDefaultData(billdata, taxoffice, taxMain);
        }
        return super.save(billdatas, importLogger);
    }

    private StringBuilder orgLicenseCheckMessage(String orgNumber, Long orgId) {
        StringBuilder message = new StringBuilder();
        AbstractLicenseCheckBatchImportPlugin.checkOrg((String)orgNumber, (Long)orgId, (StringBuilder)message, (String)"totf");
        return message;
    }

    private ApiResult mockResult(String resultData) {
        ApiResult result = new ApiResult();
        result.setMessage(resultData);
        result.setSuccess(false);
        return result;
    }

    private void setDefaultData(ImportBillData data, JSONObject taxoffice, DynamicObject taxMain) {
        if (taxoffice == null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("importprop", (Object)"number");
            jsonObject.put("number", taxMain.get("taxoffice.number"));
            data.getData().put("taxoffice", (Object)jsonObject);
        }
    }

    private boolean checkDate(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return false;
        }
        String format = "yyyy-MM-dd";
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            Date date = DateUtils.stringToDate((String)dateStr);
        }
        catch (Exception e) {
            return false;
        }
        return TaxableDeductItemAccountImportPlugin.checkLeapYear(dateStr, format);
    }

    private static boolean checkLeapYear(String dateStr, String format) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            LocalDate localDate = LocalDate.parse(dateStr, dateTimeFormatter);
            return localDate.isLeapYear() || !dateStr.endsWith("-02-29");
        }
        catch (Exception e) {
            return false;
        }
    }
}

