/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.opplugin.account;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TysbAccountSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public static final int TAXLIMIT_MONTH = 1;
    public static final int TAXLIMIT_SEASON = 3;
    public static final int TAXLIMIT_HALF_YEAR = 6;
    public static final int TAXLIMIT_YEAR = 12;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    int dayOfDate2;
                    int dayOfDate1;
                    DynamicObject zspm = (DynamicObject)dataEntity.getValue("zspm");
                    String det = zspm.getString("id");
                    if (!String.valueOf(ZspmConstant.ID_GHJH_ZPSM).equals(det) && !String.valueOf(ZspmConstant.ID_GHCBJ_ZPSM).equals(det)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u5f81\u6536\u9879\u76ee\u4e0d\u662f\u5176\u4ed6\u6536\u5165\u3002", (String)"TysbAccountSaveOpPlugin_0", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    Date startdate = (Date)dataEntity.getValue("startdate");
                    Date enddate = (Date)dataEntity.getValue("enddate");
                    DynamicObject org = (DynamicObject)dataEntity.getValue("org");
                    TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(org.getLong("id")));
                    if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u5f81\u6536\u54c1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"TysbAccountSaveOpPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
                    DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
                    List zspmCollect = qtsfentity.stream().filter(s -> det.equals(s.getString("collectrate.id"))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(zspmCollect)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u5f81\u6536\u54c1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"TysbAccountSaveOpPlugin_1", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    List DateCollect = qtsfentity.stream().filter(s -> det.equals(s.getString("collectrate.id"))).filter(s -> startdate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddate.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(DateCollect)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"TysbAccountSaveOpPlugin_2", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    if (startdate == null || enddate == null) continue;
                    int dayOfDate = DateUtils.getDayOfDate((Date)startdate);
                    if (dayOfDate != 1) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u5fc5\u987b\u4e3a\u6708\u521d\u7b2c\u4e00\u5929\u3002", (String)"TysbAccountSaveOpPlugin_3", (String)"taxc-totf", (Object[])new Object[0]));
                    }
                    if ((dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)enddate))) != (dayOfDate2 = DateUtils.getDayOfDate((Date)enddate))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u4e3a\u6708\u672b\u6700\u540e\u4e00\u5929\u3002", (String)"TysbAccountSaveOpPlugin_4", (String)"taxc-totf", (Object[])new Object[0]));
                    }
                    int monthDiff = DateUtils.getMonthDiff((Date)startdate, (Date)enddate);
                    String taxlimit = null;
                    switch (monthDiff) {
                        case 12: {
                            taxlimit = "year";
                            break;
                        }
                        case 6: {
                            taxlimit = "halfyear";
                            break;
                        }
                        case 3: {
                            taxlimit = "season";
                            break;
                        }
                        case 1: {
                            taxlimit = "month";
                        }
                    }
                    boolean isValidDate = DateUtils.validDateRange((String)taxlimit, (Date)startdate, (Date)enddate);
                    if (!isValidDate) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u8303\u56f4\u5fc5\u987b\u662f\u6574\u6708\u3001\u6574\u5b63\u3001\u534a\u5e74\u3001\u6574\u5e74\u3002", (String)"TysbAccountSaveOpPlugin_5", (String)"taxc-totf", (Object[])new Object[0]));
                    }
                    if (DateUtils.validDateRange((String)((DynamicObject)DateCollect.get(0)).getString("taxperiod"), (Date)startdate, (Date)enddate)) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u7684\u8d39\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u7f34\u7eb3\u671f\u9650\u7684\u8981\u6c42\u3002", (String)"TysbAccountSaveOpPlugin_6", (String)"taxc-totf", (Object[])new Object[0]));
                }
            }
        });
    }
}

