/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.opplugin.account;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class WaterSoilAccountSaveOp
extends AbstractOperationServicePlugIn {
    private static final int TAXLIMIT_MONTH = 1;
    private static final int TAXLIMIT_SEASON = 3;
    private static final int TAXLIMIT_HALF_YEAR = 6;
    private static final int TAXLIMIT_YEAR = 12;
    private static final int TAXLIMIT_ONE = 0;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    boolean isValidDate;
                    Optional<DynamicObject> zspmOpt;
                    TaxResult result;
                    boolean iszspm;
                    BigDecimal quickdeduction;
                    BigDecimal yjfjs;
                    BigDecimal yjfjsjme = dataEntity.getValue("yjfjsjme") == null ? BigDecimal.ZERO : (BigDecimal)dataEntity.getValue("yjfjsjme");
                    BigDecimal bigDecimal = yjfjs = dataEntity.getValue("yjfjs") == null ? BigDecimal.ZERO : (BigDecimal)dataEntity.getValue("yjfjs");
                    if (yjfjsjme.compareTo(BigDecimal.ZERO) < 0 || yjfjsjme.compareTo(yjfjs) > 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5e94\u7f34\u8d39\u57fa\u6570\u51cf\u9664\u989d\u201d\u6570\u503c\u8303\u56f4\u7684\u89c4\u5219\u4e3a\uff1a0\u2264\u5e94\u7f34\u8d39\u57fa\u6570\u51cf\u9664\u989d\u2264\u5e94\u7f34\u8d39\u57fa\u6570\u3002", (String)"WaterSoilAccountSaveOp_14", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    BigDecimal bigDecimal2 = quickdeduction = dataEntity.getValue("quickdeduction ") == null ? BigDecimal.ZERO : (BigDecimal)dataEntity.getValue("quickdeduction ");
                    if (quickdeduction.compareTo(BigDecimal.ZERO) < 0 || yjfjsjme.compareTo(yjfjs.subtract(yjfjsjme)) > 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6263\u9664\u6570\u201d\u6570\u503c\u8303\u56f4\u7684\u89c4\u5219\u4e3a\uff1a0\u2264\u6263\u9664\u6570\u2264\uff08\u5e94\u7f34\u8d39\u57fa\u6570-\u5e94\u7f34\u8d39\u57fa\u6570\u51cf\u9664\u989d\uff09\u3002", (String)"WaterSoilAccountSaveOp_15", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject zspm = (DynamicObject)dataEntity.getValue("zspm");
                    String det = zspm.getString("id");
                    boolean bl = iszspm = String.valueOf(ZspmConstant.ID_STBCBCF_ZPSM).equals(det) || String.valueOf(ZspmConstant.ID_STBCBCF_JSQSR_ZPSM).equals(det) || String.valueOf(ZspmConstant.ID_STBCBCF_KCQSR_ZPSM).equals(det) || String.valueOf(ZspmConstant.ID_STBCBCF_QTSR_ZPSM).equals(det);
                    if (!iszspm) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u5f81\u6536\u9879\u76ee\u4e0d\u662f\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u3002", (String)"WaterSoilAccountSaveOp_0", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    Date startdate = (Date)dataEntity.getValue("startdate");
                    Date enddate = (Date)dataEntity.getValue("enddate");
                    DynamicObject org = (DynamicObject)dataEntity.getValue("org");
                    TaxResult check = TaxcLicenseCheckDataServiceHelper.check((Long)org.getLong("id"), (String)"totf");
                    if (!check.isSuccess() || ((Boolean)check.getData()).booleanValue()) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%s\u3011\u8bb8\u53ef\u5c1a\u672a\u6fc0\u6d3b\uff0c\u8bf7\u5148\u8fdb\u884c\u8bb8\u53ef\u6fc0\u6d3b\u3002", (String)"WaterSoilAccountSaveOp_13", (String)"taxc-totf", (Object[])new Object[0]), org.getString("name")));
                    }
                    if (!(result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(org.getLong("id")))).isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u5f81\u6536\u54c1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"WaterSoilAccountSaveOp_1", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    Object zszm = dataEntity.getValue("zszm");
                    DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
                    DynamicObjectCollection qtsfentity = taxMain.getDynamicObjectCollection("qtsfentity");
                    List dateCollect = qtsfentity.stream().filter(s -> det.equals(s.getString("collectrate.id"))).filter(s -> startdate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddate.compareTo(s.getDate("effectiveend")) <= 0).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(dateCollect)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u4e0d\u5b58\u5728\u751f\u6548\u7684\u7533\u62a5\u9879\u4fe1\u606f \uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterSoilAccountSaveOp_3", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    if (zszm != null) {
                        Long zszmId = ((DynamicObject)zszm).getLong("id");
                        zspmOpt = dateCollect.stream().filter(e -> zszmId.equals(e.getLong("collectitem.id"))).findFirst();
                    } else {
                        zspmOpt = dateCollect.stream().filter(e -> e.get("collectitem") == null).findFirst();
                    }
                    if (!zspmOpt.isPresent()) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u76f8\u5173\u5f81\u6536\u54c1\u76ee\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e\u201c\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"WaterSoilAccountSaveOp_2", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    if (startdate == null || enddate == null) continue;
                    int monthDiff = DateUtils.getMonthDiff((Date)startdate, (Date)enddate);
                    String taxlimit = null;
                    switch (monthDiff) {
                        case 12: {
                            taxlimit = "year";
                            break;
                        }
                        case 6: {
                            taxlimit = "halfyear";
                            break;
                        }
                        case 3: {
                            taxlimit = "season";
                            break;
                        }
                        case 1: {
                            taxlimit = "month";
                            break;
                        }
                        case 0: {
                            taxlimit = "count";
                        }
                    }
                    if (!"count".equals(taxlimit)) {
                        int dayOfDate2;
                        int dayOfDate = DateUtils.getDayOfDate((Date)startdate);
                        if (dayOfDate != 1) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u5fc5\u987b\u4e3a\u6708\u521d\u7b2c\u4e00\u5929\u3002", (String)"WaterSoilAccountSaveOp_4", (String)"taxc-totf", (Object[])new Object[0]));
                            continue;
                        }
                        int dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)enddate));
                        if (dayOfDate1 != (dayOfDate2 = DateUtils.getDayOfDate((Date)enddate))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u4e3a\u6708\u672b\u6700\u540e\u4e00\u5929\u3002", (String)"WaterSoilAccountSaveOp_5", (String)"taxc-totf", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    if (!(isValidDate = DateUtils.validDateRange((String)taxlimit, (Date)startdate, (Date)enddate))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u8303\u56f4\u5fc5\u987b\u662f\u6309\u6b21\u3001\u6574\u5b63\u3001\u6574\u5e74\u3002", (String)"WaterSoilAccountSaveOp_6", (String)"taxc-totf", (Object[])new Object[0]));
                        continue;
                    }
                    if (!DateUtils.validDateRange((String)zspmOpt.get().getString("taxperiod"), (Date)startdate, (Date)enddate)) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u8981\u6c42\uff0c\u8be5\u7533\u62a5\u9879\u4fe1\u606f\u7eb3\u7a0e\u671f\u9650\u4e3a\u201c%s\u201d\u3002", (String)"WaterSoilAccountSaveOp_7", (String)"taxc-totf", (Object[])new Object[0]), WaterSoilAccountSaveOp.this.getName(zspmOpt.get().getString("taxperiod"))));
                        continue;
                    }
                    dataEntity.setValue("taxperiod", (Object)zspmOpt.get().getString("taxperiod"));
                    dataEntity.setValue("rate", (Object)zspmOpt.get().getBigDecimal("amountrate"));
                }
            }
        });
    }

    private String getName(String taxLimit) {
        if ("month".equals(taxLimit)) {
            return ResManager.loadKDString((String)"\u6708", (String)"WaterSoilAccountSaveOp_8", (String)"taxc-totf", (Object[])new Object[0]);
        }
        if ("season".equals(taxLimit)) {
            return ResManager.loadKDString((String)"\u5b63", (String)"WaterSoilAccountSaveOp_9", (String)"taxc-totf", (Object[])new Object[0]);
        }
        if ("halfyear".equals(taxLimit)) {
            return ResManager.loadKDString((String)"\u534a\u5e74", (String)"WaterSoilAccountSaveOp_10", (String)"taxc-totf", (Object[])new Object[0]);
        }
        if ("year".equals(taxLimit)) {
            return ResManager.loadKDString((String)"\u5e74", (String)"WaterSoilAccountSaveOp_11", (String)"taxc-totf", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6b21", (String)"WaterSoilAccountSaveOp_12", (String)"taxc-totf", (Object[])new Object[0]);
    }
}

