/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.opplugin.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.totf.common.enums.RuleTypeEnum;

public class RuleDataSynOp
extends AbstractOperationServicePlugIn {
    private static final String TOTF_ALL_RULE_CONFIG = "totf_all_rule_config";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("disable".equals(operateKey) || "enable".equals(operateKey)) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"totf", (String)"totf_tysb_rule_group", (String)"0=KX5+QVF5+R");
                        if (hasPermOrgResult.hasAllOrgPerm() || !CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) && (CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) || hasPermOrgResult.getHasPermOrgs().contains(RequestContext.get().getOrgId()))) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u901a\u7528\u7533\u62a5\u53f0\u8d26\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_0", (String)"taxc-totf", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("disable".equals(operationKey) || "enable".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List ruleIds = Stream.of(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
            DynamicObject[] sbxRuleArray = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TOTF_ALL_RULE_CONFIG));
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            for (DynamicObject rule : sbxRuleArray) {
                rule.set("enable", (Object)e.getDataEntities()[0].getString("enable"));
                updateList.add(rule);
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        if ("save".equals(operationKey)) {
            DynamicObject dataEntity2 = e.getDataEntities()[0];
            Object pkValue = dataEntity2.getPkValue();
            String formId = e.getDataEntities()[0].getDataEntityType().getName();
            Long groupId = RuleTypeEnum.getGroupId(formId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TOTF_ALL_RULE_CONFIG);
            BeanCopyUtils.copyDynamicObjectWithoutEntity((DynamicObject)e.getDataEntities()[0], (DynamicObject)dynamicObject);
            dynamicObject.set("zspm", e.getDataEntities()[0].get("collectionitem"));
            dynamicObject.set("group", (Object)groupId);
            dynamicObject.set("issystem", (Object)"0");
            if (QueryServiceHelper.exists((String)TOTF_ALL_RULE_CONFIG, (Object)pkValue)) {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                return;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

