/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.totf.opplugin.rule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.totf.opplugin.rule.RuleDataSynOp;

public class WaterFundRuleSaveOp
extends RuleDataSynOp {
    public static final String KEY_TYPE = "type";
    public static final String KEY_RULE = "rule";
    public static final String KEY_MSG = "msg";

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject rule = dataEntity.getDataEntity();
                    DynamicObject org = rule.getDynamicObject("org");
                    if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WaterFundRuleSaveOp_1", (String)"taxc-totf", (Object[])new Object[0]));
                        return;
                    }
                    this.validate(dataEntity, rule);
                }
            }

            private void validate(ExtendedDataEntity dataEntity, DynamicObject rule) {
                List<Map<String, Object>> errorList = WaterFundRuleSaveOp.checkVatrate(rule);
                for (Map<String, Object> map : errorList) {
                    this.addFatalErrorMessage(dataEntity, (String)map.get(WaterFundRuleSaveOp.KEY_MSG));
                }
            }
        });
    }

    public static List<Map<String, Object>> checkVatrate(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject a1 = (DynamicObject)entryentity.get(i);
            String dataType = a1.getString("datatype");
            if (!dataType.equals(DataType.JSFLQS.getCode()) && !dataType.equals(DataType.CYSLDSQS.getCode()) || BigDecimal.ZERO.compareTo(a1.getBigDecimal("vatrate")) != 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, "error");
            map.put(KEY_RULE, (String)rule);
            map.put(KEY_MSG, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201d\u9ad8\u7ea7\u914d\u7f6e\u201c\u91cc\u7684\u589e\u503c\u7a0e\u7a0e\u7387\u9700\u5927\u4e8e0\u3002", (String)"WaterFundRuleSaveOp_0", (String)"taxc-totf", (Object[])new Object[0]), i + 1));
            msgList.add(map);
        }
        return msgList;
    }
}

