/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tpo.mservice.api.SbbAefArchiveWriteBackService;

public class SbbAefArchiveWriteBackServiceImpl
implements SbbAefArchiveWriteBackService {
    private static final Log log = LogFactory.getLog(SbbAefArchiveWriteBackServiceImpl.class);
    private static final String ARCHIVE_STATUS_WGD = "unfiled";
    private static final String ARCHIVE_STATUS_YGD = "filed";
    private static final String SUCCESS_CODE = "0000";
    private static final String FAIL_CODE = "-1000";

    private static String getFailMsg() {
        return ResManager.loadKDString((String)"\u53cd\u5199\u5931\u8d25", (String)"SbbAefArchiveWriteBackServiceImpl_0", (String)"taxc-tpo-mservice", (Object[])new Object[0]);
    }

    private static String getSuccessMsg() {
        return ResManager.loadKDString((String)"\u53cd\u5199\u6210\u529f", (String)"SbbAefArchiveWriteBackServiceImpl_1", (String)"taxc-tpo-mservice", (Object[])new Object[0]);
    }

    @Override
    public String writeBack(String archiveStatus, String billEntityNumber, Set<Long> ids) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!"tcvat_nsrxx".equals(billEntityNumber) || EmptyCheckUtils.isEmpty(ids)) {
            String paMsgs = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"SbbAefArchiveWriteBackServiceImpl_2", (String)"taxc-tpo-mservice", (Object[])new Object[0]);
            result.put("code", FAIL_CODE);
            result.put("description", SbbAefArchiveWriteBackServiceImpl.getFailMsg() + paMsgs);
            result.put("success", false);
            result.put("errIds", ids.toArray());
        } else {
            ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
            try {
                MainEntityType mt = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
                Object status = "1".equalsIgnoreCase(archiveStatus) ? this.getEnableStatus() : this.getDisableStatus();
                Iterator<Long> var7 = ids.iterator();
                Date date = new Date();
                while (var7.hasNext()) {
                    Long id = var7.next();
                    Object[] param = new Object[]{status, date, id};
                    params.add(param);
                    if (params.size() < 10000) continue;
                    this.batchExecuteSql(mt.getAlias(), params);
                    params.clear();
                }
                if (!params.isEmpty()) {
                    this.batchExecuteSql(mt.getAlias(), params);
                }
                result.put("code", SUCCESS_CODE);
                result.put("description", SbbAefArchiveWriteBackServiceImpl.getSuccessMsg());
                result.put("success", true);
                log.info("SbbAefArchiveWriteBackServiceImpl#\u7ed3\u675f\u6267\u884c\u5f52\u6863\u72b6\u6001\u53cd\u5199SQL");
            }
            catch (Exception e) {
                log.error("SbbAefArchiveWriteBackServiceImpl#ERROR#", (Throwable)e);
                result.put("code", FAIL_CODE);
                result.put("description", SbbAefArchiveWriteBackServiceImpl.getFailMsg() + e.getMessage());
                result.put("success", false);
                Object[] lastIds = params.stream().map(a -> a[2]).toArray();
                result.put("errIds", params.size() == 0 ? ids : lastIds);
            }
        }
        return SerializationUtils.toJsonString(result);
    }

    private void batchExecuteSql(String tableName, List<Object[]> params) {
        DB.executeBatch((DBRoute)this.getDBRoute(), (String)("update " + tableName + " set farchivestatus = ? ,farchivetime = ?  where fid = ?"), params);
    }

    protected DBRoute getDBRoute() {
        return DBRoute.of((String)"taxc");
    }

    protected Object getEnableStatus() {
        return ARCHIVE_STATUS_YGD;
    }

    protected Object getDisableStatus() {
        return ARCHIVE_STATUS_WGD;
    }
}

