/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizBusiness;
import kd.taxc.bdtaxr.business.taxdeclare.update.DeclareMainTableSyncBusiness;
import kd.taxc.bdtaxr.common.dto.DeclareMainTableQueryDto;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.utils.DyoToDtoUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tpo.business.declare.NxxDeclareMainService;
import kd.taxc.tpo.business.multidideclare.MultiDeclareMainService;
import kd.taxc.tpo.service.DeclareMainService;
import org.apache.commons.collections4.CollectionUtils;

public class DeclareMainServiceImpl
implements DeclareMainService {
    @Override
    public Map<String, Object> queryDeclareMainId(Long modelId, Map<String, String> params) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(params.size());
        this.createQFilter(params, filterList);
        Long mainId = modelId == null ? NxxDeclareMainService.queryDeclareMainId(filterList) : MultiDeclareMainService.queryDeclareMainId((DeclareTable)MultiTableEnum.getDeclareTable((Long)modelId), filterList);
        return ServiceResultUtils.returnResultHandler((boolean)true, (String)"000000", (String)"success", (Object)mainId);
    }

    private void createQFilter(Map<String, String> params, List<QFilter> filterList) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            filterList.add(new QFilter(entry.getKey(), "=", (Object)entry.getValue()));
        }
    }

    @Override
    public Map<String, Object> queryDeclareMainByIds(Long modelId, List<Long> ids) {
        List result = null;
        if (modelId == null) {
            DynamicObject[] objects = NxxDeclareMainService.queryDeclareMainByIds(ids);
            result = DyoToDtoUtils.dyoToLong((DynamicObject[])objects);
        } else {
            DynamicObject[] objects = MultiDeclareMainService.queryDeclareMainByIds((DeclareTable)MultiTableEnum.getDeclareTable((Long)modelId), ids);
            result = DyoToDtoUtils.dyoToLong((DynamicObject[])objects);
        }
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    @Override
    public Map<String, Object> queryModelVersionByIds(List<Long> ids) {
        Map model3Map = MultiDeclareMainService.getModelVersionByIds(ids);
        Map model2Map = NxxDeclareMainService.getModelVersionByIds(ids);
        for (Map.Entry entry : model2Map.entrySet()) {
            if (model3Map.containsKey(entry.getKey())) continue;
            model3Map.put(entry.getKey(), entry.getValue());
        }
        return ServiceResultUtils.returnResultHandler((Object)model3Map);
    }

    @Override
    public Map<String, Object> queryModelVersionByTypes(List<String> types) {
        List modelUpdatedTypes = MultiDeclareBizBusiness.getModelUpdatedTemplateTypes();
        Map<String, String> result = types.stream().collect(Collectors.toMap(k -> k, v -> {
            TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)v);
            if (templateEnum != null) {
                String version = templateEnum.getVersion();
                if (modelUpdatedTypes.contains(v)) {
                    version = ModelVersionEnum.MODEL3.getVersion();
                }
                if (ModelVersionEnum.MODEL1.getVersion().equals(version)) {
                    version = ModelVersionEnum.MODEL2.getVersion();
                }
                return version;
            }
            return "";
        }));
        return ServiceResultUtils.returnResultHandler(result);
    }

    @Override
    public Map<String, Object> queryDeclareMainTable(Long modelId, DeclareMainTableQueryDto queryDto) {
        List result = null;
        if (modelId == null) {
            DynamicObject[] objects = NxxDeclareMainService.queryDeclareMainTable((DeclareMainTableQueryDto)queryDto);
            result = DyoToDtoUtils.dyoToLong((DynamicObject[])objects);
        } else {
            DynamicObject[] objects = MultiDeclareMainService.queryDeclareMainTable((DeclareMainTableQueryDto)queryDto);
            result = DyoToDtoUtils.dyoToLong((DynamicObject[])objects);
        }
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    @Override
    public Map<String, Object> getModel2ToModel3FieldMap() {
        Map result = UpdConstant.NSRXX_FIELD_MAP;
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    @Override
    public Map<String, Object> syncModel2DataToModel3(List<Long> ids, String operate) {
        if (CollectionUtils.isEmpty(ids)) {
            return ServiceResultUtils.returnResultHandler((Object)Boolean.FALSE);
        }
        ArrayList model2Ids = Lists.newArrayList(ids);
        if ("delete".equals(operate)) {
            DeclareMainTableSyncBusiness.deleteModel3Data((List)model2Ids);
        } else {
            DeclareMainTableSyncBusiness.saveModel3Data((List)model2Ids);
        }
        return ServiceResultUtils.returnResultHandler((Object)Boolean.TRUE);
    }
}

