/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.subplugin.declare.DeclareBizExtendHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.DeclareReportSaveFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.TaxDeclareSaveDataDto;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckFactory;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.TaxDeclarePlugin;
import kd.taxc.tpo.business.multidideclare.MultiDataService;
import kd.taxc.tpo.business.multidideclare.MultiFormulaService;
import kd.taxc.tpo.service.DeclareReportService;

public class DeclareReportServiceImpl
implements DeclareReportService {
    private static Log logger = LogFactory.getLog(TaxDeclarePlugin.class);
    private BaseDataService baseDataService = new BaseDataServiceImpl();
    private TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private DeclareReportCalculateService declareReportCalculateService;
    private DeclareReportSaveService declareReportSaveService;

    @Override
    public Map<String, Object> declareReport(String request) {
        Long templateId;
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)request, DeclareRequestModel.class);
        Long sbbid = requestModel.getId();
        if (sbbid == null) {
            sbbid = TaxDeclarePluginService.generateSBBId(null);
            if (sbbid == null) {
                throw new KDBizException("No Sbb Data !");
            }
            requestModel.setId(sbbid);
        }
        if ((templateId = requestModel.getTemplateId()) == null) {
            TemplateVo templateVo = (TemplateVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_BASE_TEMPLATE, (Object[])new Object[]{requestModel.getModelId(), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate((String)requestModel.getSkssqq(), (String)"yyyy-MM-dd"), DateUtils.stringToDate((String)requestModel.getSkssqz(), (String)"yyyy-MM-dd")});
            requestModel.setTemplateId(templateVo.getTemplateId());
            requestModel.setBaseTemplate(templateVo.getTemplate());
        }
        Map businessMap = null;
        businessMap = InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel);
        requestModel.getBusinessMap().putAll(businessMap);
        if (requestModel.getRuleParamMap() == null) {
            requestModel.setRuleParamMap(new HashMap(10));
        }
        requestModel.getRuleParamMap().put("reportId", requestModel.getId());
        requestModel.getRuleParamMap().put("skssqq", requestModel.getSkssqq());
        requestModel.getRuleParamMap().put("skssqz", requestModel.getSkssqz());
        requestModel.getRuleParamMap().put("operation", requestModel.getOperation());
        requestModel.getRuleParamMap().put("modelId", requestModel.getModelId());
        requestModel.getRuleParamMap().put("templateId", requestModel.getTemplateId());
        requestModel.getRuleParamMap().put("cacheId", UUID.randomUUID());
        requestModel.getRuleParamMap().putAll(businessMap);
        if (!EmptyCheckUtils.isEmpty((Object)requestModel.getExtendParams())) {
            requestModel.getRuleParamMap().putAll(requestModel.getExtendParams());
        }
        List dynList = this.taxDeclareDataService.getDynRowList(requestModel);
        Map typeMap = DeclareReportHelpService.getEntityFields((DeclareRequestModel)requestModel, (List)dynList);
        DeclareResponseModel responseModel = this.calculateData(requestModel, dynList, typeMap);
        TaxDeclarePluginService.checkResponse((DeclareRequestModel)requestModel, (DeclareResponseModel)responseModel);
        HashMap<String, String> showData = responseModel.getData() == null ? new HashMap(0) : responseModel.getData();
        this.baseDataService.queryBaseDataMulti(showData, responseModel.getData(), responseModel.getDynRowList(), requestModel, responseModel.getAllFormulas().getCelltypeFormulas());
        showData = MultiDataService.changeToShow(showData, (Map)responseModel.getAllFormulas().getCelltypeFormulas(), (Map)typeMap);
        if (showData == null) {
            return ServiceResultUtils.returnResultHandler((boolean)false, (String)"500", (String)"save fail", null);
        }
        this.baseDataService.queryBaseDataMulti(showData, responseModel.getData(), responseModel.getDynRowList(), requestModel, responseModel.getAllFormulas().getCelltypeFormulas());
        Map checkFormulas = MultiFormulaService.getCheckFormulas((Long)requestModel.getTemplateId(), (List)responseModel.getDynRowList());
        MultiDataService.calCheckFormulas((DeclareRequestModel)requestModel, showData, (Map)checkFormulas, (Map)typeMap);
        BaseResult baseResult = this.saveDeclareReport(requestModel, responseModel, showData, showData, typeMap);
        if (baseResult.getCode() == 500) {
            return ServiceResultUtils.returnResultHandler((boolean)false, (String)"500", (String)baseResult.getMessage(), showData);
        }
        return ServiceResultUtils.returnResultHandler((boolean)true, (String)"200", (String)"save success", showData);
    }

    private DeclareResponseModel calculateData(DeclareRequestModel requestModel, List<DynamicRowModel> dynList, Map<String, EntityField> typeMap) {
        FormulaCollectionVo allFormulas = MultiFormulaService.getCalFormulas((DeclareRequestModel)requestModel, dynList);
        Map cellTypeFormulas = MultiFormulaService.getCellTypeFormulas((Long)requestModel.getTemplateId(), dynList);
        allFormulas.setCelltypeFormulas(cellTypeFormulas);
        Map formulaVoMap = allFormulas.getFormulas();
        Map qformulasMap = allFormulas.getQformulas();
        for (String key : formulaVoMap.keySet()) {
            HashMap v = new HashMap();
            TaxDeclarePluginService.calValues((Map)qformulasMap, (Map)formulaVoMap, (String)key, v);
        }
        DeclareResponseModel responseModel = MultiDataService.refreshData((DeclareRequestModel)requestModel, (FormulaCollectionVo)allFormulas, dynList, typeMap);
        this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler((String)requestModel.getTemplateType());
        if (this.declareReportCalculateService != null) {
            responseModel = this.declareReportCalculateService.afterCalculate(requestModel, responseModel, dynList, typeMap);
        }
        responseModel.setDynRowList(dynList);
        responseModel.setAllFormulas(allFormulas);
        return responseModel;
    }

    @Override
    public BaseResult saveDeclareReport(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> currMap, Map<String, String> newData, Map<String, EntityField> typeMap) {
        BaseResult baseResult = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType()).beforeSaveCheck(null, newData, responseModel);
        if (500 == baseResult.getCode()) {
            return baseResult;
        }
        currMap = DataFormatUtils.batchDataToDbTypeFormat(newData, typeMap);
        Map resultMap = null;
        TaxDeclareSaveDataDto saveDataDto = new TaxDeclareSaveDataDto();
        saveDataDto.setModelId(requestModel.getModelId());
        saveDataDto.setOrgId(requestModel.getOrgId().longValue());
        saveDataDto.setSbbId(requestModel.getId());
        saveDataDto.setSkssqq(requestModel.getSkssqq());
        saveDataDto.setSkssqz(requestModel.getSkssqz());
        saveDataDto.setTemplateType(requestModel.getTemplateType());
        saveDataDto.setRefresh(requestModel.getRefresh());
        saveDataDto.setCustomEvent(requestModel.getCustomEvent());
        saveDataDto.setUniKey(requestModel.getUniKey());
        saveDataDto.setCurrMap(currMap);
        saveDataDto.setTypeMap(typeMap);
        saveDataDto.setNewMaps(newData);
        saveDataDto.setExtendParams(requestModel.getExtendParams());
        BaseResult saveResultMap = MultiDataService.saveTaxDeclareData((TaxDeclareSaveDataDto)saveDataDto);
        if (saveResultMap == null || saveResultMap.getData() == null || !BaseResult.OK.equals(saveResultMap.getCode())) {
            if (saveResultMap != null && !BaseResult.OK.equals(saveResultMap.getCode())) {
                baseResult.setCode(saveResultMap.getCode());
                baseResult.setMessage(saveResultMap.getMessage());
            }
            return baseResult;
        }
        resultMap = (Map)saveResultMap.getData();
        RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
        ruleFetchService.saveRuleFetchAdjustData(null, requestModel);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(1);
        if (requestModel.getExtendParams() != null) {
            requestMap.putAll(requestModel.getExtendParams());
        }
        requestMap.put("orgId", requestModel.getOrgId());
        requestMap.put("skssqq", requestModel.getSkssqq());
        requestMap.put("skssqz", requestModel.getSkssqz());
        requestMap.put("Id", requestModel.getId());
        requestMap.putAll(requestModel.getBusinessMap());
        requestMap.put("remarks", requestModel.getBusinessValue("remarks"));
        HashMap resultMap1 = new HashMap(resultMap);
        this.declareReportSaveService = DeclareReportSaveFactory.createHandler((String)requestModel.getTemplateType());
        if (this.declareReportSaveService != null) {
            BaseResult baseResult2 = this.declareReportSaveService.saveBusinessData(requestMap, resultMap1);
        }
        DeclareBizExtendHelper.saveBusinessData(requestMap, resultMap1);
        return BaseResult.ok();
    }
}

