/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tpo.service.MultiQueryDataSourceService;

public class MultiQueryDataSourceServiceImpl
implements MultiQueryDataSourceService {
    private static Log logger = LogFactory.getLog(MultiQueryDataSourceServiceImpl.class);
    public static final String REQUEST_ORG_ID = "orgId";
    public static final String REQUEST_SKSSQQ = "skssqq";
    public static final String REQUEST_SKSSQZ = "skssqz";
    public static final String REQUEST_TEMPLATE_TYPE = "templatetype";
    public static final String REQUEST_SELECT_COLUMN_ID = "selectColumnId";
    public static final String REQUEST_CELL_NUMBER = "cellNumber";
    public static final String REQUEST_CUSTOM_FILTER = "customFilter";
    public static final String REQUEST_WHERE_FILTER = "whereQFilter";
    public static final String ORG = "org";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String TEMPLATETYPE = "templatetype";
    public static final String ENTRYENTITY_ROW = "row";
    public static final String ENTRYENTITY_COLUMN = "column";
    public static final String ENTRYENTITY_CELL_NUMBER = "cellnumber";
    public static final String ENTRYENTITY_DYNROWNO = "dynrowno";
    public static final String ENTRYENTITY_INDEX = "index";
    public static final String ENTRYENTITY_CELL_VALUE = "value";
    public static final String ENTRYENTITY_VALUE_TYPE = "valuetype";
    private static final String SELECT_COLUMNS = String.join((CharSequence)",", "cellnumber", "value", "valuetype", "row", "dynrowno", "index");

    @Override
    public Map<String, Object> queryDataSourceWithDraftSum(String requestJson) {
        logger.info("\u8bf7\u6c42\u53c2\u6570Json\uff1a" + requestJson);
        BigDecimal result = null;
        try {
            if (StringUtil.isBlank((CharSequence)requestJson)) {
                throw new KDBizException("params cannot be null!");
            }
            Map requestParams = (Map)SerializationUtils.fromJsonString((String)requestJson, Map.class);
            this.checkRequestParams(requestParams);
            DynamicObjectCollection details = this.queryMultiCellByModelEnum(MultiTableEnum.TSD001, requestParams);
            result = this.sumAmount(details);
            return ServiceResultUtils.returnResultHandler((Object)result);
        }
        catch (Exception e) {
            logger.error("queryDataSourceWithDraftSum failure!", (Throwable)e);
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)"500", (String)e.getMessage(), null);
        }
    }

    @Override
    public Map<String, Object> queryDataSourceWithDeclareSum(String requestJson) {
        logger.info("\u8bf7\u6c42\u53c2\u6570Json\uff1a" + requestJson);
        BigDecimal result = null;
        try {
            if (StringUtil.isBlank((CharSequence)requestJson)) {
                throw new KDBizException("params cannot be null!");
            }
            Map requestParams = (Map)SerializationUtils.fromJsonString((String)requestJson, Map.class);
            this.checkRequestParams(requestParams);
            DynamicObjectCollection details = this.queryMultiCellByModelEnum(MultiTableEnum.TSCOO1, requestParams);
            result = this.sumAmount(details);
            return ServiceResultUtils.returnResultHandler((Object)result);
        }
        catch (Exception e) {
            logger.error("queryDataSourceWithDeclareSum failure!", (Throwable)e);
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)"500", (String)e.getMessage(), null);
        }
    }

    private void checkRequestParams(Map<String, Object> requestParams) {
        List orgIds = (List)requestParams.get(REQUEST_ORG_ID);
        Object skssqq = requestParams.get("skssqq");
        Object skssqz = requestParams.get("skssqz");
        String templatetype = (String)requestParams.get("templatetype");
        Object selectColumnId = requestParams.get(REQUEST_SELECT_COLUMN_ID);
        String cellNumber = (String)requestParams.get(REQUEST_CELL_NUMBER);
        Object whereQFilter = requestParams.get(REQUEST_WHERE_FILTER);
        if (CollectionUtils.isEmpty((Collection)orgIds) || Objects.isNull(skssqq) || Objects.isNull(skssqz) || StringUtil.isBlank((CharSequence)templatetype)) {
            throw new KDBizException("params cannot be null!");
        }
        if (selectColumnId == null && StringUtil.isBlank((CharSequence)cellNumber)) {
            throw new KDBizException("either columnId or cellnumber must be input");
        }
    }

    private DynamicObjectCollection queryMultiCellByModelEnum(MultiTableEnum multiTableEnum, Map<String, Object> requestParams) {
        List orgIds = (List)requestParams.get(REQUEST_ORG_ID);
        Date skssqq = DateUtils.stringToDate((String)requestParams.get("skssqq").toString());
        Date skssqz = DateUtils.stringToDate((String)requestParams.get("skssqz").toString());
        String templatetype = (String)requestParams.get("templatetype");
        Long selectColumnId = requestParams.get(REQUEST_SELECT_COLUMN_ID) != null ? Long.valueOf(Long.parseLong(requestParams.get(REQUEST_SELECT_COLUMN_ID).toString())) : null;
        String cellNumber = (String)requestParams.get(REQUEST_CELL_NUMBER);
        Object whereFilterObj = requestParams.get(REQUEST_WHERE_FILTER);
        Map customFilterString = (Map)requestParams.get(REQUEST_CUSTOM_FILTER);
        Map<String, QFilter> customFilter = customFilterString.entrySet().stream().collect(Collectors.toMap(s -> (String)s.getKey(), s -> QFilter.fromSerializedString((String)((String)s.getValue()))));
        if (whereFilterObj != null) {
            QFilter whereFilter = QFilter.fromSerializedString((String)whereFilterObj.toString());
            templatetype = this.getTemplateType(templatetype, whereFilter);
            if (whereFilter != null && this.existsFetchItems(whereFilter)) {
                QFilter newTargetFilter;
                DynamicObjectCollection dynamicObjects;
                List<QFilter> rowColumnQfilter;
                List<String> fetchitems = Arrays.stream(whereFilter.recombine()).filter(s -> s.getProperty().equals("fetchitem")).map(s -> {
                    Object value = s.getValue();
                    if (value == null) {
                        return Lists.newArrayList();
                    }
                    if (value instanceof Object[]) {
                        return Arrays.stream((Object[])value).filter(v -> Objects.nonNull(v)).map(v -> v.toString()).collect(Collectors.toList());
                    }
                    return Lists.newArrayList((Object[])new String[]{value.toString()});
                }).findFirst().orElseGet(() -> Lists.newArrayList());
                if (fetchitems.size() == 0) {
                    fetchitems = this.getFetchItemsByV6(whereFilter);
                }
                QFilter targetFilter = new QFilter("entryentity.value", "in", fetchitems);
                List<QFilter> otherMainQfilter = this.getMainFilterByWhereFilter(whereFilter);
                if (otherMainQfilter != null) {
                    otherMainQfilter.stream().forEach(v -> targetFilter.and(v));
                }
                if ((rowColumnQfilter = this.getRowColumnFilterByWhereFilter(whereFilter)) != null) {
                    rowColumnQfilter.stream().forEach(v -> targetFilter.and(v));
                }
                if (!CollectionUtils.isEmpty((Collection)(dynamicObjects = this.getDynamicObjects(multiTableEnum, orgIds, skssqq, skssqz, templatetype, null, cellNumber, null, newTargetFilter = this.getNewCustomFilterNotFetchItems(targetFilter), customFilter)))) {
                    whereFilter.and(new QFilter("entryentity.index", "in", (Object)dynamicObjects.stream().map(s -> s.get(ENTRYENTITY_INDEX)).toArray()));
                    QFilter newWhereFilter = this.getNewCustomFilterNotFetchItems(whereFilter);
                    return this.getDynamicObjects(multiTableEnum, orgIds, skssqq, skssqz, templatetype, selectColumnId, cellNumber, null, newWhereFilter, customFilter);
                }
                return new DynamicObjectCollection();
            }
            return this.getDynamicObjects(multiTableEnum, orgIds, skssqq, skssqz, templatetype, selectColumnId, cellNumber, null, whereFilter, customFilter);
        }
        return this.getDynamicObjects(multiTableEnum, orgIds, skssqq, skssqz, templatetype, selectColumnId, cellNumber, null, null, customFilter);
    }

    private String getTemplateType(String templatetype, QFilter customFilter) {
        return Arrays.stream(customFilter.recombine()).filter(s -> "templatetype.number".equals(s.getProperty())).filter(s -> Objects.nonNull(s.getValue())).map(s -> s.getValue().toString()).findFirst().orElseGet(() -> templatetype);
    }

    private QFilter getNewCustomFilterNotFetchItems(QFilter customFilter) {
        QFilter newCustomFilter = null;
        for (QFilter filter : customFilter.recombine()) {
            if (filter.getProperty().equals("fetchitemtype") || filter.getProperty().equals("fetchitem") || filter.getProperty().indexOf("fetchitem.") >= 0) continue;
            newCustomFilter = newCustomFilter == null ? filter : newCustomFilter.and(filter);
        }
        return newCustomFilter;
    }

    private List<String> getFetchItemsByV6(QFilter customFilter) {
        List<String> fetchitems = new ArrayList<String>(10);
        try {
            Class<?> clazz = Class.forName("kd.bos.orm.query.MultiBaseDataFilterValue");
            Method getBaseDataName = clazz.getMethod("getBaseDataName", new Class[0]);
            Method getValue = clazz.getMethod("getValue", new Class[0]);
            QFilter qFilter = null;
            String entityName = null;
            for (QFilter filter : customFilter.recombine()) {
                Object filterValue;
                if (filter.getProperty().indexOf("fetchitem.") < 0 || !clazz.isInstance(filterValue = filter.getValue())) continue;
                entityName = (String)getBaseDataName.invoke(filterValue, new Object[0]);
                qFilter = qFilter == null ? filter : qFilter.and(filter);
                qFilter.__setProperty(filter.getProperty().split("\\.")[1]);
                qFilter.__setValue(getValue.invoke(filterValue, new Object[0]));
            }
            DynamicObjectCollection collection = QueryServiceHelper.query(entityName, (String)"id", (QFilter[])new QFilter[]{qFilter});
            fetchitems = collection.stream().map(v -> v.getString("id")).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("getFetchItemsByV6 error ", (Throwable)e);
        }
        return fetchitems;
    }

    private DynamicObjectCollection getDynamicObjects(MultiTableEnum multiTableEnum, List<Long> orgIds, Date skssqq, Date skssqz, String templatetype, Long selectColumnId, String cellNumber, List<Long> rowIds, QFilter whereFilter, Map<String, QFilter> customFilter) {
        List<QFilter> otherMainQfilter;
        String detailTable = multiTableEnum.getDeclareDetailTabled();
        String mainTable = multiTableEnum.getDeclareMainTable();
        QFilter orgFiler = new QFilter(ORG, "in", orgIds);
        QFilter dateFiler = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter templatetypeFilter = new QFilter("templatetype", "=", (Object)templatetype);
        ArrayList mainQfilter = Lists.newArrayList((Object[])new QFilter[]{orgFiler, dateFiler, templatetypeFilter});
        if (multiTableEnum == MultiTableEnum.TSD001) {
            Optional.ofNullable(customFilter).filter(s -> s.containsKey("trafttype")).ifPresent(s -> mainQfilter.add(s.get("trafttype")));
            Optional.ofNullable(customFilter).filter(s -> s.containsKey("taxtype")).ifPresent(s -> mainQfilter.add(s.get("taxtype")));
        }
        if ((otherMainQfilter = this.getMainFilterByWhereFilter(whereFilter)) != null) {
            mainQfilter.addAll(otherMainQfilter);
        }
        Set<Long> mainIds = this.getMainIds(mainTable, mainQfilter);
        QFilter entryIdQfilter = new QFilter("entryid", "in", mainIds);
        List<QFilter> handlerWhereFilter = this.getDetailFilterWhereFilter(whereFilter);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{entryIdQfilter});
        Optional.ofNullable(cellNumber).ifPresent(s -> filters.add(new QFilter(ENTRYENTITY_CELL_NUMBER, "=", (Object)cellNumber)));
        Optional.ofNullable(selectColumnId).ifPresent(s -> filters.add(new QFilter(ENTRYENTITY_COLUMN, "=", (Object)selectColumnId)));
        Optional.ofNullable(rowIds).ifPresent(s -> filters.add(new QFilter(ENTRYENTITY_ROW, "in", (Object)rowIds)));
        Optional.ofNullable(handlerWhereFilter).ifPresent(s -> filters.addAll(s));
        DynamicObjectCollection details = QueryServiceHelper.query((String)detailTable, (String)SELECT_COLUMNS, (QFilter[])filters.toArray(new QFilter[0]));
        return details;
    }

    private List<QFilter> getMainFilterByWhereFilter(QFilter whereFilter) {
        if (whereFilter == null) {
            return null;
        }
        return Arrays.stream(whereFilter.recombine()).filter(v -> !v.getProperty().startsWith("entryentity.")).collect(Collectors.toList());
    }

    private List<QFilter> getDetailFilterWhereFilter(QFilter whereFilter) {
        if (whereFilter == null) {
            return null;
        }
        List<QFilter> qFilters = Arrays.stream(whereFilter.recombine()).filter(v -> v.getProperty().startsWith("entryentity.")).collect(Collectors.toList());
        for (QFilter filter : qFilters) {
            String[] split;
            String property = filter.getProperty();
            if (!property.startsWith("entryentity.") || (split = property.split("\\.")).length < 2) continue;
            String prop = split[1];
            filter.__setProperty(prop);
            filter.__setCP("in");
            if (ENTRYENTITY_ROW.equals(prop)) {
                filter.__setValue(this.getRowId(new QFilter(split[2], "in", filter.getValue())));
                continue;
            }
            if (!ENTRYENTITY_COLUMN.equals(prop)) continue;
            filter.__setValue(this.getColumnId(new QFilter(split[2], "in", filter.getValue())));
        }
        return qFilters;
    }

    private List<QFilter> getRowColumnFilterByWhereFilter(QFilter whereFilter) {
        if (whereFilter == null) {
            return null;
        }
        List<QFilter> qFilters = Arrays.stream(whereFilter.recombine()).filter(filter -> {
            String prop;
            String[] split;
            String property = filter.getProperty();
            return property.startsWith("entryentity.") && (split = property.split("\\.")).length >= 2 && (ENTRYENTITY_ROW.equals(prop = split[1]) || ENTRYENTITY_COLUMN.equals(prop));
        }).collect(Collectors.toList());
        return qFilters;
    }

    private List<Long> getRowId(QFilter filter) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"tpo_row_member", (String)"id", (QFilter[])new QFilter[]{filter});
        return !CollectionUtils.isEmpty((Collection)rows) ? rows.stream().map(s -> s.getLong("id")).collect(Collectors.toList()) : new ArrayList<Long>();
    }

    private List<Long> getColumnId(QFilter filter) {
        DynamicObjectCollection columns = QueryServiceHelper.query((String)"tpo_col_member", (String)"id", (QFilter[])new QFilter[]{filter});
        return !CollectionUtils.isEmpty((Collection)columns) ? columns.stream().map(s -> s.getLong("id")).collect(Collectors.toList()) : new ArrayList<Long>();
    }

    private boolean existsFetchItems(QFilter customFilter) {
        List collect = Arrays.stream(customFilter.recombine()).map(s -> s.getProperty()).collect(Collectors.toList());
        boolean hasFecthItemProperty = collect.stream().anyMatch(v -> v.indexOf("fetchitem.") >= 0);
        return collect.contains("fetchitemtype") && (hasFecthItemProperty || collect.contains("fetchitem"));
    }

    private Set<Long> getMainIds(String mainTable, List<QFilter> filters) {
        DynamicObjectCollection ids = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        return ids.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
    }

    private BigDecimal sumAmount(DynamicObjectCollection details) {
        if (CollectionUtils.isEmpty((Collection)details)) {
            return BigDecimal.ZERO;
        }
        Optional<DynamicObject> decimal = details.stream().filter(s -> "decimal".equals(s.getString(ENTRYENTITY_VALUE_TYPE))).findFirst();
        if (decimal.isPresent()) {
            return details.stream().filter(s -> "decimal".equals(s.getString(ENTRYENTITY_VALUE_TYPE))).map(s -> (BigDecimal)this.convertToObject(s.getString(ENTRYENTITY_CELL_VALUE), s.getString(ENTRYENTITY_VALUE_TYPE))).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Optional<DynamicObject> integer = details.stream().filter(s -> "integer".equals(s.getString(ENTRYENTITY_VALUE_TYPE))).findFirst();
        if (integer.isPresent()) {
            return details.stream().filter(s -> "integer".equals(s.getString(ENTRYENTITY_VALUE_TYPE))).map(s -> BigDecimal.valueOf(((Integer)this.convertToObject(s.getString(ENTRYENTITY_CELL_VALUE), s.getString(ENTRYENTITY_VALUE_TYPE))).intValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private Object convertToObject(String value, String valueType) {
        try {
            if ("decimal".equals(valueType)) {
                return value == null ? BigDecimal.ZERO : new BigDecimal(value);
            }
            if ("date".equals(valueType)) {
                return value == null ? new Date() : DateUtils.stringToDate((String)value);
            }
            if ("integer".equals(valueType)) {
                return value == null ? 0 : Integer.parseInt(value);
            }
            return value == null ? "" : value;
        }
        catch (Exception e) {
            return "";
        }
    }
}

