/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.formplugin.formula.BaseDataFormulaName;
import kd.taxc.bdtaxr.common.dto.DeclareCellConvertParamsDto;
import kd.taxc.bdtaxr.common.dto.DeclareCellDataParamsDto;
import kd.taxc.bdtaxr.common.dto.DeclareMainDataParamsDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.ComboBoxFormulaName;
import kd.taxc.tpo.business.declare.NxxDeclareMainService;
import kd.taxc.tpo.business.formula.FormulaService;
import kd.taxc.tpo.service.OldDeclareCellService;

public class OldDeclareCellServiceImpl
implements OldDeclareCellService {
    private static Log logger = LogFactory.getLog(OldDeclareCellServiceImpl.class);

    @Override
    public Map<String, Object> convertDeclareCellTextToVal(Long sbbId, List<DeclareCellConvertParamsDto> cellParams) {
        if (CollectionUtils.isEmpty(cellParams)) {
            return null;
        }
        DynamicObject main = NxxDeclareMainService.queryDeclareMainById((Long)sbbId);
        String templateId = main.getString("templateid");
        TaxResult result = new TaxResult();
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (DeclareCellConvertParamsDto cellParam : cellParams) {
            String cellKey = cellParam.getCellKey();
            String cellValueType = cellParam.getCellValueType();
            String cellValue = cellParam.getCellValue();
            FormulaVo cellFormula = FormulaService.getCellFormula((String)templateId, (String)cellKey);
            if (cellFormula == null) continue;
            String cellType = cellFormula.getCellType();
            if ("5".equals(cellType)) {
                data.put(cellKey, this.getF7IdFromFormula(cellFormula, cellValueType, cellValue));
                continue;
            }
            if (!Arrays.asList("4", "3").contains(cellType)) continue;
            data.put(cellKey, this.getComboValFromFormula(cellFormula, cellValueType, cellValue));
        }
        return data;
    }

    private String getComboValFromFormula(FormulaVo cellFormula, String cellValueType, String cellValue) {
        String formulaName = cellFormula.getFormulaName();
        List comboFormulas = JSON.parseArray((String)formulaName, ComboBoxFormulaName.class);
        if (CollectionUtils.isEmpty((Collection)comboFormulas)) {
            return "";
        }
        Optional<ComboBoxFormulaName> first = comboFormulas.stream().filter(c -> cellValue.equals(c.getText())).findFirst();
        return first.map(ComboBoxFormulaName::getVal).orElse("");
    }

    private Long getF7IdFromFormula(FormulaVo cellFormula, String cellValueType, String cellValue) {
        String formulaName = cellFormula.getFormulaName();
        List baseDataFormulas = JSON.parseArray((String)formulaName, BaseDataFormulaName.class);
        if (CollectionUtils.isEmpty((Collection)baseDataFormulas)) {
            return 0L;
        }
        BaseDataFormulaName baseDataFormula = (BaseDataFormulaName)baseDataFormulas.get(0);
        QFilter filter = new QFilter(cellValueType, "=", (Object)cellValue);
        DynamicObject obj = QueryServiceHelper.queryOne((String)baseDataFormula.getVal(), (String)"id", (QFilter[])new QFilter[]{filter});
        return obj != null ? obj.getLong("id") : 0L;
    }

    @Override
    public Map<String, Object> getDeclareCellValue(DeclareCellDataParamsDto params) {
        if (CollectionUtils.isEmpty((Collection)params.getCellKeys())) {
            return null;
        }
        if (params.getSbbId() == null) {
            if (!this.checkParams(params.getMainParams())) {
                return null;
            }
            params.setSbbId(this.querySbbid(params.getMainParams()));
        }
        return this.queryCellValue(params.getCellKeys(), params.getSbbId());
    }

    @Override
    public Map<String, String> getDeclareCellValueStr(DeclareCellDataParamsDto params) {
        if (CollectionUtils.isEmpty((Collection)params.getCellKeys())) {
            return null;
        }
        if (params.getSbbId() == null) {
            if (!this.checkParams(params.getMainParams())) {
                return null;
            }
            params.setSbbId(this.querySbbid(params.getMainParams()));
        }
        return this.queryCellValueStr(params.getCellKeys(), params.getSbbId());
    }

    private Map<String, Object> queryCellValue(List<String> cellKeys, Long sbbId) {
        logger.info("getTaxAndProfitAmount queryCellValue\uff0csbbid:{},cells:{}", (Object)sbbId, JSON.toJSON(cellKeys));
        TaxResult result = new TaxResult();
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            Map<String, List<String>> cellTableMap = cellKeys.stream().collect(Collectors.groupingBy(c -> c.substring(0, c.lastIndexOf("#"))));
            cellTableMap.forEach((key, value) -> {
                String[] split = key.split("#");
                if (split.length == 2) {
                    String table = split[0];
                    String ewblxh = split[1];
                    QFilter qFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbId));
                    QFilter ewblxhFilter = new QFilter("ewblxh", "=", (Object)ewblxh);
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)table, (QFilter[])new QFilter[]{qFilter, ewblxhFilter});
                    if (obj != null) {
                        value.forEach(v -> data.put((String)v, obj.get(v.split("#")[2])));
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("getTaxAndProfitAmount error:{}", (Object)e.getMessage());
            logger.error((Throwable)e);
        }
        logger.info("getTaxAndProfitAmount queryCellValue\uff0cresult:{}", (Object)sbbId, JSON.toJSON(data));
        return data;
    }

    private Map<String, String> queryCellValueStr(List<String> cellKeys, Long sbbId) {
        logger.info("getTaxAndProfitAmount queryCellValue\uff0csbbid:{},cells:{}", (Object)sbbId, JSON.toJSON(cellKeys));
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            Map<String, List<String>> cellTableMap = cellKeys.stream().collect(Collectors.groupingBy(c -> c.substring(0, c.lastIndexOf("#"))));
            cellTableMap.forEach((key, value) -> {
                String[] split = key.split("#");
                if (split.length == 2) {
                    String table = split[0];
                    String ewblxh = split[1];
                    QFilter qFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbId));
                    QFilter ewblxhFilter = new QFilter("ewblxh", "=", (Object)ewblxh);
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)table, (QFilter[])new QFilter[]{qFilter, ewblxhFilter});
                    if (obj != null) {
                        value.forEach(v -> data.put((String)v, String.valueOf(obj.get(v.split("#")[2]))));
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("getTaxAndProfitAmount error:{}", (Object)e.getMessage());
            logger.error((Throwable)e);
        }
        logger.info("getTaxAndProfitAmount queryCellValue\uff0cresult:{}", (Object)sbbId, JSON.toJSON(data));
        return data;
    }

    private Long querySbbid(DeclareMainDataParamsDto mainParams) {
        DynamicObject obj = NxxDeclareMainService.queryLastDeclareMainWithinTaxPeriod((DeclareMainDataParamsDto)mainParams);
        return obj != null ? obj.getLong("id") : 0L;
    }

    private boolean checkParams(DeclareMainDataParamsDto mainParams) {
        switch (mainParams.getTaxType()) {
            case "qysds": {
                return this.checkQysdsParams(mainParams);
            }
        }
        return false;
    }

    private boolean checkQysdsParams(DeclareMainDataParamsDto mainParams) {
        return Objects.nonNull(mainParams.getOrgId()) && Objects.nonNull(mainParams.getStartDate()) && Objects.nonNull(mainParams.getEndDate()) && Objects.nonNull(mainParams.getDeclareType());
    }
}

