/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.service.OldDeclareExportService;

public class OldDeclareExportServiceImpl
implements OldDeclareExportService {
    private DeclareReportHideService declareReportHideService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getExportUrlBySbbId(Long sbbId, String fileName) {
        boolean zerodeclare;
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)sbbId, (String)"tcvat_nsrxx");
        DynamicObject org = obj.getDynamicObject("org");
        Long orgId = org.getLong("id");
        String type = obj.getString("type");
        String orgName = org.getString("name");
        if (!"qtsf_tysbb".equals(type) && !"qtsf_fsstysbb".equals(type) && (zerodeclare = obj.getBoolean("zerodeclare"))) {
            return null;
        }
        QFilter qFilter = new QFilter("type", "=", (Object)type);
        boolean isNewTemplate = QueryServiceHelper.exists((String)"bdtaxr_template_main", (QFilter[])new QFilter[]{qFilter});
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(type, type) + "_" + orgName;
        }
        Date date = (Date)obj.get("skssqq");
        Date endDate = (Date)obj.get("skssqz");
        DynamicObject template = null;
        String templateid = obj.getString("templateid");
        if (StringUtils.isNotEmpty((CharSequence)templateid)) {
            DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectById((String)type, (String)templateid) : TemplateUtilsOld.getTemplateObjectById((String)type, (String)templateid);
        }
        if (template == null) {
            DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date) : TemplateUtilsOld.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date);
        }
        if (template == null) {
            return null;
        }
        fileName = fileName + DateUtils.format((Date)date, (String)"yyyy-MM");
        Map valMap = isNewTemplate ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.queryData((Long)template.getLong("id"), (String)String.valueOf(sbbId), (String)"_") : TemplateShowUtils.queryData((String)type, (String)String.valueOf(sbbId), (String)"_");
        List hideSheets = null;
        this.declareReportHideService = DeclareReportHideFactory.createHandler((String)type);
        if (this.declareReportHideService != null) {
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(orgId);
            requestModel.setTemplateId(Long.valueOf(templateid));
            requestModel.setTemplateType(type);
            requestModel.setSkssqq(DateUtils.format((Date)date));
            requestModel.setSkssqz(DateUtils.format((Date)endDate));
            hideSheets = this.declareReportHideService.hideSheets(requestModel);
        }
        try (InputStream in = isNewTemplate ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, hideSheets, (Map)valMap) : TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, hideSheets, (Map)valMap);){
            String url;
            String string = url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", in, 5000);
            return string;
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }
}

