/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SqzlQueryServiceImpl {
    private String getJmxzdmKeepDigit(String jmxzdm, int digit) {
        if (StringUtils.isBlank((CharSequence)jmxzdm)) {
            return "";
        }
        return jmxzdm.substring(jmxzdm.length() - digit);
    }

    public String matchQxyJmdmBasedataByStr(String number, String hmc, int digit) {
        QFilter qFilter = new QFilter("taxcategory.id", "in", Arrays.asList(BaseTaxCategory.ZZS, BaseTaxCategory.CSWHJSS, BaseTaxCategory.JYFFJ, BaseTaxCategory.DFJYFFJ));
        if (StringUtil.isNotEmpty((CharSequence)number)) {
            qFilter.and("number", "=", (Object)this.getJmxzdmKeepDigit(number, digit));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_taxdeduction", (String)"id,name,policyname,policycaluse", (QFilter[])qFilter.toArray());
            return query.size() > 0 ? ((DynamicObject)query.get(0)).getString("id") : "";
        }
        if (StringUtil.isNotEmpty((CharSequence)hmc)) {
            ArrayList<String> result = new ArrayList<String>(16);
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"SqzlQueryServiceImpl.matchQxyJmdmBasedataByStr", (String)"tpo_taxdeduction", (String)"id,name,policyname,policycaluse", (QFilter[])qFilter.toArray(), (String)"");){
                for (Row row : rows) {
                    String name = row.getString("name");
                    String policyname = row.getString("policyname");
                    String policycaluse = row.getString("policycaluse");
                    name = name == null ? "" : name;
                    policyname = policyname == null ? "" : policyname;
                    policycaluse = policycaluse == null ? "" : policycaluse;
                    String format = String.format("%s%s%s", name, policyname, policycaluse);
                    if (!Objects.equals(format = format.replaceAll(" ", ""), hmc)) continue;
                    result.add(row.getString("id"));
                }
            }
            return result.size() > 0 ? (String)result.get(0) : "";
        }
        return "";
    }
}

