/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tpo.business.taxrefund.TaxRefundInfoServer;
import kd.taxc.tpo.common.vo.ResultResponse;
import kd.taxc.tpo.service.TaxRefundInfoService;

public class TaxRefundInfoServiceImpl
implements TaxRefundInfoService {
    private TaxRefundInfoServer taxRefundInfoServer = new TaxRefundInfoServer();

    @Override
    public Map<String, Object> addTaxRefundInfo(List<Map<String, Object>> drawbackInfo) {
        try {
            ResultResponse saveResult = this.taxRefundInfoServer.saveTaxRefundInfo(drawbackInfo);
            if (!saveResult.getSuccess().booleanValue()) {
                return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.FALSE, "500", saveResult.getMessage(), saveResult.getData());
            }
        }
        catch (KDBizException e) {
            return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.FALSE, e.getErrorCode().getCode(), e.getErrorCode().getMessage(), new ArrayList());
        }
        return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.TRUE, "200", "success", new ArrayList());
    }

    @Override
    public Map<String, Object> addOrUpdateTaxRefund(List<Map<String, Object>> drawbackInfo) {
        try {
            ResultResponse saveResult = this.taxRefundInfoServer.saveOrUpdateTaxRefund(drawbackInfo);
            if (!saveResult.getSuccess().booleanValue()) {
                return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.FALSE, "500", saveResult.getMessage(), saveResult.getData());
            }
        }
        catch (KDBizException e) {
            return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.FALSE, e.getErrorCode().getCode(), e.getErrorCode().getMessage(), new ArrayList());
        }
        return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.TRUE, "200", "success", new ArrayList());
    }

    @Override
    public Map<String, Object> deleteTaxRefundInfo(List<String> declareNum) {
        try {
            ResultResponse deleteResult = this.taxRefundInfoServer.deleteTaxRefundInfo(declareNum);
            if (!deleteResult.getSuccess().booleanValue()) {
                return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.FALSE, "500", deleteResult.getMessage(), deleteResult.getData());
            }
        }
        catch (KDBizException e) {
            return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.FALSE, e.getErrorCode().getCode(), e.getErrorCode().getMessage(), new ArrayList());
        }
        return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.TRUE, "200", "success", new ArrayList());
    }

    @Override
    public Map<String, Object> queryTaxRefundInfo(List<Long> orgIds, List<String> declareTypes, List<Long> taxTypes, Map<Date, Date> periods) {
        List ids = this.taxRefundInfoServer.queryTaxRefundInfo(orgIds, declareTypes, taxTypes, periods);
        return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.TRUE, "200", "success", ids);
    }

    @Override
    public Map<String, Object> getTaxRefundByBillId(List<String> billIds, String declareTypes, Long taxTypes) {
        QFilter filter = new QFilter("declarenum", "in", billIds).and("taxcategory", "=", (Object)taxTypes).and("declaretype", "=", (Object)declareTypes);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_tax_refund_info", (String)"id", (QFilter[])new QFilter[]{filter});
        return TaxRefundInfoServiceImpl.createReturnResultObject(Boolean.TRUE, "200", "success", collection.stream().map(c -> c.getLong("id")).collect(Collectors.toList()));
    }

    private static Map<String, Object> createReturnResultObject(Boolean success, String code, String message, Object data) {
        HashMap<String, Object> returnResult = new HashMap<String, Object>();
        returnResult.put("success", success);
        returnResult.put("code", code);
        returnResult.put("message", message);
        returnResult.put("data", data);
        return returnResult;
    }
}

